<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/libitem/libitem.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:OFFICITY="http://officity.com" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="OFFICITY:LIBITEM" mode="element-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM" mode="element-application">
		<xsl:text>lib</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>

	<!-- LABEL(s) -->
	<xsl:template match="OFFICITY:LIBITEM" mode="element-label">
		<xsl:apply-templates select="INFO/TITLE" mode="display-value" />
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[(INFO/TYPE='book' or INFO/TYPE='chapter' or INFO/TYPE='page') and 
											DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/TITLE]" mode="element-label">
		<xsl:apply-templates select="DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/TITLE" mode="display-value" />
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book' and 
											not(DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/TITLE)]" mode="element-label">
		<xsl:text>Book details</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='chapter' and 
											not(DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/TITLE)]" mode="element-label">
		<xsl:text>Chapter details</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page' and 
											not(DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/TITLE)]" mode="element-label">
		<xsl:text>Page details</xsl:text>
	</xsl:template>
	
	<!-- ICON(s) -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/ICON='1']" mode="element-icon" priority="1">
		<!-- go up to /Files -->
		<xsl:text>../../Files</xsl:text>
		<xsl:value-of select="substring-before(INFO/PATH,INFO/FILENAME)"/>
        <xsl:text>resources/icon.jpg</xsl:text>
	</xsl:template>

	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/disk-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/folder-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/file-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/book-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='chapter']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/chapter-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/page-16.png</xsl:text>
	</xsl:template>

	<!-- TODO : use INFO/KIND later -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='archive']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/archive-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='audio']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/audio-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='document']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/document-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='image']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/image-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='pdf']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/pdf-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='spreadsheet']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/spreadsheet-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='text']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/text-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='vectors']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/vectors-16.png</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file' and INFO/KIND='video']" mode="element-icon">
        <xsl:text>../system/images/icons/libitems/kinds/video-16.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-info">

	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-info">
		<xsl:apply-templates select="INFO/ITEMS" mode="display-value" />
		<xsl:text> item(s)</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file']" mode="element-info">
		<xsl:apply-templates select="INFO/SIZEHUMAN" mode="display-value" />
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book']" mode="element-info">
		<xsl:call-template name="truncate-phrase">
			<xsl:with-param name="phrase">
				<xsl:apply-templates select="." mode="element-summary" />
			</xsl:with-param>
			<xsl:with-param name="length" select="24" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='chapter']" mode="element-info">
		<xsl:apply-templates select="INFO/ITEMS" mode="display-value" />
		<xsl:text> page(s)</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page']" mode="element-info">
	</xsl:template>
	
	<!-- MISC LABELS : WIKI descriptions -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book' or INFO/TYPE='chapter' or INFO/TYPE='page']" mode="element-summary">
		<xsl:apply-templates select="DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/SUMMARY" />
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book' or INFO/TYPE='chapter' or INFO/TYPE='page']" mode="element-body">
		<xsl:apply-templates select="DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/BODY" />
	</xsl:template>
    
    <!-- NAVIGATION ITEM(s) -->
    
    <!-- DISKS -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-navitem-content">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-content"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- FOLDERS -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-navitem-content">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-content"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- FILES -->
	
	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:LIBITEM" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}-{INFO/TYPE}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[(INFO/TYPE='file') and (INFO/PREVIEW=1)]" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
    	<h2 class="{$module}-{INFO/TYPE}">
			<xsl:attribute name="style">
				<xsl:text>background-image:url("</xsl:text>
				<xsl:value-of select="$filesURL"/>
				<xsl:value-of select="substring-before($item/INFO/PATH,$item/INFO/FILENAME)"/>
				<xsl:text>resources/thumbnail.jpg");</xsl:text>
			</xsl:attribute>
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[(INFO/TYPE='file') and (INFO/PREVIEW!=1) and (INFO/KIND/text())]" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}-{INFO/TYPE}-{INFO/KIND}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>

	<!-- SCRIPTS -->
	<xsl:template match="OFFICITY:LIBITEM" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=</xsl:text>
		<xsl:apply-templates select="." mode="element-editor" />
		<xsl:text disable-output-escaping="yes">&amp;module=libitem</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Officity_LibitemElementOperation</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-create">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=create</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-batchcreate">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=batchCreate</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-update">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=update</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-link">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=link</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-unlink">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=unlink</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-delete">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=delete</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-count">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=count</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-assign-security">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=assignSecurity</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:LIBITEM" mode="element-script-apply-security">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=applySecurity</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM" mode="element-script-sort-deps">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=sortDeps</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-script-detail">
		<xsl:text>documents/DiskDetails</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-script-content">
		<xsl:text>documents/DiskContent</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-script-new">
		<xsl:text>documents/DiskNew</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-script-detail">
		<xsl:text>documents/FolderDetails</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-script-content">
		<xsl:text>documents/FolderContent</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-script-new">
		<xsl:text>documents/FolderNew</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder']" mode="element-script-download">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=downloadFolder</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file']" mode="element-script-detail">
		<xsl:text>documents/FileDetails</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file']" mode="element-script-new">
		<xsl:text>documents/FileNew</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file']" mode="element-script-newversion">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=newVersion</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='file']" mode="element-script-restoreversion">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=restoreVersion</xsl:text>
	</xsl:template>
	
	<!--xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book']" mode="element-script-detail">
		<xsl:text>documents/BookDetails</xsl:text>
	</xsl:template-->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='book']" mode="element-script-content">
		<xsl:text>documents/BookContent</xsl:text>
	</xsl:template>
	
	<!--xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='chapter']" mode="element-script-detail">
		<xsl:text>documents/ChapterDetails</xsl:text>
	</xsl:template-->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='chapter']" mode="element-script-content">
		<xsl:text>documents/ChapterContent</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page']" mode="element-script-detail">
		<xsl:text>documents/PageDetails</xsl:text>
	</xsl:template>
</xsl:stylesheet>