<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/task/task.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="OFFICITY:TASK" mode="element-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:TASK" mode="element-application">
		<xsl:text>tasks</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:TASK" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
	<!-- LABEL(s) -->
	<xsl:template match="OFFICITY:TASK" mode="element-label">
		<xsl:apply-templates select="INFO/TITLE" mode="display-value"/>
	</xsl:template>
	
    <!-- ICON(s) -->
	<xsl:template match="OFFICITY:TASK" mode="element-icon">
        <xsl:text>../system/images/icons/tasks/task-16.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="OFFICITY:TASK" mode="element-info">
	    <xsl:if test="DEPENDENCIES/DEPENDENCY[@type='officity:contexts']/OFFICITY:CONTEXT">
	        <xsl:apply-templates select="DEPENDENCIES/DEPENDENCY[@type='officity:contexts']/OFFICITY:CONTEXT" mode="element-label"/>
	    </xsl:if>
	</xsl:template>

	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:TASK" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="OFFICITY:TASK" mode="element-script-detail">
		<xsl:text>TaskDetails</xsl:text>
	</xsl:template>

	<xsl:template match="OFFICITY:TASK" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=officity</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;module=task</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Officity_TaskElementOperation</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:TASK" mode="element-script-create">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=create</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:TASK" mode="element-script-update">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=update</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:TASK" mode="element-script-link">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=link</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:TASK" mode="element-script-unlink">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=unlink</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:TASK" mode="element-script-delete">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=delete</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:TASK" mode="element-script-count">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=count</xsl:text>
	</xsl:template>
	
    <!--             -->
    <!--   FOLDERS   -->
    <!--             -->

	<!-- ICON(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-icon">
        <xsl:text>../system/images/icons/tasks/folder-16.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-icon-info">
        <xsl:text>../system/images/icons/tasks/info.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-info">
	</xsl:template>
	
	<!-- NAVIGATION ITEM(s) -->
    <xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-navitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">officity__task-folder-<xsl:value-of select="@ID"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:text>FolderContent</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="params">folderID:<xsl:value-of select="@ID"/></xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
			<xsl:with-param name="cssclass">
				<xsl:if test="count(DEPENDENCIES/DEPENDENCY[@type='officity:childtasks']//OFFICITY:TASK[INFO/STATUS!='finished'])=0">
					<xsl:text>no-children</xsl:text>
				</xsl:if>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-listitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">officity__task-folder-<xsl:value-of select="@ID"/></xsl:with-param>
			<xsl:with-param name="title">				
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>				
			</xsl:with-param>
			<xsl:with-param name="params">ID:<xsl:value-of select="@ID"/>,module:'officity:task'</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon-info"/>
			</xsl:with-param>
			<xsl:with-param name="info">
			    <xsl:for-each select="ancestor::OFFICITY:TASK[INFO/TYPE='folder']">				    
				    <xsl:value-of select="INFO/TITLE" />
				    <xsl:if test="position()!=last()">
				    	<xsl:text>/</xsl:text>
				    </xsl:if>
			    </xsl:for-each>
			</xsl:with-param>
			<xsl:with-param name="cssclass" select="'grey-bkgnd'" />
		</xsl:call-template>
	</xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-script-detail">
		<xsl:text>../../system/tools/element/Details</xsl:text>
	</xsl:template>
	
	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='folder']" mode="element-title">
		<h2 class="officity__task-folder">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
    <!--              -->
    <!--   PROJECTS   -->
    <!--              -->
    
    <!-- ICON(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-icon">
        <xsl:text>../system/images/icons/tasks/project.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-icon-info">
        <xsl:text>../system/images/icons/tasks/info.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-info">
	    <xsl:if test="DEPENDENCIES/DEPENDENCY[@type='officity:contexts']/OFFICITY:CONTEXT">
	        <xsl:apply-templates select="DEPENDENCIES/DEPENDENCY[@type='officity:contexts']/OFFICITY:CONTEXT" mode="element-label"/>
	    </xsl:if>
		<xsl:if test="DEPENDENCIES/DEPENDENCY[@type='officity:childtasks']/@hits">
			<xsl:if test="count(DEPENDENCIES/DEPENDENCY[@type='officity:childtasks']/OFFICITY:TASK[INFO/STATUS!='finished'])&gt;0">
				<xsl:text> (</xsl:text>
				<xsl:value-of select="count(DEPENDENCIES/DEPENDENCY[@type='officity:childtasks']/OFFICITY:TASK[INFO/STATUS!='finished'])" />
				<xsl:text>)</xsl:text>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<!-- NAVIGATION ITEM(s) -->
    <xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-navitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">officity__task-project-<xsl:value-of select="@ID"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:text>ProjectContent</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="params">projectID:<xsl:value-of select="@ID"/></xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
			<xsl:with-param name="cssclass">
				<xsl:choose>
					<xsl:when test="INFO/STATUS='suspended' or INFO/STATUS='canceled'">
						<xsl:text>task-</xsl:text>
						<xsl:value-of select="INFO/STATUS" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="count(DEPENDENCIES/DEPENDENCY[@type='officity:childtasks']//OFFICITY:TASK[INFO/STATUS!='finished'])=0">
							<xsl:text>no-children</xsl:text>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-listitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">officity__task-project-<xsl:value-of select="@ID"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">ID:<xsl:value-of select="@ID"/>,module:'officity:task'</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon-info"/>
			</xsl:with-param>
			<xsl:with-param name="info">
			    <xsl:for-each select="ancestor::OFFICITY:TASK[INFO/TYPE='folder']">				    
				    <xsl:value-of select="INFO/TITLE" />
				    <xsl:if test="position()!=last()">
				    	<xsl:text>/</xsl:text>
				    </xsl:if>
			    </xsl:for-each>
			</xsl:with-param>
			<xsl:with-param name="cssclass" select="'grey-bkgnd'" />
		</xsl:call-template>
	</xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-script-detail">
		<xsl:text>ProjectDetails</xsl:text>
	</xsl:template>
	
	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='project']" mode="element-title">
		<h2 class="officity__task-project">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>

    <!--             -->
    <!--   ACTIONS   -->
    <!--             -->
    
    <!-- ICON(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='action']" mode="element-icon">
        <xsl:text>../system/images/icons/tasks/action-16.png</xsl:text>
	</xsl:template>
    
   <!-- NAVIGATION ITEM(s) -->
    <xsl:template match="OFFICITY:TASK[INFO/TYPE='action']" mode="element-navitem">        
        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="id">
                <xsl:text>officity__task-action-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">
                <xsl:apply-templates select="." mode="element-script-detail"/>
            </xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>ID:</xsl:text>
                <xsl:value-of select="@ID"/>
                <xsl:text>,module:'officity:task'</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="." mode="element-info"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
            <xsl:with-param name="cssclass">
            	<xsl:apply-templates select="." mode="element-css" />
            </xsl:with-param>
            <xsl:with-param name="leftactions-elems">
	            <a href="#">
	            	<xsl:attribute name="class">
	            		<xsl:apply-templates select="." mode="status-css" />
	            	</xsl:attribute>
	            	<xsl:attribute name="title">
	            		<xsl:apply-templates select="." mode="status-title" />
	            	</xsl:attribute>
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'togglestatus'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-update" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
            </xsl:with-param>
			<xsl:with-param name="rightactions-elems">
	            <a href="#">
	            	<xsl:attribute name="class">
	            		<xsl:apply-templates select="." mode="mark-css" />
	            	</xsl:attribute>
	            	<xsl:attribute name="title">
	            		<xsl:apply-templates select="." mode="mark-title" />
	            	</xsl:attribute>
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'togglemark'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-update" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
 
    <xsl:template match="OFFICITY:TASK[INFO/TYPE='action']" mode="element-css">
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/STATUS='canceled')]" mode="element-css">
        <xsl:text>task-canceled</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/STATUS='suspended')]" mode="element-css">
        <xsl:text>task-suspended</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/STATUS='finished')]" mode="element-css">
        <xsl:text>task-finished</xsl:text>
    </xsl:template>
    
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/STATUS!='finished')]" mode="status-css">
        <xsl:text>checked</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/FLAG!='finished')]" mode="status-title">
        <xsl:text>Finish</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/STATUS='finished')]" mode="status-css">
        <xsl:text>unchecked</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/FLAG='finished')]" mode="status-title">
        <xsl:text>Run</xsl:text>
    </xsl:template>
    
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/FLAG='1')]" mode="mark-css">
        <xsl:text>unmark</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/FLAG='1')]" mode="mark-title">
        <xsl:text>Unmark</xsl:text>
    </xsl:template>

    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/FLAG='0')]" mode="mark-css">
        <xsl:text>mark</xsl:text>
    </xsl:template>
    <xsl:template match="OFFICITY:TASK[(INFO/TYPE='action') and (INFO/FLAG='0')]" mode="mark-title">
        <xsl:text>Mark</xsl:text>
    </xsl:template>

	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='action']" mode="element-title">
		<h2 class="officity__task-action">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>

    <!--            -->
    <!--   POINTS   -->
    <!--            -->
    
    <!-- ICON(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='point']" mode="element-icon">
        <xsl:text>../system/images/icons/tasks/point-16.png</xsl:text>
	</xsl:template>

	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:TASK[INFO/TYPE='point']" mode="element-title">
		<h2 class="officity__task-point">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
</xsl:stylesheet>
