<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/wiki/wiki.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="OFFICITY:WIKI" mode="element-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:WIKI" mode="element-application">
		<xsl:text>wiki</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:WIKI" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
	<!-- LABEL(s) -->
    <xsl:template match="OFFICITY:WIKI" mode="element-label">
		<xsl:apply-templates select="DESCRIPTIONS/DESCRIPTION/TITLE" mode="display-value"/>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="OFFICITY:WIKI[INFO/TYPE='book']" mode="element-icon">
        <xsl:text>../system/images/icons/wiki/book.png</xsl:text>
	</xsl:template>

	<xsl:template match="OFFICITY:WIKI[INFO/TYPE='section']" mode="element-icon">
        <xsl:text>../system/images/icons/wiki/section.png</xsl:text>
	</xsl:template>

	<xsl:template match="OFFICITY:WIKI[INFO/TYPE='text']" mode="element-icon">
        <xsl:text>../system/images/icons/wiki/text.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
    <xsl:template match="OFFICITY:WIKI" mode="element-info">
		<xsl:apply-templates select="DESCRIPTIONS/DESCRIPTION/HEADER"/>
	</xsl:template>
	
	<!-- NAVIGATION ITEM(s) -->
	
	<!-- TITLE(s) -->
	<xsl:template match="OFFICITY:WIKI[INFO/TYPE='book']" mode="element-title">
	    <h3 class="book"><xsl:apply-templates select="." mode="element-label"/></h3>
    </xsl:template>

    <xsl:template match="OFFICITY:WIKI[INFO/TYPE='section']" mode="element-title">
	    <h3 class="section"><xsl:apply-templates select="." mode="element-label"/></h3>
    </xsl:template>

	<xsl:template match="OFFICITY:WIKI[INFO/TYPE='text']" mode="element-title">
	    <h3 class="text"><xsl:apply-templates select="." mode="element-label"/></h3>
    </xsl:template>

	<!--  SCRIPTS -->
    <xsl:template match="OFFICITY:WIKI[INFO/TYPE='book']" mode="element-script-detail">
		<xsl:text>ContentList</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:WIKI[INFO/TYPE='section']" mode="element-script-detail">
		<xsl:text>ContentList</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:WIKI[INFO/TYPE='text']" mode="element-script-detail">
		<xsl:text>PageView</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:WIKI[INFO/TYPE='text']" mode="element-script-detail-edit">
		<xsl:text>PageEdit</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:WIKI" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=officity</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;module=wiki</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Officity_WikiElementOperation</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:WIKI" mode="element-script-create">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=create</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:WIKI" mode="element-script-update">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=update</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:WIKI" mode="element-script-addfile">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=addFile</xsl:text>
	</xsl:template>

	<xsl:template match="OFFICITY:WIKI" mode="element-script-save-sorted">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=saveSorted</xsl:text>
	</xsl:template>
</xsl:stylesheet>
