<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/contact/contact.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="CONTACT" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="CONTACT" mode="element-application">
		<xsl:text>directory</xsl:text>
	</xsl:template>
	<xsl:template match="CONTACT" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
	<!-- LABEL(s) -->
	<xsl:template match="CONTACT" mode="element-label">
		<xsl:apply-templates select="INFO/LASTNAME" mode="display-value" />
		<xsl:text> </xsl:text>
		<xsl:apply-templates select="INFO/FIRSTNAME" mode="display-value" />
		<xsl:if test="INFO/MIDDLENAME/text()">
			<xsl:text>, </xsl:text>
			<xsl:value-of select="INFO/MIDDLENAME" />
		</xsl:if>
		<xsl:if test="INFO/DENOMINATION/text()">
			<xsl:text> (</xsl:text>
			<xsl:value-of select="INFO/DENOMINATION" />
			<xsl:text>)</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="CONTACT[parent::CREATOR or parent::MODIFIER or parent::OWNER or parent::OWNERS]" mode="element-label">
		<xsl:apply-templates select="@lastname" mode="display-value" />
		<xsl:text> </xsl:text>
		<xsl:apply-templates select="@firstname" mode="display-value" />
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="CONTACT" mode="element-icon">
        <xsl:text>../system/images/icons/contacts/contact-black-18.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="CONTACT" mode="element-info">
        <xsl:value-of select="INFO/EMAIL1"/>
        <xsl:text> (</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>)</xsl:text>
	</xsl:template>
    
    <!-- NAVIGATION ITEM(s) -->
	<xsl:template match="CONTACT" mode="element-navitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>

		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="@ID"/>
				<xsl:text>,module:'</xsl:text>
				<xsl:value-of select="name(.)" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- TITLE(s) -->
	<xsl:template match="CONTACT" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>

	<!-- SCRIPTS -->
	<xsl:template match="CONTACT" mode="element-script-detail">
		<xsl:text>contacts/Details</xsl:text>
	</xsl:template>

	<xsl:template match="CONTACT" mode="element-script-new">
		<xsl:text>contacts/New</xsl:text>
	</xsl:template>
		
	<xsl:template match="CONTACT" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=sushee</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;module=contact</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Sushee_ContactElementOperation</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-create">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=create</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-update">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=update</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-link">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=link</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-unlink">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=unlink</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-delete">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=delete</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-count">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=count</xsl:text>
	</xsl:template>

    <xsl:template match="CONTACT" mode="element-script-remove-preview">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=removePreview</xsl:text>
    </xsl:template>
    
    <xsl:template match="CONTACT" mode="element-script-sort-deps">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=sortDeps</xsl:text>
    </xsl:template>
    
    <xsl:template match="CONTACT" mode="element-script-add-keyring">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=addKeyring</xsl:text>
    </xsl:template>
    
    <xsl:template match="CONTACT" mode="element-script-remove-keyring">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=removeKeyring</xsl:text>
    </xsl:template>
    
    <xsl:template match="CONTACT" mode="element-script-check4create">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=check4Create</xsl:text>
    	<xsl:text disable-output-escaping="yes">&amp;output=html</xsl:text>
    </xsl:template>

    <xsl:template match="CONTACT" mode="element-script-fetch-json">
    	<xsl:text>../shared/contact/fetch-json.php</xsl:text>
    </xsl:template>
    
    <!--  SOCIETY  -->

	<!-- LABEL(s) -->
    <xsl:template match="CONTACT[INFO/CONTACTTYPE='PM']" mode="element-label">
		<xsl:apply-templates select="INFO/DENOMINATION" mode="display-value" />
	</xsl:template>
	
	<xsl:template match="CONTACT[INFO/CONTACTTYPE='PM' and (parent::CREATOR or parent::MODIFIER or parent::OWNER or parent::OWNERS)]" mode="element-label">
		<xsl:apply-templates select="@denomination" mode="display-value" />
	</xsl:template>
	
	<xsl:template match="CONTACT[@contacttype='PM']" mode="element-label">
		<xsl:apply-templates select="@denomination" mode="display-value" />
	</xsl:template>

	<!-- ICON(s) -->
    <xsl:template match="CONTACT[INFO/CONTACTTYPE='PM']" mode="element-icon">
        <xsl:text>../system/images/icons/contacts/society.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="CONTACT[INFO/CONTACTTYPE='PM']" mode="element-info">
        <xsl:value-of select="INFO/EMAIL1"/>
        <xsl:text> (</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>)</xsl:text>
	</xsl:template>

	<!-- TITLE(s) -->
	<xsl:template match="CONTACT[INFO/CONTACTTYPE='PM']" mode="element-title">
		<h2 class="society">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
</xsl:stylesheet>
