<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/contact/fetch-json.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>

	<xsl:output encoding="UTF-8" method="text" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/RESPONSE">
        <xsl:variable name="list" select="RESULTS[@name='list']"/>
        
		<xsl:choose>
			<xsl:when test="count($list/*)>0">
                <xsl:text>[</xsl:text>
                <xsl:for-each select="$list/*">
                    <xsl:text>{</xsl:text>                       
                    <xsl:text>"id":"</xsl:text>
                    <xsl:value-of select="@ID"/>
                    <xsl:text>","label":"</xsl:text>
                    <!--xsl:call-template name="escape-javascript">
                        <xsl:with-param name="string"-->
                            <xsl:apply-templates select="." mode="element-label" />
                        <!--/xsl:with-param>
                    </xsl:call-template-->
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="@ID"/>
                    <xsl:text>)"</xsl:text>
                    <xsl:text>}</xsl:text>
                    <xsl:if test="position()!=last()">
                        <xsl:text>,</xsl:text>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>]</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>[{"id":"","label":"No match"}]</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>