<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/field/field.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="FIELD" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="FIELD" mode="element-application">
		<xsl:text>factory</xsl:text>
	</xsl:template>
	<xsl:template match="FIELD" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="FIELD" mode="element-label">
        <xsl:value-of select="INFO/DENOMINATION" />
       	<xsl:text> - </xsl:text>
       	<xsl:apply-templates select="INFO/TYPE" mode="display-value"/>
	</xsl:template>
	
	<xsl:template match="FIELD[INFO/DISPLAYABLE=0]" mode="element-label">
		<span style="color:#666">
	        <xsl:value-of select="INFO/DENOMINATION" />
	       	<xsl:text> - </xsl:text>
	       	<xsl:apply-templates select="INFO/TYPE" mode="display-value"/>
		</span>
	</xsl:template>
	
	<!-- ICON(s) -->
	<xsl:template match="FIELD" mode="element-icon">
		<xsl:text>../system/images/icons/fields/field-16.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="FIELD[INFO/SEARCHABLE=1]" mode="element-icon">
		<xsl:text>../system/images/icons/fields/searchable-16.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="FIELD" mode="element-info">
		<xsl:variable name="isSusheeField">
			<xsl:apply-templates select="." mode="is-sushee-field" />
		</xsl:variable>
		<xsl:if test="$isSusheeField='true'">
			<xsl:text>Sushee</xsl:text>
		</xsl:if>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="FIELD" mode="element-navitem-parms">
        <xsl:text>ID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>,module:'</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>',denomination:'</xsl:text>
        <xsl:value-of select="INFO/DENOMINATION"/>
        <xsl:text>',targetModuleDenom:'</xsl:text>
        <xsl:value-of select="INFO/MODULE"/>
        <xsl:text>'</xsl:text>
    </xsl:template>
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="FIELD" mode="element-script-detail">
		<xsl:text>modules/FieldDetails</xsl:text>
	</xsl:template>

	<xsl:template match="FIELD" mode="element-script-new">
		<xsl:text>modules/FieldNew</xsl:text>
	</xsl:template>
	
	<xsl:template match="FIELD" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=sushee</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;module=field</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Sushee_FieldElementOperation</xsl:text>
	</xsl:template>
</xsl:stylesheet>