<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/mailing/mailing.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/    
	class Sushee_MailingElement extends Element
	{
		function __construct($ID=0)
		{
			parent::__construct('MAILING', $ID);
		}

		function __destruct()
		{
			parent::__destruct();
		}
		
		public function setDisplayProfile()
		{
			$this->setReturn(array(
		        'INFO/DENOMINATION',
				'INFO/STATUS',
				'INFO/SENDERNAME',
				'INFO/SENDINGDATE'
    		));
		}
		
		/* *** */
		
        protected function buildRecipientsSearch()
        {
            if ($this->get() == false)
            {
                return false;
            }

            $filter = new FilterElement();
            $filter->reset(); // remove QUERYXML, DISPLAYXML, ISQUERY, ISDISPLAY
            $filter->setDependencyByName('officity:mailingFilter', 'MAILING', $this->getID(), 'reverse');
            if ($filter->find() == false)
            {
                return false;
            }
            
            $recps_search_node = $this->getInfoNode('RECIPIENTSSEARCH');
            $recps_search_node->removeChild('./SEARCH'); // just in case

            $filter_query_node = $filter->getInfoNode('./QUERYXML');
            
            $element_name = strtoupper($filter_query_node->getElement('./*[1]')->nodeName());
            if ($element_name != 'CONTACT')
            {
            	$filter_query_node->getElement('.//INFO[1]')->appendChild('<'.$element_name.'>1</'.$element_name.'>');
            }
            
            $search_string = '<SEARCH name="searchContact">'.$filter_query_node->toString('./*').'</SEARCH>';
            $recps_search_node->appendChild($search_string);
            //$this->logCommand();

            return $filter;
        }

        function send(&$search_filter)
        {
            $search_filter = $this->buildRecipientsSearch();
            if ($search_filter === false)
            {
                return false;
            }

            $this->setInfo('STATUS', 'pending');

            return $this->update();
        }
        
        /* *** */

        public function destroy()
        {
            $nql = new Sushee_Shell(false);
            $nql->addCommand('
                <KILL>
                    <OFFICITY:FILTER>
                        <WHERE>
                            <DEPENDENCY type="officity:mailingFilter" mode="reverse">
                                <MAILING ID="'.$this->getID().'"/>
                            </DEPENDENCY>
                        </WHERE>
                    </OFFICITY:FILTER>
                </KILL>
            ');
            $nql->execute();

            return parent::destroy();
        }
	}

?>
