<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/mailing/mailing.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="MAILING" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="MAILING" mode="element-application">
		<xsl:text>spray</xsl:text>
	</xsl:template>
	<xsl:template match="MAILING" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
	<!-- LABEL(s) -->
	<xsl:template match="MAILING" mode="element-label">
		<xsl:apply-templates select="INFO/DENOMINATION" mode="display-value" />
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="MAILING" mode="element-icon">
        <xsl:text>../system/images/icons/spray/spray-18.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="MAILING[INFO/STATUS='edition']" mode="element-icon">
        <xsl:text>../system/images/icons/spray/draft.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="MAILING[INFO/STATUS='pending' or INFO/STATUS='sending']" mode="element-icon">
        <xsl:text>../system/images/icons/spray/sending.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="MAILING[INFO/STATUS='sent']" mode="element-icon">
        <xsl:text>../system/images/icons/spray/sent.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="MAILING" mode="element-info">
        <xsl:apply-templates select="INFO/SENDERNAME" />
        <xsl:text> - </xsl:text>
        <xsl:apply-templates select="INFO/SENDINGDATE" mode="date"/>
	</xsl:template>
    
    <!-- NAVIGATION ITEM(s) -->
	
	<!-- TITLE(s) -->
	<xsl:template match="MAILING" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}-{INFO/STATUS}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>

	<!-- SCRIPTS -->
	
</xsl:stylesheet>
