<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/CSV.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/* *** */
	
	/*
	 * CSV Class
	 * 
	 * @since	2010-08-09
	 *
	*/

	class CSV
	{
		private static $separator = ';';
		private static $eol;

		private $file_name, $file_handle;
		private $data_line;

		function __construct()
		{
			self::$eol = chr(10);//.chr(13);
			$this->file_handle = false;
			$this->init('');
		}

		function init($file_name, $open_mode='w')
		{
			if ($this->file_handle != false)
			{
				fclose($this->file_handle);
				$this->file_handle = false;
				$this->file_name = '';
			}

			if (!empty($file_name))
			{
				$this->file_name = $file_name;
				$this->file_handle = fopen($this->file_name, $open_mode);
			}

			$this->data_line = '';
			//$this->data_line = "\xEF\xBB\xBF"; // BOM: indicates the file is UTF-8 on Unix-like operating systems
		}

		function addRawData($data) // for optim purpose
		{
			$csv_data = str_replace('"', '""', $data); // safe
			$csv_data = '"'.$csv_data.'"'.CSV::$separator;

			$this->data_line .= $csv_data;
		}

		function addLastRaw_data($data) // for optim purpose
		{
			$csv_data = str_replace('"', '""', $data); // safe
			$csv_data = '"'.$csv_data.'"'.CSV::$eol;
			
			$this->data_line .= $csv_data;
		}

		function addData($data)
		{
			$csv_data = entities_to_utf8($data);
			$csv_data = decode_from_xml($csv_data);
			$csv_data = utf8_decode($csv_data);

			$csv_data = str_replace('"', '""', $csv_data); // safe
			$csv_data = '"'.$csv_data.'"'.CSV::$separator;

			$this->data_line .= $csv_data;
		}

		function addLastData($data)
		{
			$csv_data = entities_to_utf8($data);
			$csv_data = decode_from_xml($csv_data);
			$csv_data = utf8_decode($csv_data);

			$csv_data = str_replace('"', '""', $csv_data); // safe
			$csv_data = '"'.$csv_data.'"'.CSV::$eol;

			$this->data_line .= $csv_data;
		}

		function encodeRawDataLine() // for optim purpose
		{
			$this->data_line = entities_to_utf8($this->data_line);
			$this->data_line = decode_from_xml($this->data_line);
			$this->data_line = utf8_decode($this->data_line);
		}

		function write($encode_line=false)
		{
			if ($encode_line == true)
			{
				$this->encode_raw_data_line();
			}

			fwrite($this->file_handle, $this->data_line);
			$this->data_line = '';
		}

		function writeHeaders($headers, $encode_line=true)
		{
			$headers_count = count($headers);

			for ($i=0; $i<$headers_count-1; $i++)
			{
				$this->addRawData($headers[$i]);
			}

			$this->addLastRawData($headers[$headers_count-1]);

			$this->write($encode_line);
		}

		function done()
		{
			$this->init('');
		}

		static function setSeparator($sep)
		{
			CSV::$separator = $sep;
		}

		static function setEOL($eol)
		{
			CSV::$eol = $eol;
		}
	}
?>