<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/OfficitySpringboard.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/		
	/* *** */
	
	/*
	 * Springbord Class
	 * 
	 * @since	2010-12-14
	 *
	*/
	
	class Officity_Springboard
	{
		protected $DEFAULT_CONFIG = array(
			'editorFolder' 			=> EDITOR_FOLDER,
			'editorName' 			=> EDITOR_NAME,
			'appFolder' 			=> APP_FOLDER,
			'appName' 				=> APP_NAME,
			'controllerName' 		=> 'AppController',
			'optimalColumnWidth' 	=> '480',
			'homePanelURI' 			=> 'HomePanel',
			'homePaneltitle' 		=> 'Home',
			'homeIcon'				=> '',
			'homeParams'			=> '',
			'templatePath'			=> '',
			'environment'			=> SYSTEM_ENV
		);
			
		protected $shell, $config;
		protected $editor_path, $app_path, $app_tpl_path;
		
		function __construct()
		{
			$this->shell = new Officity_Shell(false);
		}
		
		function __destruct()
		{
			unset($this->shell);
		}
		
		protected function addConfigToShellCommand()
		{	
			$this->shell->addStatic('
				<SHELLCONFIG>
					<EDITORFOLDER>'.$this->config['editorFolder'].'</EDITORFOLDER>
					<EDITORNAME>'.$this->config['editorName'].'</EDITORNAME>
					<APPFOLDER>'.$this->config['appFolder'].'</APPFOLDER>
					<APPNAME>'.$this->config['appName'].'</APPNAME>
					<CONTROLLERNAME>'.$this->config['controllerName'].'</CONTROLLERNAME>
					<OPTIMALCOLUMNWIDTH>'.$this->config['optimalColumnWidth'].'</OPTIMALCOLUMNWIDTH>
					<HOMEPANELURI>'.$this->config['homePanelURI'].'</HOMEPANELURI>
					<HOMEPANELTITLE>'.$this->config['homePaneltitle'].'</HOMEPANELTITLE>
					<HOMEICON>'.$this->config['homeIcon'].'</HOMEICON>
					<HOMEPARAMS>'.$this->config['homeParams'].'</HOMEPARAMS>
					<ENVIRONMENT>'.$this->config['environment'].'</ENVIRONMENT>
				</SHELLCONFIG>
			', 
				'shell-config'
			);
		}
				
		public function setConfig($config)
		{	
			$this->config = array_merge($this->DEFAULT_CONFIG, $config);	
			
			if (empty($this->config['homeIcon']))
			{
				$this->config['homeIcon'] = SYSTEM_IMAGES_URL.'/menu/history/appbar-home.png';
			}
			
			if (empty($this->config['templatePath']))
			{
				$this->editor_path = APPS_PATH.$this->config['editorFolder'].'/';
				$this->app_path = $this->editor_path.$this->config['appFolder'].'/';
				$this->app_tpl_path = $this->app_path.'app.xsl';
			}
			else
			{
				$this->app_tpl_path = $this->config['templatePath'];
			}
		}
		
		public function addShellCommand($command)
		{
			$this->shell->addCommand($command);
		}
		
		public function display()
		{
			$this->addConfigToShellCommand();
			
		    $this->shell->addCommand('
				<SEARCH name="visitorKeyring">
					<KEYRING>
						<DEPENDENCIES>
							<DEPENDENCY type="keyringUsers">
								<CONTACT ID="visitor" />
							</DEPENDENCY>
						</DEPENDENCIES>
					</KEYRING>
					<RETURN depth="2">
						<DEPENDENCIES>
							<DEPENDENCY type="keyringAppKeys">
								<INFO>
									<APPLICATIONTOID />
								</INFO>
							</DEPENDENCY>
						</DEPENDENCIES>
					</RETURN>
				</SEARCH>
		    ');
		    
		    $this->shell->addCommand('
				<SEARCH name="applications">
					<APP>
						<INFO>
							<URL operator ="NE"></URL>
						</INFO>
					</APP>
					<RETURN depth="2">
						<INFO>
							<DENOMINATION />
							<URL />
							<ICON />
							<DOCKABLE />
						</INFO>
						<DEPENDENCIES>
							<DEPENDENCY type="officity:appNamespaces">
								<INFO>
									<NAMESPACE />
									<EDITOR />
								</INFO>
							</DEPENDENCY>
						</DEPENDENCIES>
					</RETURN>
				</SEARCH>
		    ');
			
			die($this->shell->transform($this->app_tpl_path));
		}
	}
?>