SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

CREATE TABLE IF NOT EXISTS `officity:reports` (
  `ID` int(10) NOT NULL auto_increment,
  `Activity` tinyint(1) default '1',
  `Module` varchar(128) default NULL,
  `Model` tinyint(1) NOT NULL default '0',
  `Apply` enum('all','search','get') NOT NULL default 'all',
  `Fixed` tinyint(1) NOT NULL default '0',
  `Title` varchar(255) NOT NULL,
  `Date` date NOT NULL default '0000-00-00',
  `Type` enum('pdf','csv') NOT NULL default 'pdf',
  `QueryXML` text NOT NULL,
  `DisplayXML` text NOT NULL,
  `Format` enum('A4','A3', 'Other') NOT NULL default 'A4',
  `Orientation` enum('portrait','landscape') NOT NULL default 'portrait',
  `Template` varchar(255) NOT NULL,
  `File` varchar(255) NOT NULL,
  `Fontsize` smallint(2) NOT NULL default '100',
  `Header` varchar(512) NOT NULL,
  `Footer` varchar(512) NOT NULL,
  `IsLocked` tinyint(1) default '0',
  `CreatorID` int(10) default '0',
  `OwnerID` int(10) default '0',
  `GroupID` int(10) default '0',
  `ModifierID` int(10) default '0',
  `CreationDate` datetime default '0000-00-00 00:00:00',
  `ModificationDate` datetime default '0000-00-00 00:00:00',
  `SearchText` text,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC ;

INSERT INTO `officity:reports` (`ID`, `Activity`, `Module`, `Model`, `Apply`, `Fixed`, `Title`, `Date`, `Type`, `QueryXML`, `DisplayXML`, `Format`, `Orientation`, `Template`, `File`, `Fontsize`, `Header`, `Footer`, `IsLocked`, `CreatorID`, `OwnerID`, `GroupID`, `ModifierID`, `CreationDate`, `ModificationDate`, `SearchText`) VALUES
(1, 1, NULL, 0, 'all', 0, '', '0000-00-00', 'pdf', '', '', 'A4', 'portrait', '', '', 100, '', '', 0, 0, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL),
(2, 1, 'contact', 1, 'search', 0, 'Basic Report', '0000-00-00', 'pdf', '', '<RETURN><INFO><LASTNAME order="1"/><FIRSTNAME order="2"/><MIDDLENAME order="3"/><EMAIL1 order="4"/></INFO></RETURN><SORT select="INFO/LASTNAME" order="ascending"/>', 'A4', 'portrait', '', '', 0, '', '', 0, 2, 2, 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', ''),
(3, 1, 'contact', 1, 'search', 1, 'Avery Stickers', '0000-00-00', 'pdf', '', '<RETURN><INFO><LASTNAME order="1"/><FIRSTNAME order="2"/><MIDDLENAME order="3"/><ADDRESS order="4"/><STATEORPROVINCE order="5"/><CITY order="6"/><POSTALCODE order="7"/><COUNTRYID order="8"/></INFO></RETURN><SORT select="INFO/LASTNAME" order="ascending"/>', 'Other', 'portrait', 'pdf/stickers_avery.xsl', '', 100, '', '', 0, 0, 0, 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', ''),
(4, 1, 'contact', 1, 'search', 0, 'Basic export', '0000-00-00', 'csv', '', '<RETURN><INFO><LASTNAME order="1"/><FIRSTNAME order="2"/><MIDDLENAME order="3"/><EMAIL1 order="4"/></INFO></RETURN><SORT select="INFO/LASTNAME" order="ascending"/>', 'A4', 'portrait', '', '', 0, '', '', 0, 0, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', ''),
(5, 1, 'contact', 1, 'all', 0, 'Extended export', '0000-00-00', 'csv', '', '', 'A4', 'portrait', 'csv/generic-csv-export-alt.xsl', '', 0, '', '', 0, 2, 0, 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '');

INSERT INTO `officity:reports` (`ID`, `Activity`, `Module`, `Model`, `Apply`, `Fixed`, `Title`, `Date`, `Type`, `QueryXML`, `DisplayXML`, `Format`, `Orientation`, `Template`, `File`, `Fontsize`, `Header`, `Footer`, `IsLocked`, `CreatorID`, `OwnerID`, `GroupID`, `ModifierID`, `CreationDate`, `ModificationDate`, `SearchText`) VALUES
(6, 1, 'officity:task', 1, 'search', 0, 'Basic Report', '0000-00-00', 'pdf', '', '<RETURN><INFO><TYPE order="1"/><TITLE order="2"/><STATUS order="3"/><STARTDATE order="4"/><DUEDATE order="5"/><COMPLETED order="6"/><ROOT order="7"/></INFO></RETURN><SORT select="INFO/TYPE" order="descending"/><PAGINATE display="250" page="1"/>', 'A4', 'portrait', '', '', 0, '', '', 0, 2, 2, 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', ''),
(7, 1, 'officity:task', 1, 'search', 0, 'Basic export', '0000-00-00', 'csv', '', '<RETURN><INFO><TYPE order="1"/><TITLE order="2"/><STATUS order="3"/><STARTDATE order="4"/><DUEDATE order="5"/><COMPLETED order="6"/><ROOT order="7"/></INFO></RETURN><SORT select="INFO/TYPE" order="descending"/><PAGINATE display="250" page="1"/>', 'A4', 'portrait', '', '', 0, '', '', 0, 0, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', ''),
(8, 1, 'officity:task', 1, 'all', 0, 'Extended export', '0000-00-00', 'csv', '', '', 'A4', 'portrait', 'csv/generic-csv-export-alt.xsl', '', 0, '', '', 0, 2, 0, 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '')