CREATE TABLE IF NOT EXISTS `officity:tasks` (
  `ID` int(10) NOT NULL auto_increment,
  `Activity` tinyint(1) NOT NULL default '1',
  `Type` enum('action','project','folder','point','root') NOT NULL default 'action',
  `Title` varchar(254) default NULL,
  `Status` enum('running','suspended','finished','canceled') NOT NULL default 'running',
  `StartDate` date default NULL,
  `DueDate` date default NULL,
  `BestEstimate` mediumint(9) NOT NULL default '0',
  `WorstEstimate` int(11) NOT NULL default '0',
  `Completed` tinyint(1) unsigned NOT NULL default '0' COMMENT 'percent',
  `Duration` mediumint(9) unsigned NOT NULL default '0' COMMENT 'minutes',
  `Flag` enum('0','1') NOT NULL default '0',
  `Comment` varchar(1024) default NULL,
  `Notes` tinytext,
  `File` varchar(255) default NULL,
  `Image` varchar(255) default NULL,
  `IsLocked` tinyint(1) NOT NULL default '0',
  `CreatorID` int(10) unsigned NOT NULL default '0',
  `UserID` int(10) unsigned NOT NULL default '0',
  `OwnerID` int(10) unsigned NOT NULL default '0',
  `GroupID` int(10) unsigned NOT NULL default '0',
  `ModifierID` int(10) unsigned NOT NULL default '0',
  `CreationDate` datetime default '0000-00-00 00:00:00',
  `ModificationDate` datetime default '0000-00-00 00:00:00',
  `SearchText` text,
  PRIMARY KEY  (`ID`),
  FULLTEXT KEY `SearchText` (`SearchText`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;

INSERT INTO `officity:tasks` 
(`ID`, `Activity`, `Type`, `Title`, `Status`, `StartDate`, `DueDate`, `BestEstimate`, `WorstEstimate`, `Completed`, `Duration`, `Flag`, `Comment`, `Notes`, `File`, `Image`, `IsLocked`, `CreatorID`, `UserID`, `OwnerID`, `GroupID`, `ModifierID`, `CreationDate`, `ModificationDate`, `SearchText`) 
VALUES 
(NULL, '1', 'root', 'Root folder', 'running', NULL, NULL, '0', '0', '0', '0', '0', NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL);

CREATE TABLE IF NOT EXISTS `officity:contexts` (
  `ID` int(11) NOT NULL auto_increment,
  `Activity` tinyint(1) NOT NULL default '1',
  `Title` varchar(128) default NULL,
  `Status` enum('active','suspended','inactive') NOT NULL default 'active',
  `Type` enum('','root') NOT NULL,
  `Comment` varchar(512) default NULL,
  `IsLocked` enum('0','1') NOT NULL default '0',
  `CreatorID` int(10) unsigned NOT NULL default '0',
  `OwnerID` int(10) unsigned NOT NULL default '0',
  `GroupID` int(10) unsigned NOT NULL default '0',
  `ModifierID` int(10) unsigned NOT NULL default '0',
  `CreationDate` datetime default '0000-00-00 00:00:00',
  `ModificationDate` datetime default '0000-00-00 00:00:00',
  `SearchText` text,
  PRIMARY KEY  (`ID`),
  FULLTEXT KEY `SearchText` (`SearchText`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

INSERT INTO `officity:contexts` (`ID`, `Activity`, `Title`, `Status`, `Type`, `Comment`, `IsLocked`, `CreatorID`, `OwnerID`, `GroupID`, `ModifierID`, `CreationDate`, `ModificationDate`, `SearchText`) VALUES
(1, 1, NULL, 'active', '', NULL, '0', 0, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL);