/**
  * Data Checker Class
  *
  * @author  Marc Mignonsin
  * @version 2010-12-16
  *
  */

DataChecker = function(panelID, controller, script, formID)
{
	//window.log('DataChecker', arguments); 
	$('#'+panelID+'.panel').panel('addExternalResource', this, null);
	
	this.reset(); // just in case

    this.formManager = new FormManager(panelID, controller, script, 'html');
    this.formManager.setActiveForm('#'+formID);
    this.addDefaultValues(formID);

    this.panelID = panelID;
    
	//window.log(this);
	return this;
};

DataChecker.prototype.formManager = null;
DataChecker.prototype.panelID = null;

DataChecker.prototype.reset = function()
{
	//window.log('DataChecker.reset', arguments);
	this.formManager = null;
    this.panelID = null;
};

DataChecker.prototype.destroy = function()
{
	//window.log('DataChecker.destroy', arguments);
};

/* *** */

DataChecker.prototype.addDefaultValues = function(formID)
{
    //window.log('DataChecker.addDefaultValues', arguments);
	var fm = this.formManager;
	
	$('#'+formID).find(':text').each(function(){		
		$(this).defaultInputValue($(this).attr('default-value'), $(this).attr('default-color')); // jQuery extension
		fm.addDefaultValue($(this).attr('name'), $(this).attr('default-value'));
	});    
};

DataChecker.prototype.proceed = function(formSelector, script)
{
    //window.log('DataChecker.proceed', arguments);	
	this.formManager.parse();
    
    this.formManager.onSuccess(delegate(this, function(response){
    	$('div#'+this.panelID+'.panel').trigger('panel-displayloader', [false, 'body']).trigger('panel-blockcontent', ['.block-nav', response]);
    }));
    
    this.formManager.onError(delegate(this, function(response){
    	$('div#'+this.panelID+'.panel').trigger('panel-displayloader', [false, 'body']).trigger('panel-blockcontent', ['.block-nav', response]);
    }));

    $('div#'+this.panelID+'.panel').trigger('panel-displayloader', [true, 'body']);
    
    return this.formManager.send();
};