<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/js/load-js.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/../system.include.php');

	/* *** */

	function compress($buffer)
	{ 
		/* remove comments */
		$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
		
		/* remove tabs, spaces, newlines, etc. */
		$buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '	', '	'), '', $buffer);

		return $buffer;
	}

	function loadJS($js_dir, $required_files)
	{
		$dir_handle = opendir($js_dir);

		$js_files = $required_files;

		/*while ($current_file = readdir($dir_handle))
		{
			if (is_file($js_dir.$current_file))
			{
				$file_ext = pathinfo($current_file, PATHINFO_EXTENSION);

				if ($file_ext == 'js')
				{
					if (!in_array($current_file, $js_files))
					{
						$js_files[] = $current_file;
					}
				}
			}
		}*/

		//var_export($js_files);
		//return;

		/* *** */

		header('Content-type: text/javascript');

		$files_count = count($js_files);

		//ob_start('compress');
		ob_start();

		for ($i=0; $i<$files_count; $i++)
		{
			include($js_dir.$js_files[$i]);
		}

		ob_end_flush();
	}

	/* *** */

	$JS_DIR = dirname(__FILE__).'/';
	
	// required
	$JS_FILES = array(
		'jQuery/jquery-1.4.2.min.js',
		'jQuery/jquery-ui-1.8.2.custom.min.js',
		'jQuery/jquery.easing.1.3.js',		
		'utils.js',
		'md5.js',
		'ajax-request.js',
		'form-manager.js',
		'inputs-validator.js',
		'quicksearcher.js',
		'data-checker.js',
		'dialog-notification.js',
		'dialog-modal.js',	
		'jquery.utils.js',	
		'jquery.ajaxfileupload.js',
		'jquery.jscrolltouch.js',
		'jquery.autoresize.js',
		'jquery.detection.utils.js',		
		'jquery.panel.js',
		'jquery.panelhistory.js',
		'jquery.panelslider.js',
		'jquery.shell.js',
		'jquery.advancedsearcher.js',	
		//'tiny_mce/tiny_mce.js',
		'si.files.js',
		'swfobject-2.2.js'
	);
	
	loadJS($JS_DIR, $JS_FILES);
?>
