<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/packages/application/HomePanel.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="app.include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="app" select="/RESPONSE/RESULTS[@name='app']/APP"/>
	<xsl:param name="appModules" select="/RESPONSE/RESULTS[@name='appModules']/MODULE"/>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation">
    	</xsl:call-template>
    </xsl:template>
	
	<!-- navigation body -->
	<xsl:template name="panel-body-navigation">
        <xsl:apply-templates select="$app" mode="element-home-panel-header" />
        
        <xsl:apply-templates select="$appModules" mode="module-tools" />

		<xsl:call-template name="staticitemheader">
			<xsl:with-param name="title">
				<xsl:text>Developer resources</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/tools-32.png</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:text>(...)</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">See all panel types in action</xsl:with-param>
            <xsl:with-param name="panelURI">panels/Index</xsl:with-param>
            <xsl:with-param name="params"></xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/panels/panels-16.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">A first application tutorial</xsl:with-param>
            <xsl:with-param name="panelURI">tutorial/HomePanel</xsl:with-param>
            <xsl:with-param name="params"></xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/applications/application.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>

        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">XSL panels guide</xsl:with-param>
            <xsl:with-param name="editor">jonathan</xsl:with-param>
            <xsl:with-param name="app">xsldoc</xsl:with-param>
            <xsl:with-param name="panelURI">HomePanel</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/xsl.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>

        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">PHP objects guide</xsl:with-param>
            <xsl:with-param name="editor">jonathan</xsl:with-param>
            <xsl:with-param name="app">phpdoc</xsl:with-param>
            <xsl:with-param name="panelURI">HomePanel</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/php.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>
                
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Officity Documentation</xsl:with-param>
            <xsl:with-param name="editor">officity</xsl:with-param>
            <xsl:with-param name="app">lib</xsl:with-param>
            <xsl:with-param name="panelURI">documents/FolderContent</xsl:with-param>
            <xsl:with-param name="params">ID:2142</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/libitems/book-16.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>