<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/packages/application/panels/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
   	<xsl:template name="panel-body-navigation">
         <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">
            	<xsl:text>Basic and navigation panels</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="icon">
   	        	<xsl:text>../system/images/icons/help/32.png</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="info">
            	<strong>Basic panel</strong> : the simpliest panel, just a header and a body.<br />
            	<strong>Navigation panel</strong> : a body holding a few navigation items that lead to other panels.<br />
            	<strong>Results list</strong> : displays the navigation items of the elements return by an xSushee query. The navigation items lead to their details panel.<br />
            	<strong>Quick search</strong> : allow to search and display elements that match some keywords or an ID. You can also delete them one by one.<br />
            	<strong>Link</strong> : to search and link/unlink one element to others via a given dependency.<br />
            </xsl:with-param>
        </xsl:call-template>
        
	    <xsl:call-template name="navigationitem">
	        <xsl:with-param name="title">Basic panel</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/BasicPanel</xsl:with-param>
	        <xsl:with-param name="params">parm:'value'</xsl:with-param>
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/documents/document.png</xsl:text>
	        </xsl:with-param>
	    </xsl:call-template>
	
	    <xsl:call-template name="navigationitem">
	        <xsl:with-param name="title">Navigation panel</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/NavigationPanel</xsl:with-param>
	        <xsl:with-param name="params">parm:'value'</xsl:with-param>
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/navigation/arrow-black.png</xsl:text>
	        </xsl:with-param>
	    </xsl:call-template>
	
	    <xsl:call-template name="nav-resultslist">
	        <xsl:with-param name="title">Results list</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/ResultsListPanel</xsl:with-param>
	        <xsl:with-param name="module" select="'contact'" />
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/record.png</xsl:text>
	        </xsl:with-param>
	        <xsl:with-param name="info">module: contact</xsl:with-param>
	    </xsl:call-template>
	
	    <xsl:call-template name="nav-quicksearch">
	        <xsl:with-param name="title">Quick search</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/QuickSearchPanel</xsl:with-param>
	        <xsl:with-param name="module" select="'contact'" />
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/contacts/contacts-18.png</xsl:text>
	        </xsl:with-param>
	        <xsl:with-param name="info">module: contact</xsl:with-param>
	    </xsl:call-template>
	    
	    <xsl:call-template name="nav-links">
	    	<xsl:with-param name="title">Link ("contactWork" dependency)</xsl:with-param>
	    	<xsl:with-param name="panelURI">panels/LinkPanel</xsl:with-param>
	    	<xsl:with-param name="module" select="'contact'" />
	    	<xsl:with-param name="originID" select="$userID" />
	    	<xsl:with-param name="targetModule" select="'contact'" />
	    	<xsl:with-param name="dependency" select="'contactWork'" />
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/dependencies/link-16.png</xsl:text>
	        </xsl:with-param>
	        <xsl:with-param name="info">myself to other contacts</xsl:with-param>
	    </xsl:call-template>
	
         <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">
            	<xsl:text>Element panels</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="icon">
   	        	<xsl:text>../system/images/icons/help/32.png</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="info">
            	<strong>New element</strong> : a panel holding a form to create new elements.<br />
            	<strong>Element details</strong> : multiple tabs, multiple forms. Use it to display/update/delete an element and navigate to the elements in dependency.<br />
            </xsl:with-param>
        </xsl:call-template>
	
	    <xsl:call-template name="nav-new">
	        <xsl:with-param name="title">New element</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/NewElementPanel</xsl:with-param>
	        <xsl:with-param name="module" select="'contact'" />
	        <xsl:with-param name="info">module: contact</xsl:with-param>
	    </xsl:call-template>
	
	    <xsl:call-template name="nav-details">
	        <xsl:with-param name="title">Element details</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/ElementDetailsPanel</xsl:with-param>
	        <xsl:with-param name="module" select="'contact'" />
	        <xsl:with-param name="id" select="$userID" />
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/documents/letter.png</xsl:text>
	        </xsl:with-param>
	        <xsl:with-param name="info">
	        	<xsl:text>myself (ID=</xsl:text>
	        	<xsl:value-of select="$userID" />
	        	<xsl:text>)</xsl:text>
	        </xsl:with-param>
	    </xsl:call-template>
	
         <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">
            	<xsl:text>Search panels</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="icon">
   	        	<xsl:text>../system/images/icons/help/32.png</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="info">
            	<strong>Advanced search</strong> : search elements based on user-defined criteria.<br />
            	<strong>Saved filters</strong> : load previously saved searches.<br />
            </xsl:with-param>
        </xsl:call-template>
	   	
	    <xsl:call-template name="nav-search">
	        <xsl:with-param name="title">Advanced search</xsl:with-param>
	        <xsl:with-param name="module" select="'contact'" />
	        <xsl:with-param name="info">module: contact</xsl:with-param>
	    </xsl:call-template>
	    
	    <xsl:call-template name="nav-savedfilters">
	        <xsl:with-param name="title">Saved filters</xsl:with-param>
	        <xsl:with-param name="module" select="'contact'" />
	        <xsl:with-param name="info">module: contact</xsl:with-param>
	    </xsl:call-template>
	
         <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">
            	<xsl:text>Miscellaneous panels</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="icon">
   	        	<xsl:text>../system/images/icons/help/32.png</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="info">
            	<strong>Draggable</strong> : these panels allow to sort the dependencies of a given element.<br />
            </xsl:with-param>
        </xsl:call-template>
	
	    <xsl:call-template name="navigationitem">
	        <xsl:with-param name="title">Draggable static items ("contactWork" dependency)</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/StaticDraggableItems</xsl:with-param>
	        <xsl:with-param name="params">contactID:1969</xsl:with-param>
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/draggable.png</xsl:text>
	        </xsl:with-param>
	        <xsl:with-param name="info">Nectil staff</xsl:with-param>
	    </xsl:call-template>
	    <xsl:call-template name="navigationitem">
	        <xsl:with-param name="title">Draggable navigation items ("contactWork" dependency)</xsl:with-param>
	        <xsl:with-param name="panelURI">panels/NavDraggableItems</xsl:with-param>
	        <xsl:with-param name="params">contactID:1969</xsl:with-param>
	        <xsl:with-param name="icon">
	            <xsl:text>../system/images/icons/drag-handle.png</xsl:text>
	        </xsl:with-param>
			<xsl:with-param name="info">Nectil staff</xsl:with-param>
	    </xsl:call-template>
	</xsl:template>
</xsl:stylesheet>