<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/system.auth.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	//error_reporting(E_ALL  & ~E_NOTICE  & ~E_WARNING);
	require_once(KERNEL_PATH.'common/officityuser.class.php');
	require_once(dirname(__FILE__).'/class/Param.class.php');
    
    /* *** */
	
	if ($_POST['logout'] == 'true')
	{
		// --- to not autologin after logout ---
	    setcookie('logout', 'true', time() + 60); // 60 minutes
	                
	    setcookie('ln', '', time() - 3600);                
	    setcookie('lp', '', time() - 3600);                
	    setcookie('lg', '', time() - 3600);
	
	    logout();

		include(dirname(__FILE__).'/../officity/springboard/Login.php');
	    die();
	}
	
	$visitor = new OfficityUser();
	
    if ((URLParam::exists('login') && URLParam::exists('password'))
		|| (isset($_COOKIE['ln']) && isset($_COOKIE['lp'])))
	{		
        $login = isset($_COOKIE['ln']) ? $_COOKIE['ln'] : URLParam::fetch('login');
        $password = isset($_COOKIE['lp']) ? $_COOKIE['lp'] : URLParam::fetch('password');
        $language = isset($_COOKIE['lg']) ? $_COOKIE['lg'] : URLParam::fetch('language','eng');
        
		$response_string = login($login, $password);
		
        if ($visitor->isAuthenticated())
        {	
            if (URLParam::exists('sc'))
            {
                $expire_time = time() + 60*60*24*30; // 30 days
                
                setcookie('ln', $login, $expire_time);
                setcookie('lp', $password, $expire_time);
                setcookie('lg', $language, $expire_time);
            }
            else
            {
                setcookie('ln', '', time() - 3600);
                setcookie('lp', '', time() - 3600);
                setcookie('lg', '', time() - 3600);
            }
            
            // for XSLT
            /*$_GET['ln'] = $login;
            $_GET['lp'] = $password;
            $_GET['lg'] = $language;*/
            
            setcookie('logout', '', time() - 3600); // see system_logout()
        }
        else
        {
        	$response_xml = new XML($response_string);
        	$_GET['loginErrMsg'] = $response_xml->valueOf('/RESPONSE/MESSAGE');
        }
	}
	
	if (!$visitor->isAuthenticated())
    {    
        include(dirname(__FILE__).'/../officity/springboard/Login.php');
        die();
    }
?>