<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/category/Details.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!-- parameters -->
	<xsl:param name="ID" select="/RESPONSE/URL/ID" />
	<xsl:param name="name" select="/RESPONSE/URL/name" />
	<xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/CATEGORY" />
	
    <xsl:param name="tabsID">
        <xsl:text>tabs-details-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>
    <xsl:param name="categInfoFormID">
        <xsl:text>form-categinfo-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel" />
    </xsl:template>
	
	<xsl:template name="panel-block-details">  
	    <xsl:apply-templates select="$item" mode="element-title" />        
	    
        <!-- TABS -->
        <div id="{$tabsID}" class="tab">
            <!-- TABS LIST -->
			<ul>
				<li>
					<a href="#{$categInfoFormID}">Infos</a>
				</li>
			</ul>
            <!-- LABEL/VALUE FORM -->
            <form id="{$categInfoFormID}" name="{$categInfoFormID}" enctype="multipart/form-data">
            	<input type="hidden" name="fatherID" id="fatherID" value="{$item/@fatherID}" />
            	<input type="hidden" name="ID" id="ID" value="{$item/@ID}" />            	
				<xsl:call-template name="category-content" />
            </form>
        </div>
	</xsl:template>

    <xsl:template name="category-content">
        <table class="fields">
            <tr>
                <td class="field-name">ID:</td>
                <td class="field-value">
                    <xsl:value-of select="$item/@ID" />
                </td>
            </tr>
            <tr>
                <td class="field-name">Path:</td>
                <td class="field-value">
                    <xsl:value-of select="$item/@path" />
                </td>
            </tr>
            <tr>
                <td class="field-name">Unique name:</td>
                <td class="field-value">
                    <xsl:value-of select="$item/UNIQUENAME" />
                </td>
            </tr>
            <tr>
                <td class="field-name">Module:</td>
                <td class="field-value">
                	<xsl:choose>
                		<xsl:when test="$item/@module!=''">
                    		<xsl:value-of select="$item/@module" />
                   		</xsl:when>
                   		<xsl:otherwise>
                   			<xsl:text>-</xsl:text>
                   		</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td class="field-name">Elements assigned:</td>
                <td class="field-value">
                    <xsl:value-of select="$item/@totalElements" />
                </td>
            </tr>
            <tr>
                <td class="field-name">Assignable:</td>
                <td class="field-value">
                    <input type="checkbox" class="input-checkbox" value="1" id="isassignable" name="isassignable">
                    	<xsl:if test="$item/ISASSIGNABLE=1">
                    		<xsl:attribute name="checked">checked</xsl:attribute>
                    	</xsl:if>
                    </input>
                </td>
            </tr>
            <xsl:for-each select="/RESPONSE/RESULTS[@name='published_languages']/LANGUAGE">
	            <tr>
	                <td class="field-name"><xsl:value-of select="LABEL" />:</td>
	                <td class="field-value">	                    
                        <input type="text" class="input-text" id="label-{@ID}" name="label-{@ID}" value="{$item/LABEL[@languageID=current()/@ID]}" />
	                </td>
	            </tr>
            </xsl:for-each>
            <tr>
                <td class="field-name">&#160;</td>
                <td class="field-value">
                    <input type="submit" id="submit-button" name="submit-button" class="input-submit-save" value="Update"/>
                    <input type="button" id="destroy-button" name="destroy-button" class="input-submit-remove" value="Delete" style="float:right;"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    
	<xsl:template name="panel-block-details-nav">
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title">Subcategories</xsl:with-param>
			<xsl:with-param name="panelURI">../../system/tools/category/List</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>ID:</xsl:text>
                <xsl:value-of select="$item/@ID"/>
            </xsl:with-param>
			<xsl:with-param name="cssclass">first last</xsl:with-param>
		</xsl:call-template> 
	</xsl:template>

    <xsl:template name="panel-js">
		<xsl:call-template name="js-init-tabs" />
	
          <!-- PROCESS -->
		$('#<xsl:value-of select="$categInfoFormID" />').submit(function() {
            fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
			fm.onSuccess(function(response){
               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
                   <xsl:value-of select="$panelID"/>
                   <xsl:text>,'../../system/tools/category/Details','Category (updated)',</xsl:text>
                   <xsl:text>{fatherID:response.fatherID,ID:response.ID,name:response.name}</xsl:text>
               <xsl:text>, 1);</xsl:text>
			});
	
            fm.displayProcess('Updating category...');
            fm.setScript('../../system/tools/category/ops.php?action=update');
			fm.parseAndSend(this);
	
			return false;
		});
	
		$('#<xsl:value-of select="$categInfoFormID" /> #destroy-button').click(function() {
            fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
			fm.onSuccess(function(response){
	            $(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>, 1);
			});
	
            fm.displayProcess('Deleting category...');
            fm.setScript('../../system/tools/category/ops.php?action=delete');
			fm.parseAndSend('#<xsl:value-of select="$categInfoFormID" />');
	
			return false;
		});
    </xsl:template>
</xsl:stylesheet>