<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/category/category.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- LABEL(s) -->
	<xsl:template match="CATEGORY" mode="element-label">
		<xsl:value-of select="LABEL"/>
	</xsl:template>
	
	<!-- ICON(s) -->
    <xsl:template match="CATEGORY[CATEGORY]" mode="element-icon">
        <xsl:text>../system/images/icons/categories/h-tree.png</xsl:text> 
    </xsl:template>
    
    <xsl:template match="CATEGORY[not(CATEGORY)]" mode="element-icon">
        <xsl:text>../system/images/icons/categories/category.png</xsl:text> 
    </xsl:template>
    
	<xsl:template match="CATEGORY" mode="element-iconinfo">
        <xsl:text>../system/images/icons/info.png</xsl:text> 
	</xsl:template>
    
    <!-- INFO LABEL(s) -->
    <xsl:template match="CATEGORY" mode="element-info">
        <xsl:value-of select="UNIQUENAME" />
        <xsl:text> (</xsl:text>
        <xsl:value-of select="@ID" />
        <xsl:text>)</xsl:text>
    </xsl:template>
	
	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="CATEGORY[CATEGORY]" mode="element-navitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">category-<xsl:value-of select="UNIQUENAME"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
				<xsl:text> (</xsl:text>
				<xsl:value-of select="count(CATEGORY)" />
				<xsl:text>)</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-content"/>
			</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>ID:</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="CATEGORY[not(CATEGORY)]" mode="element-navitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">category-<xsl:value-of select="UNIQUENAME"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>ID:</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template match="CATEGORY" mode="element-naviteminfo">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">category-<xsl:value-of select="UNIQUENAME"/></xsl:with-param>
			<xsl:with-param name="title">				
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>				
			</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>fatherID:</xsl:text>
                <xsl:value-of select="@ID"/>
                <xsl:text>,ID:</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-iconinfo"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:value-of select="@path" />
			</xsl:with-param>
			<xsl:with-param name="cssclass" select="'grey-bkgnd'" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="nav-newcategitem">
		<xsl:param name="fatherID" />
		<xsl:param name="title">
			<xsl:choose>
				<xsl:when test="$fatherID">
					<xsl:text>Add subcategory...</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>Add category...</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>    	
    	<xsl:param name="info" />
	    
	    <xsl:call-template name="navigationitem">
		    <xsl:with-param name="title" select="$title" />
		    <xsl:with-param name="panelURI">../../system/tools/category/New</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>fatherID:'</xsl:text>
                <xsl:value-of select="$fatherID"/>
                <xsl:text>'</xsl:text>
            </xsl:with-param>
		    <xsl:with-param name="icon">../system/images/icons/add/add-new.png</xsl:with-param>
		    <xsl:with-param name="info" select="$info" />
		    <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
	    </xsl:call-template>
	</xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="CATEGORY" mode="element-script-content">
		<xsl:text>../../system/tools/category/List</xsl:text>
	</xsl:template>
	
	<xsl:template match="CATEGORY" mode="element-script-detail">
		<xsl:text>../../system/tools/category/Details</xsl:text>
	</xsl:template>
	
	<!-- TITLE -->
	<xsl:template match="CATEGORY" mode="element-title">        
		<h2 class="category">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
</xsl:stylesheet>
