<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/NewSearch-light.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:import href="../../../system/tools/search/functions.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!--IDs -->
    <xsl:param name="searchFormID">
        <xsl:text>search-form-</xsl:text>
        <xsl:value-of select="$panelID" />
    </xsl:param>
    <xsl:param name="saveQueryDialogID">
        <xsl:text>filter-save-dialog-</xsl:text>
        <xsl:value-of select="$panelID"/>
    </xsl:param>
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel">
    		<xsl:with-param name="optimalWidth" select="600" />
    	</xsl:call-template>
    </xsl:template>
    
    <!--custom : body -->
	<xsl:template name="panel-body">
		<div class="block block-list">
			<xsl:call-template name="panel-block-list"/>
		</div>
	</xsl:template>
	
   	<xsl:template name="panel-header">
         <form id="{$searchFormID}" name="{$searchFormID}" class="search-form">
            <input type="hidden" id="app" name="app" value="{/RESPONSE/URL/app}" />
            <input type="hidden" id="editor" name="editor" value="{/RESPONSE/URL/editor}" />
            <input type="hidden" id="module" name="module" value="{/RESPONSE/URL/module}"/>
            
            <xsl:for-each select="$filter-display/RETURN//*[not(*)]">
                <xsl:sort select="@order" order="ascending" data-type="number"/>
                <xsl:choose>
                    <xsl:when test="ancestor::DEPENDENCY">
                        <!-- dependency modules fields -->
                        <input type="hidden" name="columns[]" value='DEPENDENCY[@type="{current()/../../@type}"]/{name()}'/>
                    </xsl:when>
                    <xsl:when test="name()='CATEGORIES'">
                        <input type="hidden" name="columns[]" value='CATEGORIES'/>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- main module fields -->
                        <input type="hidden" name="columns[]" value="INFO/{name()}"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>

            <input type="hidden" id="sort" name="sort" value="{$filter-display/SORT/@select}"/>
            <input type="hidden" id="order" name="order" value="{$filter-display/SORT/@order}"/>
            <input type="hidden" id="display" name="display" value="{$filter-display/PAGINATE/@display}"/>
            <input type="hidden" id="page" name="page" value="1"/>
            <input type="hidden" id="displaySelection" name="displaySelection" value="no"/>
            <input type="hidden" id="lastHits" name="lastHits" value="0"/>

            <div class="form-fields">
                <!-- DEFAULT SEARCHTEXT INPUT BOX (ALWAYS PRESENT) -->
                <xsl:call-template name="default-search-crit">
                    <xsl:with-param name="value" select="''" />
                </xsl:call-template>
			</div>

              <div id="message">
                Caution : some added fields are empty.<br/>The search may not give the expected results.
            </div>

            <div class="form-submit form-item">
                <input id="reset-button" type="button" value="reset" />
                <input id="search-button" type="submit" value="search" />
                <input id="edit-button" type="submit" value="edit" />
                <input id="save-button" type="button" value="save" />
            </div>
        </form>

	    <!-- SAVE FILTER : MODAL DIALOG -->
        <xsl:call-template name="filter-save-dialog"/>
	</xsl:template>
	
	<xsl:template name="panel-js">
		$('#<xsl:value-of select="$panelID" />.panel').advancedsearcher({
			formID : '<xsl:value-of select="$searchFormID" />',	
			script : '<xsl:value-of select="/RESPONSE/URL/callbackPanel"/>', 
			controller : AppController
		});
		
        var saveFilterDialog<xsl:value-of select="$panelID" /> = new ModalDialog(
            <xsl:value-of select="$panelID"/>,
            AppController,
            "#<xsl:value-of select="$saveQueryDialogID"/>",
            {
                bgiframe: true,
                autoOpen: false,
                width       : 480,
                minHeight   : 170,
            }
        );

        saveFilterDialog<xsl:value-of select="$panelID" />.setOkCallback("#ok-button", delegate(this, function(){
            var dialogContainer = $("#<xsl:value-of select="$saveQueryDialogID"/>");

			var filterConfig = { };
            filterConfig['filter-name'] = dialogContainer.find("#filter-name").val();
            filterConfig['filter-shared'] = dialogContainer.find("#filter-shared").val();
            filterConfig['filter-count'] = dialogContainer.find("#filter-withCount").attr("checked");
            filterConfig['filter-query'] = true;
            filterConfig['filter-display'] = dialogContainer.find("#filter-withDisplay").attr("checked");
            filterConfig['filter-search'] = dialogContainer.find("#filter-withSearch").attr("checked");
            filterConfig['module'] = '<xsl:value-of select="$search-config/MODULE"/>';

            <!-- loaded filter? -->
            <xsl:if test="$filterID">
                filterConfig['filter-overwrite'] = dialogContainer.find("#filter-overwrite").attr("checked");
            </xsl:if>
            
            saveFilterDialog<xsl:value-of select="$panelID" />.hide();
            
            $('#<xsl:value-of select="$panelID"/>.panel').trigger('search-savequery', [filterConfig]);
            return false;
        }));

        saveFilterDialog<xsl:value-of select="$panelID" />.setCancelCallback("#cancel-button", null);

        $("#<xsl:value-of select="$searchFormID"/> #save-button").click(delegate(this, function(){
            saveFilterDialog<xsl:value-of select="$panelID" />.show();
            return false;
        }));
        
        <!-- refresh callback -->
        $('#<xsl:value-of select="$panelID" />.panel').panel({ 
	     	onRefresh: function(panelElem){
	     		panelElem.advancedsearcher('submit');
	     	}
	     });
	</xsl:template>

    <!-- SAVE DIALOG -->
    <xsl:template name="filter-save-dialog">
        <div id="{$saveQueryDialogID}" title="Save search filter" class="modal-dialog">
            <div class="info">
                <label>Save as : </label>
                <input id="filter-name" name="filter-name" type="text" value="Search filter name" class="input-text"/>
                <br/>
            </div>
            <div class="info">
                <label>Sharing : </label>
                <select id="filter-shared" name="filter-shared">
                    <option value="private">Personal use</option>
                    <option value="shared">Collective use</option>
                </select><br /><br />
                <div class="check-container">
                    <input id="filter-withCount" name="filter-withCount" type="checkbox" class="check-input"/>
                    <xsl:text> Display an automatic count</xsl:text><br />
                </div>
                <div class="check-container">
                    <input id="filter-withDisplay" name="filter-withDisplay" type="checkbox" class="check-input"/>
                    <xsl:text> Include the display configuration</xsl:text>
                </div>
                <div class="check-container">
                    <input id="filter-withSearch" name="filter-withSearch" type="checkbox" class="check-input"/>
                    <xsl:text> Execute the search after loading</xsl:text>
                </div>

            </div>
            <div class="controls">
                <a id="cancel-button" href="#">Cancel</a>&#160;&#160;or&#160;&#160;
                <input type="button" id="ok-button" name="ok-button" class="modal-button" value="Save"/>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
