<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/RawDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.no-editors.xsl"/>  
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	<xsl:param name="categories" select="/RESPONSE/RESULTS/CATEGORY"/>
  	
  	<xsl:param name="module" select="translate(/RESPONSE/URL/module, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/> 
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
        
    <!-- optional parameters -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
    <!-- IDs -->
    <xsl:param name="tinyClass">
		<xsl:text>mceEditor-</xsl:text>
		<xsl:value-of select="$panelID" />
    </xsl:param>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="displaySusheeTab" select="true()"/>
    	</xsl:call-template>    	
    </xsl:template>
    
  	<!-- element details : overview content  -->
    <xsl:template name="element-tab-overview">
    	<xsl:param name="element" />  
    	<xsl:param name="legend" select="'Overview'" />      	
        
	    <xsl:variable name="susheeFields" select="$fields[INFO/DENOMINATION='ID' or
					INFO/DENOMINATION='ACTIVITY' or
					INFO/DENOMINATION='ISLOCKED' or
					INFO/DENOMINATION='CREATORID' or
					INFO/DENOMINATION='OWNERID' or
					INFO/DENOMINATION='GROUPID' or
					INFO/DENOMINATION='MODIFIERID' or
					INFO/DENOMINATION='CREATIONDATE' or
					INFO/DENOMINATION='MODIFICATIONDATE' or
					INFO/DENOMINATION='SEARCHTEXT' or
					INFO/DENOMINATION='OWNERS' or
					INFO/DENOMINATION='GROUPS']" />
 		
 		<xsl:call-template name="form-fieldset">
 			<xsl:with-param name="legend">
 				<xsl:value-of select="$legend" />
 				<xsl:text> - Editor fields</xsl:text>
 			</xsl:with-param>
 			<xsl:with-param name="content">
		        <xsl:for-each select="$element/INFO/*[not($susheeFields/INFO/DENOMINATION=name()) and
			        	name()!='CREATOR' and name()!='MODIFIER' and name()!='OWNER']">
		            <xsl:sort select="name()" />
		       		<xsl:apply-templates select="." mode="overview-line">
		       			<xsl:with-param name="topLabel" select="true()" />
		       		</xsl:apply-templates>
		        </xsl:for-each>
	        </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <!-- element details : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
            <xsl:with-param name="cssclass">first</xsl:with-param>
        </xsl:call-template>
        <xsl:for-each select="$depentities/DEPENDENCYTYPE[@from=$module and not(TYPE=preceding-sibling::DEPENDENCYTYPE/TYPE)]">
            <xsl:sort select="TYPE" />
			<xsl:call-template name="nav-links">
                <xsl:with-param name="title">
                    <xsl:value-of select="TYPE" />
                    <xsl:text>(</xsl:text>
					<xsl:value-of select="count($itemDeps/DEPENDENCY[@type=current()/TYPE]/*)" />
					<xsl:text>)</xsl:text>
                </xsl:with-param>
				<xsl:with-param name="module" select="@from" />
				<xsl:with-param name="originID" select="$element/@ID" />
				<xsl:with-param name="targetModule" select="@to" />
				<xsl:with-param name="dependency" select="TYPE"/>
				<xsl:with-param name="panelURI" select="'../../system/tools/element/RawLink'"/>
			</xsl:call-template>
        </xsl:for-each>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
    
   <!-- custom: default description content -->
   <xsl:template name="element-tab-desc">
   		<xsl:param name="element" /> 
		<xsl:param name="languageID" />		   			
		<xsl:variable name="currentDesc" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID=$languageID]"/> 
		
		<xsl:choose>
			<xsl:when test="$currentDesc">
				<xsl:apply-templates select="$currentDesc/TITLE" mode="form-desc-line">			
					<xsl:with-param name="type" select="'text'" />
				</xsl:apply-templates>	
					
				<xsl:apply-templates select="$currentDesc/HEADER" mode="form-desc-line" />
				
				<xsl:apply-templates select="$currentDesc/BODY" mode="form-desc-line">
					<xsl:with-param name="label" select="'Body (styled):'"/>
					<xsl:with-param name="type" select="'styled'" />
					<xsl:with-param name="cssclass" select="$tinyClass" />
				</xsl:apply-templates>
				
				<xsl:apply-templates select="$currentDesc/SUMMARY" mode="form-desc-line">
					<xsl:with-param name="type" select="'textarea'" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'TITLE'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="type" select="'text'" />
				</xsl:call-template>	
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'SUMMARY'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="type" select="'textarea'" />
				</xsl:call-template>
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'HEADER'" />
					<xsl:with-param name="languageID" select="$languageID" />
				</xsl:call-template>	
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'BODY'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="label" select="'Body (styled):'" />
					<xsl:with-param name="type" select="'styled'" />
					<xsl:with-param name="cssclass" select="$tinyClass" />
				</xsl:call-template>		
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:apply-templates select="$element" mode="form-desc-line-submit" />
  	</xsl:template>
  	
    <!-- custom : element details js -->
	<xsl:template name="panel-js-element">
		<xsl:param name="element" />
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:apply-templates select="$element" mode="element-panel-details-class"/>');
		
		<xsl:call-template name="js-init-tinyMCE">	
			<xsl:with-param name="textareaClass" select="$tinyClass" />
		</xsl:call-template>
		
		<xsl:call-template name="js-init-autoresize">
			<xsl:with-param name="excludeClass" select="$tinyClass" />
		</xsl:call-template>
		
		<xsl:call-template name="js-init-tabs" />

		<xsl:call-template name="js-init-datepicker">
			<xsl:with-param name="selector" select="'.input-date'"/>
		</xsl:call-template>
		
		<xsl:call-template name="js-init-display-xml" />	
	</xsl:template>
    
    <xsl:template name="panel-add-js">

    </xsl:template>    
</xsl:stylesheet>