<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/WIP.element.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/*
	 * ElementNode Class
	 * 
	 * @since	...
	 * @author	Marc Mignonsin
	 *
	*/

	/* complete refactoring using compact, efficient objects */

	class ElementNode
	{
		protected $xml_node=null;
		
		public function __construct($xml_node)
		{
			$this->xml_node = $xml_node;
		}
		
		/* *** */

		public function addXML($xml_string='')
		{				
			$this->checkXMLNode();
			$this->xml_node->appendChild($xml_string);
			return $this;
		}
		
		public function add($arg1, $arg2='')
		{		
			if (is_array($arg1))
			{
				$nodes_data = $arg1; 
				foreach ($nodes_data as $node_name => $node_value)
				{
					$this->add($node_name, $node_value);
				}
			}
			else
			{
				$node_name = $arg1;
				$node_value = $arg2;
				
				if ($node_name[0] == '@')
				{
					$this->checkXMLNode();
					$attr_name = substr($node_name, -strlen($node_name)+1);
					$this->xml_node->setAttribute($attr_name, $node_value);
				}
				else
				{
					$xml_string = $this->tag($node_name, $node_value, true);		
					$this->addXML($xml_string);
				}
			}
			return $this;
		}
		
		public function set($node_name, $value='')
		{
			$this->checkXMLNode();
			$this->del($node_name)->add($node_name, $value);
			return $this;
		}
		
		public function ren($node_name, $new_name, $keep_attrs=true)
		{
			$this->checkXMLNode();
			$children = $this->xml_node->getElements("$node_name/*");
			
			$children_xml_string = "<$new_name";
			if ($keep_attrs == true)
			{
				$attrs = $this->xml_node->getElements("$node_name/@*");
				foreach ($attrs as $attr)
				{
					$children_xml_string .= ' '.$attr->nodeName().'="'.$attr->valueOf('.').'"';
				}
			}
			$children_xml_string .= ">";
			
			foreach ($children as $child)
			{
				$children_xml_string .= $child->toString('/', '');
			}
			$children_xml_string .= "</$new_name>";
			
			$this->del($node_name)->addXML($children_xml_string);
			return $this;
		}
		
		public function del($xpath)
		{
			$this->checkXMLNode();
			$this->xml_node->removeChild($xpath);
			return $this;
		}
		
        public function get($xpath)
		{
			$this->checkXMLNode();
			$nodes = $this->xml_node->getElements($xpath);

			if (count($nodes) <= 1)
			{
				return new ElementNode($nodes[0]);
			}
			else
			{
				$nodes_array = array();
				foreach ($nodes as $node)
				{					
					$nodes_array[] = new ElementNode($node);
				}
				return $nodes_array;
			}
		}

		public function val($xpath)
		{
			$this->checkXMLNode();
			$nodes = $this->xml_node->getElements($xpath);
			
			if (count($nodes) <= 1)
			{
				return $nodes[0]->valueOf('.');
			}
			else
			{
				$vals_array = array();
				foreach ($nodes as $node)
				{					
					$vals_array[] = $node->valueOf('.');
				}
				return $vals_array;
			}
		}
		
	    public function exists($xpath=null)
        {
			if (!is_object($this->xml_node))
			{
				return false;
			}
			
			if ($xpath != null)
			{
				return $this->xml_node->exists($xpath);
			}
			return true;
        }
        
		public function toString($xpath='/', $html_output=true)
		{
			$this->checkXMLNode();
			$xml_string = $this->xml_node->toString($xpath);
			if ($html_output == true)
			{
				$xml_string = htmlentities($xml_string);
			}
			return $xml_string;
		}
        
		/* *** */
		
        protected function createFromString($xml_string)
        {
			if ($this->xml_node != null)
			{
				unset($this->xml_node);
				$this->xml_node = null;
			}

			$x = new XML($xml_string);
			$this->xml_node = $x->getElement('/');
        }
        
        protected function checkXMLNode()
        {
        	if (!$this->exists())
        	{
        		throw new OfficityException('The current XML node is not an object!');
        	}
        }
		
        protected function tag($node_name, $node_value='', $encode_xml_value=true)
        {
        	if ($encode_xml_value == true) 
        	{
        		$node_value = encode_to_xml($node_value);
        	}
        	$xml_string = "<$node_name>$node_value</$node_name>";
        	return $xml_string;
        }
	} 
	
	class Element
	{
    	protected $xml_object;
    	protected $external_nql, $internal_nql;
    	
		public function __construct($denomination='', $ID=0)
		{
		
		}
		
        public function __destruct()
        {
        	
        }
        
        /* *** */
        
        
	}
	
    /*class Element
    {
    	protected $xml;
    	protected $external_nql, $internal_nql;
    	protected $denomination, $ID, $command;
    	    	
        public function __construct($denomination='', $ID=0)
        {   
            $d = $this->set_denomination($denomination);
            $this->xml_node = $this->create_xml($this->xml_node_tag($d));
            $this->set_ID($ID);
            $this->set_command('');
            $internal_nql = new Sushee_Shell(false);
        }
        
        public function __destruct()
        {
        	
        }
        
        protected function set_denomination($denomination)
        {
        	$this->denomination = strtoupper($denomination);
        	return $this->denomination;
        }
        
        public function get_denomination()
        {
        	return $this->denomination;
        }
        
        protected function set_ID($ID)
        {
        	$this->ID = $ID;
        	return $this->ID;
        }
        
        public function get_ID()
        {
        	return $this->ID;
        }
        
        protected function set_command($command)
        {
        	$this->command = $command;
        	return $this->command;
        }
        
        public function get_command()
        {
        	return $this->command;
        }
        
        public function get_NQL_query()
        {
        	return $this->xml_node->toString('/', '');
        }
        
        public function log_NQL($html=true, $die=true)
        {
        	$output = $this->get_NQL_query();
        	
			if ($html == true)
			{
				$output = htmlentities($output);	
			} 
			
			echo $output;
			
        	if ($die == true) die();
        }
        
        protected function xml_tag($node_name, $node_value='', $encode_xml_value=true)
        {
        	if ($encode_xml_value == true) 
        	{
        		$node_value = encode_to_xml();
        	}
        		
        	$xml_string = "<$node_name>$node_value</$node_name>";
       	
        	return $xml_string;
        }
        
        public function xpath($xpath)
		{
			$node = $this->xml_node->getElement($xpath);
			return $node;
		}
		
        protected function node_exists($xpath)
		{
			return $this->xml_node->getElement($xpath);
		}
		
        protected function create_xml($xml_string)
        {
			if (!empty($this->xml_node))
			{
				unset($this->xml_node);
				$this->xml_node = null;
			}
			
			$this->xml_node = new XML($xml_string);
        }
		
        protected function build_element_xpath()
        {
        	$xpath = '';
			
			if (empty($this->command))
			{
				$xpath = '/'.$this->denomination;
			}
			else
			{
				$xpath = '/'.$this->command.'/'.$this->denomination;
			}
			
			return $xpath;
        }	
        
        protected function select_element_node()
		{
			$xpath = $this->build_element_xpath();			
			return $this->xpath($xpath);
		}
        
        protected function select_service_node($service_name)
		{
			$service_name = strtoupper($service_name);		
			$xpath = $this->build_element_xpath().'/'.$service_name;
			return $this->xpath($xpath);
		}
		
        protected function create_service_node($service_name)
        {
        	// create only of it doesn't exist yet
			$service_node = $this->select_service_node($service_name);
			if ($service_node === false)
			{
        		$this->select_element_node()->appendChild($this->xml_node_tag($service_name));
        		$service_node = $this->select_service_node($service_name);
			}
			
			return $service_node;
        }

        protected function select_info_node($node_name)
		{
			$service_name = strtoupper($service_name);			
			return $this->select_element_node()->getElement($service_name);
		}
		
    	public function info_add()
    	{
    		$num_args = func_num_args();
    		
    		$service_node = $this->create_service_node('INFO');
    		
    		if ($num_args == 2)
    		{
    			$node_name = func_get_arg(0);
    			$node_value = func_get_arg(1);
    			$this->create_service_node('INFO')->appendChild($this->xml_node_tag($node_name, $node_value));
    		}	
    		else if ($num_args == 1)
    		{
    			$nodes_array = func_get_arg(0);
        		foreach ($nodes_array as $node_name => $node_value)
    			{
    				$service_node->appendChild($this->xml_node_tag($node_name, $node_value));		
    			}
    		}	
    		
    		return $this->select_info_node($node_name);
    	}
    }*/
?>