<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/element-factory.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/*
	 * ElemenFactory Class
	 * 
	 * @since	2010-08-11
	 *
	*/
    
	class ElementFactory
	{
		function __construct()
		{
					
		}

		function __destruct()
		{
			
		}
		
		/* *** */
		
		public static function build($module_denomination)
		{
			// check if there's a namespace
			$module_parts = explode(':', $module_denomination, 2);
			if (isset($module_parts[1])) 
			{
				$element_class = ucfirst($module_parts[0]).'_'.ucfirst($module_parts[1]).'Element'; // namespace in denomination
			}
			else // no namespace in denomination => Sushee
			{
				$element_class = 'Sushee_'.ucfirst($module_denomination).'Element'; 
			}	
			
			//var_dump($element_class);
			
			// TODO : use objects factory, if it exists
			// e.g.: the classes MediaElement, PageElement (mediatype=page), SubMenuElement (mediatype=submenu) exist
			// => developper creates MediaElementFactory
			// $factory_class = $elementClass.'Factory';
			// if (class_exists($factory_class)) $class_instance = $factory_class::build($parms); 
			// else $class_instance = new $element_class();
			if (class_exists($element_class, false))
			{
				//echo 'class exists';
				$class_instance = new $element_class();
				
				// this is the DNA test... (avoid clash with Sushee objects, e.g. ModuleElement)
				if ((!$class_instance instanceOf Element)  || !method_exists($class_instance, 'parse'))
				{
					unset($class_instance);
					
					//throw new OfficityAppException("'{$element_class}' is not a valid element class");
					$class_instance = new Element($module_denomination); // default	
				}
			}
			else
			{
				//echo 'class does not exist';
				//throw new OfficityAppException("Unknow element class '{$element_class}'");
				$class_instance = new Element($module_denomination); // default	
			}
			
			return $class_instance;
		}
	}
?>