<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/element.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="*" mode="element-editor">
		<xsl:value-of select="''" />
	</xsl:template>
	<xsl:template match="*" mode="element-application">
		<xsl:value-of select="/RESPONSE/URL/app" />
	</xsl:template>
	<xsl:template match="*" mode="element-application-editor">
		<xsl:value-of select="/RESPONSE/URL/editor" />
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="*" mode="element-label">
        <xsl:choose>
            <xsl:when test="INFO/LASTNAME/text()">
				<xsl:apply-templates select="INFO/LASTNAME" mode="display-value" />
				<xsl:text> </xsl:text>
				<xsl:apply-templates select="INFO/FIRSTNAME" mode="display-value" />
            </xsl:when>
            <xsl:when test="INFO/NAME/text()">
                <xsl:apply-templates select="INFO/NAME" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/DENOMINATION/text()">
                <xsl:apply-templates select="INFO/DENOMINATION" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/TITLE/text()">
                <xsl:apply-templates select="INFO/TITLE" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/SUBJECT/text()">
                <xsl:apply-templates select="INFO/SUBJECT" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/BODY/text()">
                <xsl:apply-templates select="INFO/BODY" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/LABEL/text()">
                <xsl:apply-templates select="INFO/LABEL" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/CLASSNAME/text()">
                <xsl:apply-templates select="INFO/CLASSNAME" mode="display-value"/>
            </xsl:when>
            <xsl:when test="INFO/EDITOR/text()">
                <xsl:apply-templates select="INFO/EDITOR" mode="display-value"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>? </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template match="*[parent::CREATOR or parent::MODIFIER or parent::OWNER or parent::OWNERS or parent::GROUPS]" mode="element-label">
        <xsl:choose>
            <xsl:when test="@lastname!=''">
				<xsl:apply-templates select="@lastname" mode="display-value" />
				<xsl:text> </xsl:text>
				<xsl:apply-templates select="@firstname" mode="display-value" />
            </xsl:when>
            <xsl:when test="@denomination!=''">
                <xsl:apply-templates select="@denomination" mode="display-value"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>? </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="*" mode="element-info">
        <xsl:value-of select="@ID"/>
	</xsl:template>
	
	<!-- ICON(s) -->
	<xsl:template match="*" mode="element-icon">
        <xsl:text>../system/images/icons/modules/generic.png</xsl:text>
	</xsl:template>
	
	<!-- TITLE(s) -->
	<xsl:template match="*" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
	<!-- PANELS -->
	<xsl:template match="*" mode="element-panel-details-class">
		<xsl:text>panel-details panel-details-</xsl:text>
   		<xsl:call-template name="translate-namespace-name">
       		<xsl:with-param name="name" select="name(.)"/>
       	</xsl:call-template>
	    <xsl:text>-</xsl:text>
	    <xsl:value-of select="@ID"/>
    </xsl:template>
	<xsl:template match="*" mode="element-panel-details-selector">
		<xsl:text>.panel-details.panel-details-</xsl:text>
   		<xsl:call-template name="translate-namespace-name">
       		<xsl:with-param name="name" select="name(.)"/>
       	</xsl:call-template>
	    <xsl:text>-</xsl:text>
	    <xsl:value-of select="@ID"/>
    </xsl:template>
    
	<xsl:template match="*" mode="element-panel-new-class">
		<xsl:text>panel-new panel-new-</xsl:text>
   		<xsl:call-template name="translate-namespace-name">
       		<xsl:with-param name="name" select="name(.)"/>
       	</xsl:call-template>
	    <xsl:text>-</xsl:text>
	    <xsl:value-of select="@ID"/>
    </xsl:template>
	<xsl:template match="*" mode="element-panel-new-selector">
		<xsl:text>.panel-new.panel-new-</xsl:text>
   		<xsl:call-template name="translate-namespace-name">
       		<xsl:with-param name="name" select="name(.)"/>
       	</xsl:call-template>
	    <xsl:text>-</xsl:text>
	    <xsl:value-of select="@ID"/>
    </xsl:template>
	
	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="*" mode="element-navitem-id">
   		<xsl:call-template name="translate-namespace-name">
       		<xsl:with-param name="name" select="name(.)"/>
       	</xsl:call-template>
	    <xsl:text>-</xsl:text>
	    <xsl:value-of select="@ID"/>
    </xsl:template>
    
	<xsl:template match="*" mode="element-navitem-parms">
        <xsl:text>ID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>,module:'</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>'</xsl:text>
    </xsl:template>
    
	<xsl:template match="*" mode="element-navitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="*" mode="element-navitem-new">
		<xsl:param name="title" select="'Create new...'" />
		<xsl:param name="params" />
		
		<xsl:call-template name="nav-new">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="module">
                <xsl:value-of select="name(.)" />
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:value-of select="$title" />
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-new"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:value-of select="$params" />
            </xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- with checkbox -->
	<xsl:template match="*" mode="element-navitem-check">
		<xsl:param name="tab" select="false()"/>
		<xsl:param name="checked" select="false()"/>
		<xsl:param name="disabled" select="false()"/>
		<xsl:param name="cssclass" />
		
		<xsl:call-template name="navigationitem-check">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
			<xsl:with-param name="tab" select="$tab"/>
			<xsl:with-param name="checked" select="$checked"/>
			<xsl:with-param name="disabled" select="$disabled"/>
			<xsl:with-param name="cssclass" select="$cssclass"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- with delete action -->
	<xsl:template match="*" mode="element-navitem-delete">
        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">
                <xsl:apply-templates select="." mode="element-script-detail"/>
            </xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="." mode="element-info"/>
            </xsl:with-param>
            <xsl:with-param name="cssclass"/>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="delete-action" hover-title="Delete">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'deleteitem'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-delete" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
	</xsl:template>
	
	<!-- with "add to dependency" action -->
	<xsl:template match="*" mode="element-navitem-depadd">
        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="icon">
            	<xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">
                <xsl:apply-templates select="." mode="element-script-detail"/>
            </xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="." mode="element-info"/>
            </xsl:with-param>
            <xsl:with-param name="cssclass"/>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="link-action" hover-title="Link">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'updatedependency'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-link" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
	</xsl:template>
	
	<!-- with "remove from dependency" action -->
	<xsl:template match="*" mode="element-navitem-depremove">
        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">
                <xsl:apply-templates select="." mode="element-script-detail"/>
            </xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="." mode="element-info"/>
            </xsl:with-param>
            <xsl:with-param name="cssclass"/>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="unlink-action" hover-title="Unlink">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'updatedependency'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-unlink" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
	</xsl:template>
	
	<!-- draggable -->
	<xsl:template match="*" mode="element-navitem-draggable">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<xsl:call-template name="navigationitem-draggable">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID" />
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="*" mode="element-navitem-check-action">
		<xsl:param name="actions-block" />
		
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<xsl:call-template name="navigationitem-check">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>            
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="@ID"/>
				<xsl:text>,module:'</xsl:text>
				<xsl:value-of select="name(.)" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="checkValue" select="@ID" />
			<xsl:with-param name="rightactions-elems">				
				<xsl:copy-of select="$actions-block" />
			</xsl:with-param>
		</xsl:call-template>
    </xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="*" mode="element-script-detail">
		<xsl:text>../../system/tools/element/Details</xsl:text>
	</xsl:template>

	<xsl:template match="*" mode="element-script-new">
		<xsl:text>../../system/tools/element/New</xsl:text>
	</xsl:template>
		
	<xsl:template match="*" mode="element-script-ops">
		<xsl:text>../../system/tools/element/call-element-operation.php</xsl:text>
		<xsl:text>?module=</xsl:text>
		<xsl:value-of select="name(.)"/>
	</xsl:template>

    <xsl:template match="*" mode="element-script-create">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=create</xsl:text>
	</xsl:template>

    <xsl:template match="*" mode="element-script-update">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=update</xsl:text>
	</xsl:template>

    <xsl:template match="*" mode="element-script-link">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=link</xsl:text>
	</xsl:template>

    <xsl:template match="*" mode="element-script-unlink">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=unlink</xsl:text>
	</xsl:template>

    <xsl:template match="*" mode="element-script-delete">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=delete</xsl:text>
	</xsl:template>
	
    <xsl:template match="*" mode="element-script-duplicate">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=duplicate</xsl:text>
	</xsl:template>

    <xsl:template match="*" mode="element-script-count">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=count</xsl:text>
	</xsl:template>
	
    <xsl:template match="*" mode="element-script-assign-security">
		<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=assignSecurity</xsl:text>
	</xsl:template>
</xsl:stylesheet>