<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/file/file.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:LIG="http://www.citoyenparent.be" version="1.0">
    <xsl:template match="DIRECTORY" mode="element-navitem">
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">
                <xsl:value-of select="INFO/NAME"/>
                <xsl:text> (</xsl:text>
                <xsl:value-of select="@items"/>
                <xsl:text>)</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="hovertitle">
                <xsl:text>Browse...</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="@modificationDate" mode="datetime"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">../../system/tools/file/Folder</xsl:with-param>
            <xsl:with-param name="params">path:'<xsl:value-of select="INFO/PATH"/>',sort:'<xsl:value-of select="/RESPONSE/URL/sort"/>'</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/libitems/folder.png</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="FILE" mode="element-navitem">
        <xsl:call-template name="staticitem-download">
            <xsl:with-param name="title">
                <xsl:value-of select="INFO/NAME"/>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:value-of select="@size"/>
                <xsl:text> - </xsl:text>
                <xsl:apply-templates select="@modificationDate" mode="datetime"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">../../system/tools/file/Folder</xsl:with-param>
            <xsl:with-param name="path"><xsl:value-of select="INFO/PATH"/></xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/libitems/file.png</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>




