<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/filter/filter.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');

    /* *** */

	class FilterElement extends Element
	{
		function __construct($ID=0)
		{
			parent::__construct('OFFICITY:FILTER', $ID);

			// default structure - see Element::buildSearchFilter()
			$this->getElementNode()->appendChild('<INFO/>');
			$this->createInfoNode('QUERYXML');
			$this->createInfoNode('DISPLAYXML');
			$this->setInfo('ISQUERY', '0');
			$this->setInfo('ISDISPLAY', '0');
		}

		function __destruct()
		{
			parent::__destruct();
		}
		
		public function setDisplayProfile()
		{
			$this->reset(); // remove QUERYXML, DISPLAYXML, ISQUERY & ISDISPLAY
			$this->setReturnService('INFO');
			$this->setDefaultSort('INFO/MODIFICATIONDATE', 'descending');
		}

		public function parse(&$data_array)
		{
			return parent::parse($data_array);
		}

		/* *** */

        public function countHits()
        {
            $target_element = new Element($this->getInfo('MODULE'));
            $target_element->createRootNode($this->getQueryString());
            return $target_element->count();
        }

		public function getStaticCommand($results_name='filter-data')
		{
			$element_node = $this->getElementNode();

			$static_full_command = '
				<RESULTS name="'.$results_name.'" static="true">'.
					$element_node->toString('./*').
				'</RESULTS>';

			return $static_full_command;
		}

		/* QUERY */

        public function setQueryXML($query_string)
        {
            $this->getInfoNode('QUERYXML')->removeChild('./*');
            $this->getInfoNode('QUERYXML')->appendChild($query_string);
            $this->setInfo('ISQUERY', '1');
        }

		public function getStaticQueryCommand($results_name='filter-query')
		{
			$static_query_command = '
				<RESULTS name="'.$results_name.'" static="true">'.
					$this->getQueryString().
				'</RESULTS>';

			return $static_query_command;
		}

		public function getQueryString()
		{
			$query_node = $this->getInfoNode('QUERYXML');
			$query_string = $query_node->toString('./*');
			return $query_string;
		}

        public function getQueryNode()
        {
            return $this->getInfoNode('QUERYXML');
        }

		public function cloneQuery(&$target_filter)
		{
			$query_node = $this->getInfoNode('QUERYXML');

			if ($query_node !== false)
			{
				$this->getInfoNode()->removeChild('QUERYXML');
			}

			$this->createInfoNode('QUERYXML');

			$query_node = $this->getInfoNode('QUERYXML');
			$target_query_node = $target_filter->getInfoNode('QUERYXML');
			$target_nodes = $target_query_node->getElements('./*');

			if (!empty($target_nodes))
			{
				foreach ($target_nodes as $node)
				{
					$query_node->appendChild($node->toString());
				}

				$this->setInfo('ISQUERY', 1);
			}
			else
			{
				$this->setInfo('ISQUERY', 0);
			}
		}

		/* DISPLAY */

        public function setDisplayXML($display_string)
        {
            $this->getInfoNode('DISPLAYXML')->removeChild('./*');
            $this->getInfoNode('DISPLAYXML')->appendChild($display_string);
            $this->setInfo('ISDISPLAY', '1');
        }
        public function addDisplayXML($display_string)
        {
            $this->getInfoNode('DISPLAYXML')->appendChild($display_string);
            $this->setInfo('ISDISPLAY', '1');
        }

		public function cloneDisplay(&$target_filter)
		{
			$display_node = $this->getInfoNode('DISPLAYXML');

			if ($display_node !== false)
			{
				$this->getInfoNode()->removeChild('DISPLAYXML');
			}

			$this->createInfoNode('DISPLAYXML');

			$display_node = $this->getInfoNode('DISPLAYXML');
			$target_display_node = $target_filter->getInfoNode('DISPLAYXML');
			$target_nodes = $target_display_node->getElements('./*');

			if (!empty($target_nodes))
			{
				foreach ($target_nodes as $node)
				{
					$display_node->appendChild($node->toString());
				}

				$this->setInfo('ISDISPLAY', 1);
			}
			else
			{
				$this->setInfo('ISDISPLAY', 0);
			}
		}

		public function getStaticDisplayCommand($results_name='filter-display')
		{
			$static_display_command = '
				<RESULTS name="'.$results_name.'" static="true">'.
					$this->getDisplayString().
				'</RESULTS>';

			return $static_display_command;
		}

		public function getDisplayString()
		{
			$display_node = $this->getInfoNode('DISPLAYXML');
			$display_string = $display_node->toString('./*');
			return $display_string;
		}

        public function getDisplayNode()
        {
            return $this->getInfoNode('DISPLAYXML');
        }

        /* *** */
        
        public function save_as_last($module_name, $usage='user')
        {
        	$module_name = strtolower($module_name);
	    	$tab_session_ID = $_POST['tabSessionID'];
	    	//echo "<br />Save ($module_name, $usage, $tab_session_ID)<br />";
	    	
            $this->setInfo('ISDISPLAY', 1);
            $this->setInfo('DEFAULT', 1);
            $this->setInfo('MODULE', $module_name);
            $this->setInfo('USAGE', $usage);
            $this->setInfo('OWNERID', $user_ID);

            $this->setInfo('DENOMINATION', 'Your last search filter');
            $this->setInfo('SEARCH', 1);
            //$this->logCommand(true, false);
            
	        $_SESSION[$tab_session_ID]['filters'][$module_name][$usage] = $this->getNQLCommand();
	        //var_dump($_SESSION[$tab_session_ID]['filters'][$module_name][$usage]);
	       	
            /*$module_name = strtolower($module_name);
            $user_ID = getUserID();

            $user_filter = new FilterElement();

            $user_filter->removeInfo('ISQUERY');
            $user_filter->setSearchInfo('ISDISPLAY', '=', 1);
            $user_filter->setSearchInfo('DEFAULT', '=', 1);
            $user_filter->setSearchInfo('MODULE', '=', $module_name);
            $user_filter->setSearchInfo('USAGE', '=', $usage);
            $user_filter->setSearchInfo('OWNERID', '=', $user_ID);

            if ($user_filter->find() == true)
            {
                $this->setID($user_filter->getID());
            }
            else
            {
                $this->removeID(); // just in case...
            }

            $this->removeInfo('CREATIONDATE');
            $this->removeInfo('MODIFICATIONDATE');

            $this->setInfo('ISDISPLAY', 1);
            $this->setInfo('DEFAULT', 1);
            $this->setInfo('MODULE', $module_name);
            $this->setInfo('USAGE', $usage);
            $this->setInfo('OWNERID', $user_ID);

            $this->setInfo('DENOMINATION', 'Your last search filter');
            $this->setInfo('SEARCH', 1);

            //$this->logCommand(true, false, true);
            return $this->save();*/
        }

        public static function restore_last_filter($module_name, $usage='user')
        {
            // try the default user filter
            /*$module_name = strtolower($module_name);
            $user_ID = getUserID();

            $restored_filter = new FilterElement();

            $restored_filter->removeInfo('ISQUERY');
            $restored_filter->setSearchInfo('ISDISPLAY', '=', 1);
            $restored_filter->setSearchInfo('DEFAULT', '=', 1);
            $restored_filter->setSearchInfo('MODULE', '=', $module_name);
            $restored_filter->setSearchInfo('USAGE', '=', $usage);
            $restored_filter->setSearchInfo('OWNERID', '=', $user_ID);

            if ($restored_filter->find() == false)
            {
                // get the main default filter
                $restored_filter = self::restore_default_filter($module_name, $usage);
                $restored_filter->setInfo('OWNERID', $user_ID);
                $restored_filter->setInfo('DENOMINATION', 'Your last search filter');
                $restored_filter->create();
            }

            $restored_filter->removeID(); // prevent from unwanted modifications

            return $restored_filter;*/
        	        	
        	$module_name = strtolower($module_name);
	    	$tab_session_ID = $_POST['tabSessionID'];	    	
	        $restored_filter_NQL = $_SESSION[$tab_session_ID]['filters'][$module_name][$usage];	          
	        
	        /*echo "<br />Restore ($module_name, $usage, $tab_session_ID)<br />";
	        var_dump($restored_filter_NQL);*/
	        
	        $restored_filter = new FilterElement();
	        	         
	        if (empty($restored_filter_NQL))
	        {
	            // load default filter
	            $restored_filter->setInfo('DEFAULT', 1);
	            $restored_filter->setInfo('MODULE', $module_name);
	            $restored_filter->setInfo('USAGE', $usage);
	            $restored_filter->setInfo('OWNERID', 0);
	            $restored_filter->setInfo('ISDISPLAY', 1);
	
	            $restored_filter->find();
	                        
	            // just in case : not to overwrite the default
	            $restored_filter->removeID(); 
	            $restored_filter->removeInfo('ACTIVITY'); 
	            $restored_filter->removeInfo('CREATORID'); 
	            $restored_filter->removeInfo('OWNERID'); 
	            $restored_filter->removeInfo('MODIFIERID'); 
	            $restored_filter->removeInfo('GROUPID'); 
	            $restored_filter->removeInfo('CREATIONDATE'); 
	            $restored_filter->removeInfo('MODIFICATIONDATE'); 
	
	            $restored_filter->save_as_last($module_name, $usage);
	        }
	        else
	        {
	            $restored_filter->createFromXML($restored_filter_NQL);
	        }
	        
	       	//$restored_filter->logCommand(true, false);
	        	
	        return $restored_filter;
        }

        public static function restore_default_filter($module_name, $usage='user')
        {
            $module_name = strtolower($module_name);

            $default_filter = new FilterElement();

            $default_filter->removeInfo('ISQUERY');
            $default_filter->setSearchInfo('ISDISPLAY', '=', 1);
            $default_filter->setSearchInfo('DEFAULT', '=', 1);
            $default_filter->setSearchInfo('MODULE', '=', $module_name);
            $default_filter->setSearchInfo('USAGE', '=', $usage);
            $default_filter->setSearchInfo('OWNERID', '=', 0);

            $default_filter->find(); // must exist in DB!
            
            /*echo 'Restore default<br />';
            $default_filter->logCommand(true, false);*/

            $default_filter->removeID(); // prevent from unwanted modifications

            return $default_filter;
        }
	}
?>