<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/filter/load.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" indent="yes" method="text" />

    <xsl:template match="/RESPONSE">
        <xsl:text>{</xsl:text>
        <xsl:text>"status":"success",</xsl:text>
        <xsl:text>"columns":[</xsl:text>
            <xsl:for-each select="$filter-display/RETURN//*[not(*)]">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <xsl:text>"</xsl:text>
                <xsl:choose>
                    <xsl:when test="ancestor::DEPENDENCY">
                        <xsl:text>DEPENDENCY[@type=\"</xsl:text>
                        <xsl:value-of select="current()/../../@type"/>
                        <xsl:text>\"]/</xsl:text>
                        <xsl:value-of select="name(.)"/>
                   </xsl:when>
                    <xsl:when test="name()='CATEGORIES'">
                        <xsl:text>CATEGORIES</xsl:text>
                    </xsl:when>
                   <xsl:otherwise>
                        <xsl:value-of select="name(..)"/>
                        <xsl:text>/</xsl:text>
                        <xsl:value-of select="name(.)"/>
                   </xsl:otherwise>
                </xsl:choose>
                <xsl:text>"</xsl:text>
                <xsl:if test="position() != last()">
                    <xsl:text>,</xsl:text>
                </xsl:if>
            </xsl:for-each>
            <xsl:text>],</xsl:text>
            <xsl:text>"sort":"</xsl:text><xsl:value-of select="$filter-display/SORT/@select"/><xsl:text>",</xsl:text>
            <xsl:text>"order":"</xsl:text><xsl:value-of select="$filter-display/SORT/@order"/><xsl:text>",</xsl:text>
            <xsl:text>"display":</xsl:text><xsl:value-of select="$filter-display/PAGINATE/@display"/><xsl:text>,</xsl:text>
            <xsl:text>"page":</xsl:text><xsl:value-of select="$filter-display/PAGINATE/@page"/>
        <xsl:text>}</xsl:text>
    </xsl:template>
</xsl:stylesheet>
