<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/filter/save.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');

    /* *** */

    $response = new JSONResponse();
    $response->set('module', 'OFFICITY:FILTER');

    $MODULE_NAME = strtolower($_POST['module']);
    if (empty($MODULE_NAME))
    {
        $response->outputError('No module specified!');
	}
    $response->set('filtermodule', $MODULE_NAME);

    /* *** */

    $element = new Element($MODULE_NAME);

    if ($_POST['filter-query'] == 'true')
    {
        $element->initSearchConfigCommand();
	    $element->advancedSearchParsing($_POST);
	}

    if ($_POST['filter-display'] == 'true')
    {
	    $columns = explode(',', $_POST['columns']);
	    $element->setSearchReturn($columns);
	    $element->setSort($_POST['sort'], $_POST['order']);
	    $element->setDefaultPaginate($_POST['display']);
	}

    $filter = $element->buildSearchFilter();

    $filter->setInfo('MODULE', $MODULE_NAME);
	$filter->setInfo('DENOMINATION', $_POST['filter-name']);

    if ($_POST['filter-shared'] == 'shared')
    {
        $filter->setInfo('OWNERID', 0);
    }
    else
    {
        $user = new OfficityUser();
        $filter->setInfo('OWNERID', $user->getID());
    }

    $filter->setInfo('ISQUERY', ($_POST['filter-query'] == 'true') ? 1 : 0);
    $filter->setInfo('ISDISPLAY', ($_POST['filter-display'] == 'true') ? 1 : 0);
	$filter->setInfo('COUNT', ($_POST['filter-count'] == 'true') ? 1 : 0);
	$filter->setInfo('SEARCH', ($_POST['filter-search'] == 'true') ? 1 : 0);

    //$filter->logCommand();

    // update
	if ($_POST['filter-overwrite'] == 'true')
    {
        $FILTER_ID = $_POST['filterID'];
        if (empty($FILTER_ID))
        {
           $response->outputError('Update failed : no filter ID!');
        }
        $response->set('ID', $FILTER_ID);

        $filter->setInfo('ID', $FILTER_ID);
        if ($filter->update() == true)
        {
           $response->outputSuccess();
        }
        else
        {
            $response->outputError('Update failed: '.$filter->getLastError());
        }
	}
    else // create new
    {
        if ($filter->create() == true)
        {
            $response->set('ID', $filter->getID());
            $response->outputSuccess();
        }
        else
        {
            $response->outputError('Create failed: '.$filter->getLastError());
        }
    }
?>