<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/followup/followup.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- followup details in list -->
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-detail">
		<li id="followup-{@ID}">
			<h2>
				<xsl:apply-templates select="INFO/CONTACT" mode="element-label"/>
				<xsl:text> - </xsl:text>
				<xsl:apply-templates select="INFO/CREATIONDATE" mode="datetime"/>
				<xsl:if test="INFO/FILE/text()">
					<xsl:text> - </xsl:text>
					<a href="{/RESPONSE/NECTIL/files_url}{INFO/FILE}" target="_blank" title="View/Download" style="cursor:pointer !important;">
						<xsl:call-template name="basename">
							<xsl:with-param name="path" select="INFO/FILE" />
						</xsl:call-template>
					</a>
				</xsl:if>
			</h2>
			<h3><xsl:value-of select="INFO/TITLE"/></h3>
			<p>
				<xsl:copy-of select="INFO/BODY/node()"/>
			</p>
		</li>
	</xsl:template>

	<xsl:template match="OFFICITY:FOLLOWUP[INFO/TYPE='internal']" mode="element-detail">
		<li id="followup-{@ID}" class="internal">
			<h2>
				<xsl:apply-templates select="INFO/CONTACT" mode="element-label"/>
				<xsl:text> - </xsl:text>
				<xsl:apply-templates select="INFO/CREATIONDATE" mode="datetime"/>
				<xsl:if test="INFO/FILE/text()">
					<xsl:text> - </xsl:text>
					<a href="{/RESPONSE/NECTIL/files_url}{INFO/FILE}" target="_blank" title="View/Download" style="cursor:pointer !important;">
						<xsl:call-template name="basename">
							<xsl:with-param name="path" select="INFO/FILE" />
						</xsl:call-template>
					</a>
				</xsl:if>
			</h2>
			<h3><xsl:value-of select="INFO/TITLE"/></h3>
			<p>
				<xsl:copy-of select="INFO/BODY/node()"/>
			</p>
		</li>
	</xsl:template>
</xsl:stylesheet>