<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/list/Export.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!-- parameters -->
	<xsl:param name="domain" select="/RESPONSE/URL/domain" />
	<xsl:param name="list" select="/RESPONSE/URL/list" />
	
    <xsl:param name="tabsID">
        <xsl:text>tabs-export-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel" />
    </xsl:template>
	
	<xsl:template name="panel-block-details"> 
		<xsl:attribute name="class">
			<xsl:text>block block-details extra-wide</xsl:text>
		</xsl:attribute>
		 
        <h2 class="list-item">
        	<xsl:text>Export </xsl:text>
        	<xsl:value-of select="$domain" />
        	<xsl:if test="$list/text()">
        		<xsl:text> &gt; </xsl:text>
        		<xsl:value-of select="$list" />
        	</xsl:if>
        </h2>
                        
        <!-- TABS -->
        <div id="{$tabsID}" class="tab">
	        <!-- TABS LIST -->
	        <xsl:variable name="sharedList" select="/RESPONSE/RESULTS[@name='shared']/LIST" />
			<ul>
				<xsl:if test="$sharedList/ITEM">
					<li>
						<a href="#tab-export-list-shared-{$panelID}">
							<xsl:text>Shared (</xsl:text>
							<xsl:value-of select="count($sharedList/ITEM)" />
							<xsl:text>)</xsl:text>
						</a>
					</li>
				</xsl:if>
				<xsl:for-each select="/RESPONSE/RESULTS[@name!='shared']">
					<xsl:variable name="listItems" select="LIST/ITEM[not($sharedList/ITEM/@label=@label and $sharedList/ITEM/@value=@value)]" />
					<xsl:if test="$listItems">
						<li>
							<a href="#tab-export-list-{@name}-{$panelID}">
								<xsl:value-of select="@label" />
								
								<xsl:text> (</xsl:text>
								<xsl:value-of select="count($listItems)" />
								<xsl:text>)</xsl:text>
							</a>
						</li>
					</xsl:if>
				</xsl:for-each>
			</ul>
			<xsl:if test="$sharedList/ITEM">
	            <form id="tab-export-list-shared-{$panelID}" onsubmit="return false;">
			        <table class="fields">
			            <tr>
			                <td colspan="2" align="left">
			                    <strong>[domain],[list name],[language ID],[label],[value]</strong>
			                </td>
			            </tr>
			            <tr>
			                <td colspan="2" align="left">
			                    <textarea class="input-textarea">
					                <xsl:apply-templates select="$sharedList" mode="csv-content">
							        	<xsl:with-param name="listItems" select="$sharedList/ITEM" />
					                </xsl:apply-templates>
			                    </textarea>
			                </td>
			            </tr>
			        </table>
	            </form>
            </xsl:if>
            <xsl:for-each select="/RESPONSE/RESULTS[@name!='shared']">
				<xsl:variable name="listItems" select="LIST/ITEM[not($sharedList/ITEM/@label=@label and $sharedList/ITEM/@value=@value)]" />
				<xsl:if test="$listItems">
		            <form id="tab-export-list-{@name}-{$panelID}" onsubmit="return false;">
				        <table class="fields">
				            <tr>
				                <td colspan="2" align="left">
				                    <strong>[domain],[list name],[language ID],[label],[value]</strong>
				                </td>
				            </tr>
				            <tr>
				                <td colspan="2" align="left">
				                    <textarea class="input-textarea">
						                <xsl:apply-templates select="LIST" mode="csv-content">
						                	<xsl:with-param name="listItems" select="$listItems" />
						                </xsl:apply-templates>
				                    </textarea>
				                </td>
				            </tr>
				        </table>
		            </form>
            	</xsl:if>
            </xsl:for-each>
        </div>
	</xsl:template>

    <xsl:template match="LIST" mode="csv-content">    	
    	<xsl:param name="listItems" />
    	<xsl:variable name="domain" select="@domain" />
    	<xsl:variable name="name" select="@name" />
    	<xsl:variable name="languageID" select="parent::RESULTS/@name" />

       	<xsl:for-each select="$listItems">
       		<xsl:sort select="@label" />
       		<xsl:value-of select="$domain" />
       		<xsl:text>,</xsl:text>
       		<xsl:value-of select="$name" />
       		<xsl:text>,</xsl:text>
       		<xsl:value-of select="$languageID" />
       		<xsl:text>,</xsl:text>
       		<xsl:value-of select="@label" />
       		<xsl:text>,</xsl:text>
       		<xsl:value-of select="@value" />
       		<xsl:text>&#10;</xsl:text>
       	</xsl:for-each>
    </xsl:template>

    <xsl:template name="panel-js">
    	<xsl:call-template name="js-init-autoresize" />
		<xsl:call-template name="js-init-tabs" />
    </xsl:template>
</xsl:stylesheet>