<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/list/list.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- LABEL(s) -->
	<xsl:template match="LIST" mode="element-label-list">
		<xsl:value-of select="@name"/>
	</xsl:template>
	
	<!-- ICON(s) -->
    <xsl:template match="LIST" mode="element-icon-list">
        <xsl:text>../system/images/icons/lists/list.png</xsl:text> 
    </xsl:template>
    
    <!-- INFO LABEL(s) -->
    <xsl:template match="LIST" mode="element-info-list">
        <xsl:value-of select="count(ITEM)" />
        <xsl:text> value(s)</xsl:text> 
    </xsl:template>
	
	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="LIST" mode="element-navitem-list">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">list-<xsl:value-of select="@name"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label-list"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail-list"/>
			</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>domain:'</xsl:text>
                <xsl:value-of select="@domain"/>
                <xsl:text>'</xsl:text>
                <xsl:text>,list:'</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text>'</xsl:text>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon-list"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info-list"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="LIST" mode="element-script-detail-list">
		<xsl:text>../../system/tools/list/Values</xsl:text>
	</xsl:template>
	
	<!--         -->
	<!-- DOMAINS -->
	<!--         -->
	
	<!-- LABEL(s) -->
	<xsl:template match="LIST" mode="domain-label">
		<xsl:value-of select="@domain"/>
	</xsl:template>
	
	<!-- ICON(s) -->
    <xsl:template match="LIST" mode="domain-icon">
        <xsl:text>../system/images/icons/lists/domain.png</xsl:text> 
    </xsl:template>
    
    <!-- NAVIGATION ITEM(s) -->
	<xsl:template name="domain-navitem">
		<xsl:param name="element" />
		<xsl:param name="info" />
		
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">domain-<xsl:value-of select="$element/@domain"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="$element" mode="domain-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="$element" mode="domain-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>domain:'</xsl:text>
				<xsl:value-of select="$element/@domain"/>
			    <xsl:text>'</xsl:text>
		       </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="$element" mode="domain-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:value-of select="$info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- SCRIPTS -->
	<xsl:template match="LIST" mode="domain-script-detail">
		<xsl:text>../../system/tools/list/Lists</xsl:text>
	</xsl:template>
	
	<!--       -->
	<!-- ITEMS -->
	<!--       -->
	
	<!-- LABEL(s) -->
	<xsl:template match="ITEM" mode="element-label">
		<xsl:value-of select="@label"/>
	</xsl:template>
	
	<!-- ICON(s) -->
    <xsl:template match="ITEM" mode="element-icon">
    </xsl:template>
    
    <!-- INFO LABEL(s) -->
    <xsl:template match="ITEM" mode="element-info">
        <xsl:value-of select="@value"/>
    </xsl:template>
    
    <!-- NAVIGATION ITEM(s) -->
    <xsl:template match="ITEM" mode="element-navitem">
	    <xsl:call-template name="navigationitem">
	    	<xsl:with-param name="id">listitem-<xsl:value-of select="@value"/></xsl:with-param>
	        <xsl:with-param name="title">
	            <xsl:apply-templates select="." mode="element-label"/>
	        </xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
	        <xsl:with-param name="params">
	            <xsl:text>domain:'</xsl:text>
	            <xsl:value-of select="/RESPONSE/URL/domain"/>
	            <xsl:text>'</xsl:text>
	            <xsl:text>,list:'</xsl:text>
	            <xsl:value-of select="/RESPONSE/URL/list"/>
	            <xsl:text>'</xsl:text>
	            <xsl:text>,languageID:'</xsl:text>
	            <xsl:value-of select="../../@name"/>
	            <xsl:text>'</xsl:text>
	            <xsl:text>,label:'</xsl:text>
	            <xsl:call-template name="escape-javascript">
	                <xsl:with-param name="string" select="@label"/>
	            </xsl:call-template>
	            <xsl:text>'</xsl:text>
	            <xsl:text>,value:'</xsl:text>
	            <xsl:call-template name="escape-javascript">
	                <xsl:with-param name="string" select="@value"/>
	            </xsl:call-template>
	            <xsl:text>'</xsl:text>
	        </xsl:with-param>
			<!--xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param-->
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
	    </xsl:call-template>
    </xsl:template>
    
	<xsl:template name="nav-newlistitem">
		<xsl:param name="title" select="'Add list item(s)...'" />
    	<xsl:param name="domain" />
    	<xsl:param name="list" />
    	<xsl:param name="languageID" />
    	<xsl:param name="info" />
	    
	    <xsl:call-template name="navigationitem">
		    <xsl:with-param name="title" select="$title" />
		    <xsl:with-param name="panelURI">../../system/tools/list/New</xsl:with-param>
		    <xsl:with-param name="params">
		        <xsl:text>domain:'</xsl:text>
		        <xsl:value-of select="$domain"/>
		        <xsl:text>'</xsl:text>
		        <xsl:if test="$list">
		        	<xsl:text>,list:'</xsl:text>
		        	<xsl:value-of select="$list"/>
		        	<xsl:text>'</xsl:text>
		        </xsl:if>
		        <xsl:if test="$languageID">
		        	<xsl:text>,languageID:'</xsl:text>
		        	<xsl:value-of select="$languageID"/>
		        	<xsl:text>'</xsl:text>
		        </xsl:if>
		    </xsl:with-param>
		    <xsl:with-param name="icon">../system/images/icons/add/add-new.png</xsl:with-param>
		    <xsl:with-param name="info" select="$info" />
		    <xsl:with-param name="cssclass">grey-bkgnd</xsl:with-param>
	    </xsl:call-template>
	</xsl:template>
    
    <!-- SCRIPTS -->
   	<xsl:template match="ITEM" mode="element-script-detail">
		<xsl:text>../../system/tools/list/Details</xsl:text>
	</xsl:template>
</xsl:stylesheet>
