<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/list/ops.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');
	
	$DATABASE = $GLOBALS["generic_backoffice_db"];

    /* *** */

    function encode_value($raw_value)
    {
        $value = trim($raw_value);
        $value = utf8_To_UnicodeEntities($value);
        //var_dump($value);
        //die('error');
        return $value;
    }

    /* *** */

    $response = new JSONResponse();
    $response->set('object', 'LIST ITEM');

    $ACTION = $_GET['action'];
	if (!in_array($ACTION, array('create', 'update', 'delete', 'import')))
	{
        $response->outputError('Invalid action "'.$ACTION.'"!');
	}
    $response->set('action', $ACTION);

    /* *** */

    if ($ACTION != 'import')
    {
        $DOMAIN = $_POST['domain'];
        $response->set('domain', $DOMAIN);

        $LIST = $_POST['list'];
        if (empty($LIST))
        {
            $response->outputError('No list!');
        }
        $response->set('list', $LIST);

        $LABEL = $_POST['label'];
        if (empty($LABEL))
        {
            $response->outputError('No label!');
        }
        $response->set('label', stripcslashes($LABEL)); // for AJAX response
        $LABEL = encode_value($LABEL);

        $VALUE = $_POST['value'];
        $response->set('value', stripcslashes($VALUE)); // for AJAX response
        $VALUE = encode_value($VALUE);

        $LANGUAGE_ID = $_POST['languageID'];
        if (empty($LANGUAGE_ID))
        {
            $response->outputError('No language ID!');
        }
        $response->set('languageID', $LANGUAGE_ID);
    }

    /* *** */

    $result = false;
    $output_message = '';

    switch ($ACTION)
    {
        case 'create':
            $sql_query  = "INSERT INTO `$DATABASE`.`lists` (`Name` ,`Domain` ,`LanguageID` ,`Label` ,`Value`) ";
            $sql_query .= "VALUES ('$LIST', '$DOMAIN', '$LANGUAGE_ID', '$LABEL', '$VALUE');";

            $db_connection = db_connect();
            if ($db_connection->Execute($sql_query) == false)
            {
                $output_message = $db_connection->ErrorMsg();
            }
            else
            {
                $result = true;
            }
            break;

        case 'update':
            $PREVIOUS_DOMAIN = $_POST['previousDomain'];
            $response->set('previousDomain', $PREVIOUS_DOMAIN);

            $PREVIOUS_LIST = $_POST['previousList'];
            if (empty($PREVIOUS_LIST))
            {
                $response->outputError('No previous list!');
            }
            $response->set('previousList', $PREVIOUS_LIST);

            $PREVIOUS_LABEL = $_POST['previousLabel'];
            if (empty($PREVIOUS_LABEL))
            {
                $response->outputError('No previous label!');
            }            
            $PREVIOUS_LABEL = encode_value($PREVIOUS_LABEL);
            $response->set('previousLabel', $PREVIOUS_LABEL);

            $PREVIOUS_VALUE = $_POST['previousValue'];            
            $PREVIOUS_VALUE = encode_value($PREVIOUS_VALUE);
            $response->set('previousValue', $PREVIOUS_VALUE);

            $PREVIOUS_LANGUAGE_ID = $_POST['previousLanguageID'];
            if (empty($PREVIOUS_LANGUAGE_ID))
            {
                $response->outputError('No previous language ID!');
            }
            $response->set('previousLanguageID', $PREVIOUS_LANGUAGE_ID);

            $sql_query  = "UPDATE `$DATABASE`.`lists`  SET `Name` = '$LIST', `Domain` = '$DOMAIN', `LanguageID` = '$LANGUAGE_ID' ";
            $sql_query .= ", `Label` = '$LABEL', `Value` = '$VALUE' ";
            $sql_query .= "WHERE `lists`.`Name` = '$PREVIOUS_LIST' AND `lists`.`Domain` = '$PREVIOUS_DOMAIN'  AND `lists`.`LanguageID` = '$PREVIOUS_LANGUAGE_ID' ";
            $sql_query .= "AND `lists`.`Label` = '$PREVIOUS_LABEL' AND `lists`.`Value` = '$PREVIOUS_VALUE' LIMIT 1;";

            $db_connection = db_connect();
            if ($db_connection->Execute($sql_query) == false)
            {

                $output_message = $db_connection->ErrorMsg();
            }
            else
            {
                $result = true;
            }
            break;

        case 'delete':
            $sql_query  = "DELETE FROM `$DATABASE`.`lists` WHERE `lists`.`Name` = '$LIST' AND `lists`.`Domain` = '$DOMAIN' AND `lists`.`LanguageID` = '$LANGUAGE_ID' ";
            $sql_query .= "AND `lists`.`Label` = '$LABEL' AND `lists`.`Value` = '$VALUE' LIMIT 1;";

            $db_connection = db_connect();
            if ($db_connection->Execute($sql_query) == false)
            {
                $output_message = $db_connection->ErrorMsg();
            }
            else
            {
                $result = true;
            }
            break;

        case 'import':
            $CSV_VALUES = $_POST['csv-values'];
            if (empty($CSV_VALUES))
            {
                $response->outputError('No CSV values!');
            }

            $result = true;
            $db_connection = db_connect();
            
            $lines = explode(chr(10), $CSV_VALUES);
            foreach ($lines as $line)
            {
                $line = trim($line);
                list($domain, $list, $language_id, $label, $value) = explode(',', $line, 5);

                $sql_query  = "INSERT INTO `$DATABASE`.`lists` (`Name` ,`Domain` ,`LanguageID` ,`Label` ,`Value`) ";
                $sql_query .= "VALUES ('$list', '$domain', '$language_id', '$label', '$value');";

                if ($db_connection->Execute($sql_query) == false)
                {
                    $output_message .= $db_connection->ErrorMsg().chr(13).chr(10);
                    $result = false;
                }
            }
            break;

        default:
            break;
    }

	if ($result === true)
	{
        $response->outputSuccess($output_message);
	}
    else
	{
        $response->outputError('Action failed: '.$output_message);
	}
?>