<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/module/module.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <!-- LABEL(s) -->
	<xsl:template match="MODULE" mode="element-label">
    	<xsl:apply-templates select="INFO/DENOMINATION" mode="display-value"/>
	</xsl:template>
	
	<!-- ICON(s) -->
	<xsl:template match="MODULE" mode="element-icon">
        <xsl:text>../system/images/icons/modules/module.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="MODULE" mode="element-navitem-fields">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>

		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail-fields"/>
			</xsl:with-param>
			<xsl:with-param name="params">
                <xsl:text>ID:</xsl:text>
                <xsl:value-of select="@ID"/>
                <xsl:text>,module:'</xsl:text>
                <xsl:value-of select="INFO/DENOMINATION"/>
                <xsl:text>'</xsl:text>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="MODULE" mode="element-navitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>

		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
                <xsl:text>ID:</xsl:text>
                <xsl:value-of select="@ID"/>
                <xsl:text>,module:'MODULE'</xsl:text>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="MODULE" mode="element-script-detail-fields">
		<xsl:text>../../system/tools/module/Fields</xsl:text>
	</xsl:template>
</xsl:stylesheet>