<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/page/page.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com" >
   	<!-- HTML HEADER -->
	<xsl:template match="SHELLCONFIG" mode="page-header">
		<head>
			<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" name="viewport" />
			<title>
				<xsl:choose>
					<xsl:when test="$editorName and $appName and $editorName!='' and $appName!=''">
						<xsl:value-of select="$editorName" />
		                <xsl:text> Application - </xsl:text>
		                <xsl:value-of select="$appName" />
	                </xsl:when>
	                <xsl:otherwise>
	                	<xsl:text>Officity</xsl:text>
	                </xsl:otherwise>
                </xsl:choose>
			</title>
			<link href="http://www.nectil.com/paperclip.ico" type="image/x-icon" rel="icon" />
			<xsl:apply-templates select="." mode="page-header-css" />
			<xsl:apply-templates select="." mode="page-header-js" />
		</head>		
	</xsl:template>
	
	<!-- CSS -->
	<xsl:template match="SHELLCONFIG[ENVIRONMENT='development']" mode="page-header-css">
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/common.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/jquery-ui-1.7.2.custom.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/jquery.ui.autocomplete.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/officity.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/error.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/login.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/header-tools.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/modal.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/datagrid.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/search.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/history.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/followup.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/skills.css"/>
              
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/contact.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/group.css"/>       
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/mailing.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/publish.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/wiki.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/task.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/environment.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/namespace.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/application.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/processor.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/module.css"/>
       <link rel="stylesheet" type="text/css" href="{$systemURL}css/libitem.css"/>
       
       <xsl:call-template name="page-header-css-add" />
	</xsl:template>
	
	<xsl:template name="page-header-css-add">
	</xsl:template>
	
	<xsl:template match="SHELLCONFIG[ENVIRONMENT='production']" mode="page-header-css">
		<style media="screen" type="text/css">
			@import '<xsl:value-of select="$systemURL"/>css/load-css.php';			
		</style>
		<xsl:call-template name="page-header-css-add" />
	</xsl:template>
	
	<!-- JS -->
	<xsl:template match="SHELLCONFIG[ENVIRONMENT='development']" mode="page-header-js">
		<script type="text/javascript" src="{$systemURL}js/jQuery/jquery-1.4.2.min.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jQuery/jquery-ui-1.8.2.custom.min.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jQuery/jquery.easing.1.3.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.ajaxfileupload.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.jscrolltouch.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.autoresize.js">&#160;</script>
		
		<script type="text/javascript" src="{$systemURL}js/md5.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/utils.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.utils.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.detection.utils.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.panel.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.panelhistory.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.panelslider.js">&#160;</script>
		<script type="text/javascript" src="{$systemURL}js/jquery.shell.js">&#160;</script>
		
       <script type="text/javascript" src="{$systemURL}js/ajax-request.js">&#160;</script>            
       <script type="text/javascript" src="{$systemURL}js/dialog-modal.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/dialog-notification.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/inputs-validator.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/form-manager.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/data-checker.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/quicksearcher.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/jquery.advancedsearcher.js">&#160;</script>
           
       <script type="text/javascript" src="{$systemURL}js/tiny_mce/tiny_mce.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/si.files.js">&#160;</script>
       <script type="text/javascript" src="{$systemURL}js/swfobject-2.2.js">&#160;</script>
       
       <xsl:call-template name="page-header-js-add" />
	</xsl:template>
	
	<xsl:template name="page-header-js-add">
	</xsl:template>
	
	<!-- TODO -->
	<xsl:template match="SHELLCONFIG[ENVIRONMENT='production']" mode="page-header-js">
		<script type="text/javascript" src="{$systemURL}js/load-js.php">&#160;</script>		    
       <xsl:call-template name="page-header-js-add" />
	</xsl:template>

	<!-- HTML BODY -->
	<xsl:template match="SHELLCONFIG" mode="page-body">
		<xsl:param name="visitorApps" />
		<body>
			<div id="container">
				<div id="shell">
					<div id="shell-bar">
						<table>
							<tr>
								<td id="left">
									<form id="shell-logout-form" method="POST" action="">
										<input type="hidden" name="logout" value="true" />
										<input type="hidden" name="editor" value="{$editorFolder}" />
										<input type="hidden" name="editorName" value="{$editorName}" />
										<input type="hidden" name="app" value="{$appFolder}" />
										<input type="hidden" name="appName" value="{$appName}" />
										<a href="#" id="shell-logout-action" title="Logout" onclick="$(this).closest('form').submit(); return false;" />
									</form>
								</td>
								<td id="center">
									&#160;
								</td>
								<td id="right">
									<a href="#" id="shell-user-action" title="User" onclick="" />
									<a href="#" id="shell-config-action" title="Configuration" onclick="" />
								</td>
							</tr>
						</table>
					</div>
					<div id="desktop">
						<xsl:for-each select="$visitorApps">
							<xsl:sort select="INFO/DENOMINATION" />
							<div class="app-container">
								<a href="#" class="app-icon" title="Open this application in a new tab">
									<xsl:attribute name="onclick">
										<xsl:text>window.open('</xsl:text>
										<xsl:value-of select="/RESPONSE/URL/appsURL" />
										<xsl:value-of select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />
										<xsl:text>/</xsl:text>
										<xsl:value-of select="INFO/URL" />');
									</xsl:attribute>	
									<div class="img-container">								
										<img>
											<xsl:attribute name="src">
												<xsl:choose>
													<xsl:when test="INFO/ICON/text()!=''">
														<xsl:value-of select="/RESPONSE/URL/appsURL" />
														<xsl:value-of select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />
														<xsl:text>/</xsl:text>
														<xsl:value-of select="INFO/ICON" />
													</xsl:when>
													<xsl:otherwise>												
														<xsl:value-of select="/RESPONSE/URL/systemImagesURL" />
														<xsl:text>shell/icon-defaultapp.png</xsl:text>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
										</img>	
									</div>								
								</a>
								<a href="#" class="app-denomination" title="Open this application in the current window">
									<xsl:attribute name="onclick">
										$('#shell').shell('openApp', 
											this, 
											$('#slider').children('div.panel').eq(0).attr('id'), 
											'HomePanel', 
											'<xsl:value-of select="INFO/DENOMINATION" />', 
											{
												editor:'<xsl:value-of select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />',
												app:'<xsl:value-of select="INFO/URL" />',												
												icon: '<xsl:value-of select="$systemImagesURL"/><xsl:text>/menu/history/appbar-home.png</xsl:text>'
											}, 
											'<xsl:value-of select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/EDITOR" />', 
											'Return to <xsl:value-of select="INFO/DENOMINATION" />',
											'<xsl:value-of select="$appsURL" /><xsl:value-of select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />/<xsl:value-of select="INFO/URL" />'
										);
									</xsl:attribute>
									<xsl:value-of select="INFO/DENOMINATION" />
								</a>
							</div>
						</xsl:for-each>
					</div>
				</div>
				<div id="window">
					<div id="menu-bar">
						<a id="mask" href="#" title="Return to the application" onclick="$('#shell').shell('toggle');" style="display:none;"/>
						<div id="app-navigation">							
							<ul id="history"/>
						</div>
						<div id="menu-options">
                        	<a id="toggle-shell" href="#" title="Go to shell" onclick="$('#shell').shell('toggle');" accesskey="d" />
	                        <a id="new-tab" href="#" title="Open the application in a new tab" onclick="window.open('{/RESPONSE/URL/appURL}', '');" accesskey="t" />
						</div>
						</div>
					<div id="slider" />
				</div>
			</div>
		</body>
	</xsl:template>
	
	<!-- JS : initialization -->
	<xsl:template match="SHELLCONFIG" mode="page-js">
		<xsl:param name="controllerName" select="CONTROLLERNAME"/>	
		<xsl:param name="optimalColumnWidth" select="OPTIMALCOLUMNWIDTH" />			
		<xsl:param name="homepanelURI" select="HOMEPANELURI"/>
		<xsl:param name="homePanelTitle" select="HOMEPANELTITLE"/>
		<xsl:param name="homeIcon" select="HOMEICON" />
		<xsl:param name="homeParams" select="HOMEPARAMS" />		
		<xsl:param name="initParams">
             <xsl:for-each select="/RESPONSE/URL/*">
                 <xsl:text>"</xsl:text>
                 <xsl:value-of select="name(.)" />
                 <xsl:text>"</xsl:text>
                 <xsl:text>:"</xsl:text>
                 <xsl:value-of select="." />
                 <xsl:text>"</xsl:text>
                 <xsl:if test="position()!=last()">
                 	<xsl:text>,</xsl:text>
                 </xsl:if>
             </xsl:for-each>
             <xsl:if test="not(/RESPONSE/URL/language)">
                 <xsl:text>,language:'</xsl:text>
                 <xsl:value-of select="/RESPONSE/NECTIL/language"/>
                 <xsl:text>'</xsl:text>
             </xsl:if>
		</xsl:param>	
		
		<xsl:apply-templates select="." mode="page-controller-js">
			<xsl:with-param name="controllerName" select="$controllerName"/>	
			<xsl:with-param name="optimalColumnWidth" select="$optimalColumnWidth" />			
			<xsl:with-param name="homepanelURI" select="$homepanelURI"/>
			<xsl:with-param name="homePanelTitle" select="$homePanelTitle"/>
			<xsl:with-param name="homeIcon" select="$homeIcon" />
			<xsl:with-param name="homeParams" select="$homeParams" />		
			<xsl:with-param name="initParams" select="$initParams" />	
		</xsl:apply-templates>
				
        <xsl:apply-templates select="." mode="page-shell-js">
        	<xsl:with-param name="show" select="not($homepanelURI) or $homepanelURI=''" />
        </xsl:apply-templates>
        
        <xsl:if test="ENVIRONMENT='production'">
	        addExternalJS('<xsl:value-of select="$systemURL" />js/tiny_mce/tiny_mce.js');
        </xsl:if>
	</xsl:template>
	
	<xsl:template match="SHELLCONFIG" mode="page-controller-js">
		<xsl:param name="controllerName" select="CONTROLLERNAME"/>	
		<xsl:param name="optimalColumnWidth" select="OPTIMALCOLUMNWIDTH" />			
		<xsl:param name="homepanelURI" select="HOMEPANELURI"/>
		<xsl:param name="homePanelTitle" select="HOMEPANELTITLE"/>
		<xsl:param name="homeIcon" select="HOMEICON" />
		<xsl:param name="homeParams" select="HOMEPARAMS" />		
		<xsl:param name="initParams">
             <xsl:for-each select="/RESPONSE/URL/*">
                 <xsl:text>"</xsl:text>
                 <xsl:value-of select="name(.)" />
                 <xsl:text>"</xsl:text>
                 <xsl:text>:"</xsl:text>
                 <xsl:value-of select="." />
                 <xsl:text>"</xsl:text>
                 <xsl:if test="position()!=last()">
                 	<xsl:text>,</xsl:text>
                 </xsl:if>
             </xsl:for-each>
             <xsl:if test="not(/RESPONSE/URL/language)">
                 <xsl:text>,language:'</xsl:text>
                 <xsl:value-of select="/RESPONSE/NECTIL/language"/>
                 <xsl:text>'</xsl:text>
             </xsl:if>
		</xsl:param>		
				
        <xsl:value-of select="$controllerName" /> = $('#slider').panelslider({
            <xsl:copy-of select="$initParams" />
            <xsl:if test="$optimalColumnWidth">
				<xsl:text>,optimalColumnWidth:</xsl:text>
				<xsl:value-of select="$optimalColumnWidth"/>
            </xsl:if>
            <xsl:if test="not(/RESPONSE/URL/panelURI)">
            	<xsl:text>, "panelURI":'</xsl:text>
            	<xsl:value-of select="$homepanelURI"/>
            	<xsl:text>', "title":'</xsl:text>
            	<xsl:value-of select="$homePanelTitle"/>
            	<xsl:text>', "icon":'</xsl:text>
            	<xsl:value-of select="$homeIcon"/>
            	<xsl:text>'</xsl:text>
            	<xsl:if test="$homeParams">
            		<xsl:text>,</xsl:text>
            		<xsl:value-of select="$homeParams" />
            	</xsl:if>
            </xsl:if>
         });
	</xsl:template>
	
	<xsl:template match="SHELLCONFIG" mode="page-shell-js">
		<xsl:param name="show" select="false()"/>
         $('#shell').shell({
         	<xsl:if test="$show=true()">
	         	<xsl:text>show:true</xsl:text>
         	</xsl:if>
         });
	</xsl:template> 
</xsl:stylesheet>