<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/form.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!--			 			-->	
	<!-- HEADER TOOLBAR FORMS  	-->
	<!--			 			-->
 	
 	<xsl:template name="header-quicksearch-input">
	    <xsl:param name="ID" select="'quicksearch-text'" />
	    <xsl:param name="searchText" select="'Quick search...'" />
	    <xsl:param name="color" select="'#bbbbbb'" />
	    <xsl:param name="resetID" select="'quicksearch-reset'" />
	    <xsl:param name="resetTitle" select="'Reset search'" />
	    <div class="input-container">
		    <div class="img-quicksearch" />
	 		<input id="{$ID}" class="input" type="text" value="" default-value="{$searchText}" default-color="{$color}"/>
	 		<a href="#" id="{$resetID}" class="reset-button" title="{$resetTitle}" />
 		</div>
 	</xsl:template> 
 		
 	<xsl:template name="header-input">
	    <xsl:param name="ID" />
	    <xsl:param name="name" />
	    <xsl:param name="addText" select="'Add...'" />
	    <xsl:param name="color" select="'#bbbbbb'" />
	    <xsl:param name="imgcssclass" />
	    <div class="input-container">
		    <div class="{$imgcssclass}" />
	 		<input id="{$ID}" name="{$name}" class="input" type="text" value="" default-value="{$addText}" default-color="{$color}"/>
 		</div>
 		<input type="submit" style="display:none;" /> <!-- enable form submission using enter -->
 	</xsl:template> 	
 	
	<!--      			-->
	<!-- ELEMENT FORMS 	-->
	<!--       			-->
	
    <xsl:template name="form-empty-line">
    	<tr><td colspan="2">&#160;</td></tr> 
    </xsl:template>
    
    <xsl:template name="form-line">
    	<xsl:param name="content" />
    	<xsl:param name="center" select="false()" />
    	<tr>
    		<td colspan="2">
    			<xsl:if test="$center=true()">
    				<xsl:attribute name="align">
    					<xsl:text>center</xsl:text>
    				</xsl:attribute>
    			</xsl:if>
    			<xsl:copy-of select="$content" />
			</td>
		</tr> 
    </xsl:template>
    
	<!-- overview tabs -->
    <xsl:template name="overview-fieldset">
	    <xsl:param name="legend" />
	    <xsl:param name="content" />
        <fieldset>
            <legend><xsl:value-of select="$legend" /></legend>
            <table class="fields">
				<xsl:copy-of select="$content" />
            </table>
        </fieldset>
    </xsl:template>
    
    <xsl:template match="INFO/*" mode="overview-line">    	
    	<xsl:param name="label">
	        <xsl:apply-templates select="$fields[INFO/DENOMINATION=name(current())]" mode="field-name" />
	        <xsl:text>:</xsl:text>
    	</xsl:param>
    	<xsl:param name="value">
            <xsl:call-template name="field-value">
            	<xsl:with-param name ="field" select="$fields[INFO/DENOMINATION=name(current())]"/>
            	<xsl:with-param name ="node" select="."/>
           	</xsl:call-template>
    	</xsl:param>
    	<xsl:param name="hidden" select="false()" />
    	<xsl:param name="topLabel" select="false()" />
    	
    	<xsl:variable name="hiddenclass">
    		<xsl:if test="$hidden=true()">
    			<xsl:text>hidden</xsl:text>
    		</xsl:if>
    	</xsl:variable>

	    <tr class="{$hiddenclass}">
	        <td class="field-name">
            	<xsl:if test="$topLabel=true()">
	            	<xsl:attribute name="valign">
	            		<xsl:text>top</xsl:text>
	            	</xsl:attribute>
            	</xsl:if>
				<xsl:copy-of select="$label"/>
	        </td>
	        <td class="field-value-overview">
	            <xsl:copy-of select="$value"/>
	        </td>
	    </tr>
    </xsl:template>
    
    <xsl:template match="DESCRIPTION/* | DESCRIPTION/CUSTOM/*" mode="overview-line">    	
	    <xsl:param name="label">
	        <xsl:apply-templates select="." mode="desc-field-name" />
	        <xsl:text>:</xsl:text>
	    </xsl:param>	    
	    <xsl:param name="type" select="'text'" />
    	<xsl:param name="value">
    		<xsl:choose>
    			<xsl:when test="$type='xml'">
            		<xsl:apply-templates select="." mode="display-xml"/>
            	</xsl:when>
    			<xsl:when test="$type='styled'">
            		<xsl:apply-templates select="." />
            	</xsl:when>
            	<xsl:otherwise>
            		<xsl:value-of select="." />
            	</xsl:otherwise>
            </xsl:choose>
    	</xsl:param>

	    <tr>
	        <td class="field-name">
				<xsl:copy-of select="$label"/>
	        </td>
	        <td class="field-value-overview">
	            <xsl:copy-of select="$value"/>
	        </td>
	    </tr>
    </xsl:template>
    
    <xsl:template name="overview-line">
	    <xsl:param name="label" />
    	<xsl:param name="value" />    	
    	<xsl:param name="cssclass" />   
    	<xsl:param name="hidden" select="false()" />
    	<xsl:param name="topLabel" select="false()" />
    	
    	<xsl:variable name="hiddenclass">
    		<xsl:if test="$hidden=true()">
    			<xsl:text>hidden</xsl:text>
    		</xsl:if>
    	</xsl:variable>
    	 	
        <tr class="{$cssclass} {$hiddenclass}">
            <td class="field-name">
            	<xsl:if test="$topLabel=true()">
	            	<xsl:attribute name="valign">
	            		<xsl:text>top</xsl:text>
	            	</xsl:attribute>
            	</xsl:if>
            	<xsl:copy-of select="$label"/>
            </td>
            <td class="field-value-overview">
                <xsl:copy-of select="$value"/>
            </td>
        </tr>
    </xsl:template>
    
	<!-- info forms -->
    <xsl:template name="form-fieldset">
	    <xsl:param name="legend" />
	    <xsl:param name="content" />
	    <tr><td colspan="2">
	        <fieldset>
	            <legend><xsl:value-of select="$legend" /></legend>
	            <table class="fields">
					<xsl:copy-of select="$content" />
	            </table>
	        </fieldset>
        </td></tr>
    </xsl:template>
    
    <xsl:template match="INFO/*" mode="form-info-line">    	
	    <xsl:param name="label">
	        <xsl:apply-templates select="$fields[INFO/DENOMINATION=name(current())]" mode="field-name" />
	        <xsl:text>:</xsl:text>
	    </xsl:param>
	    <xsl:param name="type" select="$fields[INFO/DENOMINATION=name(current())]/INFO/TYPE" />
	    <xsl:param name="required" select="false()" />
	    <xsl:param name="cssclass" />
	    <xsl:param name="inputValue" />
	    <xsl:param name="handlername" />
	    <xsl:param name="handler" />
    	<xsl:param name="input">
           <xsl:call-template name="field-input">
	           	<xsl:with-param name ="field" select="$fields[INFO/DENOMINATION=name(current())]"/>
	           	<xsl:with-param name ="node" select="."/>
	           	<xsl:with-param name ="inputValue" select="$inputValue" />
	           	<xsl:with-param name ="type" select="$type"/>
	           	<xsl:with-param name ="cssclass" select="$cssclass"/>
	           	<xsl:with-param name ="required" select="$required"/>
			    <xsl:with-param name="handlername" select="$handlername" />
			    <xsl:with-param name="handler" select="$handler" />
          	</xsl:call-template>
    	</xsl:param>    
    	<xsl:param name="extraLabel" />	
    	<xsl:param name="hidden" select="false()" />
    	<xsl:param name="topLabel" select="false()" />
    	
    	<xsl:variable name="hiddenclass">
    		<xsl:if test="$hidden=true()">
    			<xsl:text>hidden</xsl:text>
    		</xsl:if>
    	</xsl:variable>
    	
        <tr class="{$hiddenclass}">
            <td class="field-name">
            	<xsl:if test="$topLabel=true()">
	            	<xsl:attribute name="valign">
	            		<xsl:text>top</xsl:text>
	            	</xsl:attribute>
            	</xsl:if>
            	<xsl:if test="$required=true()">
            		<xsl:text>*</xsl:text>
            	</xsl:if>
				<xsl:value-of select="$label"/>
            </td>
            <td class="field-value">
                <xsl:copy-of select="$input"/>
                <xsl:if test="$extraLabel">
                	<label style="margin:0;"><xsl:copy-of select="$extraLabel" /></label>
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="form-info-line">    	
	    <xsl:param name="label" />
    	<xsl:param name="input" />
    	<xsl:param name="extraLabel" />	
    	<xsl:param name="hidden" select="false()" />
    	<xsl:param name="topLabel" select="false()" />
    	
    	<xsl:variable name="hiddenclass">
    		<xsl:if test="$hidden=true()">
    			<xsl:text>hidden</xsl:text>
    		</xsl:if>
    	</xsl:variable>
    	
        <tr class="{$hiddenclass}">
            <td class="field-name">
            	<xsl:if test="$topLabel=true()">
	            	<xsl:attribute name="valign">
	            		<xsl:text>top</xsl:text>
	            	</xsl:attribute>
            	</xsl:if>
				<xsl:value-of select="$label"/>
            </td>
            <td class="field-value">
                <xsl:copy-of select="$input"/>
                <xsl:if test="$extraLabel">
                	<label style="margin:0;"><xsl:copy-of select="$extraLabel" /></label>
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="*" mode="form-info-line-submit">
	    <xsl:param name="buttonLabel" select="'Update'"/>
	    <xsl:param name="createAndNew" select="false()"/>
	    <xsl:param name="cancel" select="false()"/>
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
                <input type="submit" name="create-update-button" class="input-submit-save" value="{$buttonLabel}" />
                
                <xsl:if test="$createAndNew=true()">
    	   			<input type="button" id="create-and-new-button" class="input-submit-save" value="Create and new" style="float:right;"/>
                </xsl:if>
                <xsl:if test="$cancel=true()">
    	   			<input type="button" id="cancel-button" class="input-submit-cancel" value="Cancel" style="float:right; margin-left:20px;"/>
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="form-info-line-submit">
	    <xsl:param name="buttonLabel" select="'Update'"/>
	    <xsl:param name="createAndNew" select="false()"/>
	    <xsl:param name="cancel" select="false()"/>
	    <xsl:param name="input" />
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
            	<xsl:choose>
            		<xsl:when test="$input">
            			<xsl:copy-of select="$input" />
            		</xsl:when>
            		<xsl:otherwise>
		                <input type="submit" name="create-update-button" class="input-submit-save" value="{$buttonLabel}" />
		                
		                <xsl:if test="$createAndNew=true()">
		    	   			<input type="button" id="create-and-new-button" class="input-submit-save" value="Create and new" style="float:right;"/>
		                </xsl:if>
		                <xsl:if test="$cancel=true()">
		    	   			<input type="button" id="cancel-button" class="input-submit-cancel" value="Cancel" style="float:right; margin-left:20px;"/>
		                </xsl:if>
	                </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>
    
	<!-- categories -->
    <xsl:template match="*" mode="form-categs-fieldset">
    	<xsl:param name="legend" />
    	<xsl:param name="categName" />
    	<xsl:variable name="categ" select="$categories[UNIQUENAME=$categName]"/>
    	<xsl:variable name="childCategs" select="$categ/CATEGORY[ISASSIGNABLE=1]"/>
    	<xsl:variable name="element" select="." />
        
		<!-- trick to create the category node so it'll remove all categories if nothing is selected -->
		<input type="hidden" value="1">
			<xsl:attribute name="name">
				<xsl:call-template name="gen-categ-input-name">
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="categName" select="''" />
				</xsl:call-template>
			</xsl:attribute>
		</input>
		
        <tr>
            <td colspan="2">
		        <fieldset>
		        	<legend>
		        		<xsl:choose>
		        			<xsl:when test="$legend">
		        				<xsl:value-of select="$legend" />
		        			</xsl:when>
		        			<xsl:otherwise>
		        				<xsl:value-of select="$categ/LABEL" />
	        				</xsl:otherwise>
		        		</xsl:choose>
					</legend>
		        	<table class="categs">
			        	<xsl:for-each select="$childCategs[(position() mod 2)=1]" >			        		
			        		<tr>
				        		<xsl:for-each select=".|following-sibling::*[position()&lt;=1]">
					        		<td>
							           <xsl:call-template name="categ-input">
							           		<xsl:with-param name ="moduleName" select="name($element)"/>
								           	<xsl:with-param name ="elementCategsNode" select="$element/CATEGORIES"/>
							           		<xsl:with-param name ="categoryNode" select="."/>							           	
							          	</xsl:call-template>
							          	<label>
					        				<xsl:value-of select="LABEL" />
					        			</label>
					        		</td>
				        		</xsl:for-each>
			        		</tr>
			        	</xsl:for-each>
		        	</table>
		        </fieldset>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="*" mode="form-categs-fetch">    	
    	<xsl:param name="legend" />    	
    	<xsl:param name="categName" />    	
    	<xsl:param name="fetchLabel" />
    	<xsl:param name="fetchInputID" />
    	
    	<xsl:variable name="element" select="." />
    	<xsl:variable name="categ" select="$categories[UNIQUENAME=$categName]"/>
     	<xsl:variable name="categPath">
     		<xsl:text>/</xsl:text>
     		<xsl:value-of select="$categName" />
     		<xsl:text>/</xsl:text>
     	</xsl:variable>
     	    	        
        <tr>
            <td colspan="2">
		        <fieldset>
		        	<legend>
		        		<xsl:choose>
		        			<xsl:when test="$legend">
		        				<xsl:value-of select="$legend" />
		        			</xsl:when>
		        			<xsl:otherwise>
		        				<xsl:value-of select="$categ/LABEL" />
	        				</xsl:otherwise>
		        		</xsl:choose>
					</legend>
		        	<table class="categs-fetch">
			       		<tr>
			        		<td colspan="2">
			        			<xsl:value-of select="$fetchLabel" />
			        			<input type="input" class="input-fetch" id="{$fetchInputID}" />
			        		</td>
			       		</tr>
			       		<tr><td colspan="2">&#160;</td></tr>
			       		
						<tr id="fetchcategory-template" style="display:none;">
			       			<td class="skill" style="font-style:italic;">
				       			<input id="fetchcategory-name" type="hidden" value="1">
					       			<!-- trick to create the category node so it'll remove all categories if nothing is selected -->
			        				<xsl:attribute name="name">
						        		<xsl:call-template name="gen-categ-input-name">
											<xsl:with-param name="moduleName" select="name($element)" />
											<xsl:with-param name="categName" select="''" />
										</xsl:call-template>
			        				</xsl:attribute>
				       			</input>
			       			</td>
			       			<td align="right">
			       				<a href="#" class="remove-skill" title="Remove this category">
			        				<xsl:attribute name="onclick">
			        					<xsl:text>$(this).closest('tr').remove();</xsl:text>	        					
			       					</xsl:attribute>
			    				</a>
			    			</td>
			       		</tr>
	        			
			       		<xsl:for-each select="$element/CATEGORIES/CATEGORY">
			       			<xsl:sort select="FATHERNAME" />
			       			<xsl:sort select="UNIQUENAME" />
			       			<xsl:if test="contains(current()/@path, $categPath)">
								<tr>
				        			<td class="skill">
					        			<input type="hidden" value="1">
					        				<xsl:attribute name="name">
								        		<xsl:call-template name="gen-categ-input-name">
													<xsl:with-param name="moduleName" select="name($element)" />
													<xsl:with-param name="categName" select="UNIQUENAME" />
												</xsl:call-template>
					        				</xsl:attribute>
					        			</input>
				        				<xsl:if test="$categ//CATEGORY[UNIQUENAME=current()/FATHERNAME]">
					        				<xsl:value-of select="$categ//CATEGORY[UNIQUENAME=current()/FATHERNAME]/LABEL" />
					        				<xsl:text> / </xsl:text>
				        				</xsl:if>
				        				<xsl:value-of select="LABEL" />
				        			</td>
				        			<td align="right">
				        				<a href="#" class="remove-skill" title="Remove this category">
					        				<xsl:attribute name="onclick">
					        					<xsl:text>$(this).closest('tr').remove();</xsl:text>	        					
				        					</xsl:attribute>
				       					</a>
				       				</td>
				        		</tr>
			        		</xsl:if>
			       		</xsl:for-each>
		        	</table>
		        </fieldset>
            </td>
        </tr>
    </xsl:template>
    
	<!-- descriptions forms -->
	<!-- TODO : use descriptionconfig -->
  	<xsl:template match="DESCRIPTION/* | DESCRIPTION/CUSTOM/*" mode="form-desc-line">
	    <xsl:param name="label">
	        <xsl:apply-templates select="." mode="desc-field-name" />
	        <xsl:text>:</xsl:text>
	    </xsl:param>	    
	    <xsl:param name="type" select="'textarea'" />
	    <xsl:param name="languageID" select="./ancestor::DESCRIPTION/@languageID" />
	    <xsl:param name="required" select="false()" />
	    <xsl:param name="cssclass" />
	    <xsl:param name="inputValue" />
    	<xsl:param name="input">
           <xsl:call-template name="desc-field-input">
	           	<xsl:with-param name ="node" select="."/>
	           	<xsl:with-param name="inputValue" select="$inputValue"/>
	           	<xsl:with-param name ="type" select="$type"/>
	           	<xsl:with-param name="languageID" select="$languageID" />
	           	<xsl:with-param name ="cssclass" select="$cssclass"/>
	           	<xsl:with-param name ="required" select="$required"/>
          	</xsl:call-template>
    	</xsl:param> 
		<xsl:param name="fullWidth" select="false()" />
		<xsl:param name="extraLabel" />
		<xsl:param name="topLabel" select="false()" />
		
		<xsl:choose>
			<xsl:when test="$fullWidth=false()">
			    <tr>
			        <td class="field-name">
		            	<xsl:if test="$topLabel=true()">
			            	<xsl:attribute name="valign">
			            		<xsl:text>top</xsl:text>
			            	</xsl:attribute>
		            	</xsl:if>
		            	<xsl:if test="$required=true()">
		            		<xsl:text>*</xsl:text>
		            	</xsl:if>
			            <xsl:value-of select="$label"/>
			        </td>
			        <td class="field-value">
			            <xsl:copy-of select="$input"/>
		                <xsl:if test="$extraLabel">
		                	<label style="margin:0;"><xsl:copy-of select="$extraLabel" /></label>
		                </xsl:if>
			        </td>
			    </tr>
		    </xsl:when>
		    <xsl:otherwise>
			    <tr>
			        <td colspan="2" align="center">
			            <xsl:copy-of select="$input"/>
		                <xsl:if test="$extraLabel">
		                	<label style="margin:0;"><xsl:copy-of select="$extraLabel" /></label>
		                </xsl:if>
			        </td>
			    </tr>
		    </xsl:otherwise>
	    </xsl:choose>
    </xsl:template>
    
  	<xsl:template name="form-desc-line">
  		<xsl:param name="moduleName" />
  		<xsl:param name="fieldName" />
	    <xsl:param name="label">
	        <xsl:value-of select="$fieldName" />
	        <xsl:text>:</xsl:text>
	    </xsl:param>	    
	    <xsl:param name="type" select="'textarea'" />
	    <xsl:param name="languageID" select="'shared'" />
	    <xsl:param name="required" select="false()" />
	    <xsl:param name="cssclass" />
	    <xsl:param name="inputValue" />
    	<xsl:param name="input">
           <xsl:call-template name="desc-field-input">
           		<xsl:with-param name="inputValue" select="$inputValue"/>
	           	<xsl:with-param name ="moduleName" select="$moduleName"/>
	           	<xsl:with-param name ="fieldName" select="$fieldName"/>
	           	<xsl:with-param name ="type" select="$type"/>
	           	<xsl:with-param name="languageID" select="$languageID" />
	           	<xsl:with-param name ="cssclass" select="$cssclass"/>
	           	<xsl:with-param name ="required" select="$required"/>
          	</xsl:call-template>
    	</xsl:param> 
    	<xsl:param name="fullWidth" select="false()" />
    	<xsl:param name="extraLabel" />
    	<xsl:param name="topLabel" select="false()" />
    	
		<xsl:choose>
			<xsl:when test="$fullWidth=false()">
			    <tr>
			        <td class="field-name">
		            	<xsl:if test="$topLabel=true()">
			            	<xsl:attribute name="valign">
			            		<xsl:text>top</xsl:text>
			            	</xsl:attribute>
		            	</xsl:if>
			            <xsl:value-of select="$label"/>
			        </td>
			        <td class="field-value">
			            <xsl:copy-of select="$input"/>
		                <xsl:if test="$extraLabel">
		                	<label style="margin:0;"><xsl:copy-of select="$extraLabel" /></label>
		                </xsl:if>
			        </td>
			    </tr>
		    </xsl:when>
		    <xsl:otherwise>
			    <tr>
			        <td colspan="2" align="center">
			            <xsl:copy-of select="$input"/>
		                <xsl:if test="$extraLabel">
		                	<label style="margin:0;"><xsl:copy-of select="$extraLabel" /></label>
		                </xsl:if>
			        </td>
			    </tr>
		    </xsl:otherwise>
	    </xsl:choose>
    </xsl:template>
    
    <xsl:template match="*" mode="form-desc-line-submit">
	    <xsl:param name="buttonLabel" select="'Update'"/>
	    <xsl:param name="createAndNew" select="false()"/>
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
                <input type="submit" name="create-button" class="input-submit-save" value="{$buttonLabel}"/>
                <xsl:if test="$createAndNew=true()">
    	   			<input type="button" id="create-and-new-button" name="create-and-new-button" class="input-submit-save" value="Create and new" style="float:right;"/>
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
    
	<xsl:template match="DESCRIPTION/* | DESCRIPTION/CUSTOM/*" mode="desc-field-name">
		<xsl:value-of select="name(.)"/>
	</xsl:template>    
	
    <!-- admin form -->
    <xsl:template match="*" mode="form-delete-line-submit">
	    <xsl:param name="buttonLabel" select="'Delete'"/>
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
                <input type="submit" name="delete-button" class="input-submit-remove" value="{$buttonLabel}"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="form-delete-line-submit">
	    <xsl:param name="buttonLabel" select="'Delete'"/>
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
                <input type="submit" name="delete-button" class="input-submit-remove" value="{$buttonLabel}"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="*" mode="form-duplicate-line-submit">
	    <xsl:param name="buttonLabel" select="'Duplicate'"/>
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
                <input type="button" name="duplicate-button" id="duplicate-button" class="input-submit-save" value="{$buttonLabel}"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="form-duplicate-line-submit">
	    <xsl:param name="buttonLabel" select="'Duplicate'"/>
        <tr>
            <td class="field-name">
            	&#160;
            </td>
            <td class="field-value">
                <input type="button" name="duplicate-button" id="duplicate-button" class="input-submit-save" value="{$buttonLabel}"/>
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>