<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/list.pager.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
    	
    <!--                           -->
    <!-- LISTS PAGING and BROWSING -->
    <!--                           -->

    <xsl:template name="list-pager">
        <xsl:param name="list"/>
        <xsl:param name="event" select="'loadpage'"/>

        <xsl:if test="$list/@pages &gt; 1">
            <div class="items pager">
                <table>
                    <tr>
                        <td class="items-pager-first">
                            <xsl:if test="$list/@page &gt; 1">
                                <a title="First page" href="#">
                                    <xsl:attribute name="onclick">
                                        <xsl:call-template name="triggerpanelevent">
                                            <xsl:with-param name="event" select="$event" />
                                            <xsl:with-param name="params" select="1" />
                                        </xsl:call-template>
                                    </xsl:attribute>
                                </a>
                            </xsl:if>
                        </td>
                        <td class="items-pager-previous">
                            <xsl:if test="$list/@page &gt; 1">
                                <a title="Previous page" href="#">
                                    <xsl:attribute name="onclick">
                                        <xsl:call-template name="triggerpanelevent">
                                            <xsl:with-param name="event" select="$event" />
                                            <xsl:with-param name="params" select="number($list/@page)-1" />
                                        </xsl:call-template>
                                    </xsl:attribute>
                                </a>
                            </xsl:if>
                        </td>
                        <td class="items-pager-count">
                            <div>
                                <xsl:choose>
                                    <xsl:when test="$list/@hits = 0 or not($list/*)">
                                        <xsl:text>No hits</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$list/@hits"/>
                                        <xsl:text> hit(s)</xsl:text>
                                        <xsl:text> - </xsl:text>
                                        <xsl:text>page </xsl:text>
                                        <xsl:value-of select="$list/@page"/>
                                        <xsl:text>/</xsl:text>
                                        <xsl:value-of select="$list/@pages"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </div>
                        </td>
                        <td class="items-pager-next">
                            <xsl:if test="$list/@page!=$list/@pages and $list/@pages!=1">
                                <a title="Next page" href="#">
                                    <xsl:attribute name="onclick">
                                        <xsl:call-template name="triggerpanelevent">
                                            <xsl:with-param name="event" select="$event" />
                                            <xsl:with-param name="params" select="number($list/@page)+1" />
                                        </xsl:call-template>
                                    </xsl:attribute>
                                </a>
                            </xsl:if>
                        </td>
                        <td class="items-pager-last">
                            <xsl:if test="$list/@page!=$list/@pages and $list/@pages!=1">
                                <a title="Last page" href="#">
                                    <xsl:attribute name="onclick">
                                        <xsl:call-template name="triggerpanelevent">
                                            <xsl:with-param name="event" select="$event" />
                                            <xsl:with-param name="params" select="number($list/@pages)" />
                                        </xsl:call-template>
                                    </xsl:attribute>
                                </a>
                            </xsl:if>
                        </td>
                    </tr>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

	<xsl:template name="list-browser">
		<xsl:param name="list"/>
        <xsl:param name="event" select="'loadpage'"/>

		<xsl:variable name="range" select="8"/>
		<xsl:variable name="delta" select="$range div 2"/>
		<xsl:variable name="hits" select="$list/@hits"/>
		<xsl:variable name="page" select="$list/@page"/>
		<xsl:variable name="pages" select="$list/@pages"/>

		<xsl:if test="$pages &gt; 1">
			<div class="list-browser">
				<div class="pager">
					<xsl:call-template name="pager-button">
						<xsl:with-param name="id" select="'1'"/>
						<xsl:with-param name="page" select="$page"/>
                        <xsl:with-param name="event" select="$event"/>
					</xsl:call-template>
					<xsl:if test="$pages &gt; 2">
						<xsl:text>&#160;-&#160;</xsl:text>
						<xsl:choose>
							<xsl:when test="$page &lt; $delta">
								<xsl:for-each select="//E[text() + 1 &lt; $range + 1]">
									<xsl:if test="text() + 1 &lt; $pages">
										<xsl:variable name="pageid" select="text() + 1"/>
										<xsl:call-template name="pager-button">
											<xsl:with-param name="id" select="$pageid"/>
											<xsl:with-param name="page" select="$page"/>
                                            <xsl:with-param name="event" select="$event"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:when test="$page &gt; $pages - $delta">
								<xsl:for-each select="//E[text() &lt; $range]">
									<xsl:if test="text() - 1 &gt; $range - $pages">
										<xsl:variable name="pageid" select="$pages - ($range - text())"/>
										<xsl:call-template name="pager-button">
											<xsl:with-param name="id" select="$pageid"/>
											<xsl:with-param name="page" select="$page"/>
                                            <xsl:with-param name="event" select="$event"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="//E[text() - 1 &lt; ($range - 1)]">
									<xsl:variable name="pageid" select="$page - $delta + text()"/>
									<xsl:call-template name="pager-button">
										<xsl:with-param name="id" select="$pageid"/>
										<xsl:with-param name="page" select="$page"/>
                                        <xsl:with-param name="event" select="$event"/>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<xsl:if test="$pages != 1">
						<xsl:text>&#160;-&#160;</xsl:text>
						<xsl:call-template name="pager-button">
							<xsl:with-param name="id" select="$pages"/>
							<xsl:with-param name="page" select="$page"/>
							<xsl:with-param name="pages" select="$pages"/>
                            <xsl:with-param name="event" select="$event"/>
						</xsl:call-template>
					</xsl:if>
				</div>
				<div class="hits">
	                <!--strong class="lasthits-count">
	                    <xsl:value-of select="$hits"/>
	                </strong>
	                <xsl:text> hit(s)</xsl:text-->
				</div>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template name="pager-button">
		<xsl:param name="id" select="1"/>
		<xsl:param name="page" select="1"/>
		<xsl:param name="pages"/>
        <xsl:param name="event"/>

        <xsl:choose>
            <xsl:when test="$page = $id">
                <strong>
                    <xsl:call-template name="pager-position">
                        <xsl:with-param name="id" select="$id"/>
                        <xsl:with-param name="pages" select="$pages"/>
                    </xsl:call-template>
                    <xsl:value-of select="$id"/>
                </strong>
            </xsl:when>
            <xsl:otherwise>
                <a href="#" title="Go to page {$id}">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="triggerpanelevent">
                            <xsl:with-param name="event" select="$event" />
                            <xsl:with-param name="params" select="$id" />
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="pager-position">
                        <xsl:with-param name="id" select="$id"/>
                        <xsl:with-param name="pages" select="$pages"/>
                    </xsl:call-template>
                    <xsl:value-of select="$id"/>
                </a>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template name="pager-position">
		<xsl:param name="id"/>
		<xsl:param name="pages"/>

		<xsl:attribute name="class">
			<xsl:text>pagecount </xsl:text>
			<xsl:if test="$id = 1">
				<xsl:text>first </xsl:text>
			</xsl:if>
			<xsl:if test="$id = $pages">
				<xsl:text>last </xsl:text>
			</xsl:if>
		</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>