<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.elementdetails.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
 
	<!--  ELEMENT DETAILS PANEL -->
	<xsl:template name="panel-elementdetails">
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" select="''" />
		<xsl:param name="fixedBodyHeight" select="''" />
		<xsl:param name="element" />
		<xsl:param name="title" />
		<xsl:param name="displaySusheeTab" select="false()" />
		<!-- default tabs -->
		<xsl:param name="tabsList">
			<xsl:text>info,Details;desc-</xsl:text>
			<xsl:value-of select="/RESPONSE/NECTIL/language" />
			<xsl:text>,</xsl:text>
			<xsl:text>Description (</xsl:text>
			<xsl:value-of select="/RESPONSE/NECTIL/language" />
			<xsl:text>);</xsl:text>
			<xsl:if test="$displaySusheeTab=true()">
				<xsl:text>sushee-info,Sushee;</xsl:text>
			</xsl:if>
		</xsl:param>		
		<xsl:param name="newElement" select="false()" />
		<xsl:param name="previewNode" select="$element/INFO/PREVIEW" />
	    <xsl:param name="displayOverviewTab" select="true()" />	    
	    <xsl:param name="displayAdminTab" select="true()" />	   
	    <xsl:param name="updateRight" select="true()" />
	    <xsl:param name="duplicateRight" select="false()" />
	    <xsl:param name="deleteRight" select="true()" />
	    <xsl:param name="displayNavDetails" select="true()" />
	    <xsl:param name="deleteConfirm" select="false()" />
	    <xsl:param name="deleteConfirmText">
       		<p>
          		<br />                
				<xsl:text>You are about to delete this element?</xsl:text>
				<br /><br />
				<strong>Are you sure?</strong>
                <br/><br /><br />
            </p>
	    </xsl:param>
		<xsl:param name="panelcssclass">
			<xsl:apply-templates select="$element" mode="element-panel-details-class"/>
		</xsl:param>
		<xsl:param name="blockcssclass" />
		<xsl:param name="titlecssclass">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name($element)"/>
        	</xsl:call-template>
		</xsl:param>
	    
	    <xsl:variable name="previewFormID">
	        <xsl:text>form-preview-</xsl:text><xsl:value-of select="$panelID"/>
	    </xsl:variable>
		
		<div class="panel-title-bar">
			<xsl:call-template name="panel-title-bar"/>
		</div>
        <div class="panel-header">
        	<xsl:if test="$fixedHeaderHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedHeaderHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
        	<xsl:call-template name="panel-header"/>
       	</div>
       	<div class="panel-body" optimal-width="{$optimalWidth}">
        	<xsl:if test="$fixedBodyHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedBodyHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
        	<xsl:call-template name="panel-body-loader"/>
			<div class="block block-details {$blockcssclass}">
				<xsl:call-template name="panel-body-element-title">
					<xsl:with-param name="title">
				    	<xsl:choose>
					    	<xsl:when test="$title">
						    	<h2 class="{$titlecssclass}">
									<xsl:value-of select="$title" />
								</h2>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="$element" mode="element-title" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
				</xsl:call-template>
				<!-- tabs -->
				<div class="tab">		
				
					<!-- TABS HEADERS -->
					
					<ul>
						<!-- overview -->
						<xsl:if test="$newElement=false() and $displayOverviewTab=true()">
							<xsl:call-template name="gen-tab-header">
								<xsl:with-param name="tabDenom" select="'overview'" />
								<xsl:with-param name="tabLabel">
									<img src="{$systemImagesURL}icons/overview-18.png"/>
								</xsl:with-param>
								<xsl:with-param name="cssclass" select="'overview'" />
							</xsl:call-template>
						</xsl:if>
						
						<!-- additional headers -->
						<xsl:call-template name="panel-body-element-tabs-headers">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="tabsList" select="$tabsList" />
						</xsl:call-template>
						
						<!-- admin -->
						<xsl:if test="$newElement=false() and $displayAdminTab=true()">
							<xsl:call-template name="gen-tab-header">
								<xsl:with-param name="tabDenom" select="'admin'" />
								<xsl:with-param name="tabLabel">
									 <img src="{$systemImagesURL}icons/i-12.png"/>
								</xsl:with-param>
								<xsl:with-param name="cssclass" select="'info'" />
							</xsl:call-template>
						</xsl:if>
					</ul>	
					
					<!-- TABS CONTENT -->
						
					<!-- overview -->
					<xsl:if test="$newElement=false() and $displayOverviewTab=true()">
						<xsl:call-template name="element-tab-create">
							<xsl:with-param name="denom" select="'overview'" />
							<xsl:with-param name="content">
								<xsl:call-template name="element-tab-overview">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="legend" select="'Overview'" />
								</xsl:call-template>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					
					<!-- additional content -->
					<div>
			        	<xsl:attribute name="id">
							<xsl:call-template name="gen-tabID">
								<xsl:with-param name="denom" select="'all-data-forms'" />
							</xsl:call-template>
			        	</xsl:attribute>
						<xsl:call-template name="panel-body-element-tabs-content">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="newElement" select="$newElement" />
							<xsl:with-param name="updateRight" select="$updateRight" />
							<xsl:with-param name="displaySusheeTab" select="$displaySusheeTab" />
						</xsl:call-template>
					</div>
					
					<!-- admin -->
					<xsl:if test="$newElement=false() and $displayAdminTab=true()">
			  			<xsl:call-template name="element-tabform-create">
							<xsl:with-param name="denom" select="'admin'" />
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="content">
								<xsl:call-template name="element-tab-admin">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="duplicateRight" select="$duplicateRight" />
									<xsl:with-param name="deleteRight" select="$deleteRight" />
								</xsl:call-template>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</div>
			</div>
			<!-- details navigation -->
			<xsl:if test="$displayNavDetails=true()">
				<div class="block-details-nav">
					<xsl:call-template name="panel-block-details-nav-element">
						<xsl:with-param name="element" select="$element" />
					</xsl:call-template>
				</div>
			</xsl:if>
			<!-- details preview (image management) -->
			<xsl:if test="$newElement=false()">
				<div class="block-details-preview">
					<xsl:call-template name="panel-block-details-preview-element">
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="previewNode" select="$previewNode" />
						<xsl:with-param name="previewFormID" select="$previewFormID" />
					</xsl:call-template>
				</div>
			</xsl:if>
        </div>
        <xsl:if test="$deleteConfirm=true()">
	        <div id="confirm-dialog-{$panelID}" title="Confirm element deletion" class="modal-dialog" align="center">
	            <form id="confirm-form-{$panelID}">
            		<xsl:copy-of select="$deleteConfirmText" />
	                <div class="controls">
	                    <a id="cancel-button" href="#">Cancel</a>&#160;&#160;&#160;&#160;
	                    <input id="ok-button" name="confirm-delete-button" type="button" value="Delete" class="modal-button"/>
	                </div>
	            </form>
	        </div>
        </xsl:if>
        <!--  JAVASCRIPT -->
        <script type="text/javascript">
        	<xsl:call-template name="panel-js-element">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="newElement" select="$newElement" />
				<xsl:with-param name="panelcssclass" select="$panelcssclass"/>
			</xsl:call-template>
			<xsl:if test="$newElement=false()">
	        	<xsl:call-template name="panel-js-element-preview">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="previewFormID" select="$previewFormID" />
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$updateRight=true()">
				<xsl:call-template name="panel-js-element-tabs">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="newElement" select="$newElement" />
					<xsl:with-param name="tabsList" select="'all-data-forms,;'" />
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$newElement=false() and $displayAdminTab=true()">
	        	<xsl:call-template name="panel-js-element-admin">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="adminDenom" select="'admin'" />
					<xsl:with-param name="deleteConfirm" select="$deleteConfirm" />
					<xsl:with-param name="deleteConfirmText" select="$deleteConfirmText" />
					<xsl:with-param name="duplicateRight" select="$duplicateRight" />
					<xsl:with-param name="deleteRight" select="$deleteRight" />
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="panel-add-js"/>
        </script>
    </xsl:template>
    
    <!-- utils : form hidden values (element-related) -->
    <xsl:template name="element-form-hiddenvalues">
    	<xsl:param name="element" />
    	<xsl:variable name="module">
			<xsl:call-template name="translate-namespace-name">
				<xsl:with-param name="name" select="name($element)" />
			</xsl:call-template>
    	</xsl:variable>
	   <input type="hidden" id="module" name="module" value="{name($element)}" />
	   <!-- allow contact module update, the contact module has ID=1 -->
	   <xsl:if test="(name($element)='MODULE') or ($element/@ID>1)">
		   <input type="hidden" id="ID" name="ID" value="{$element/@ID}"/>
	   </xsl:if>
	   <xsl:if test="$element/INFO/MODIFICATIONDATE != '0000-00-00 00:00:00'">
	   		<input type="hidden" class="modification-date" value="{$element/INFO/MODIFICATIONDATE}">
	   			<xsl:attribute name="name">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="$module" />
						<xsl:with-param name="fieldName" select="'modificationdate'"/>
						<xsl:with-param name="type" select="'datetime'" />
			      	</xsl:call-template>
	   			</xsl:attribute>
	   		</input>
	   </xsl:if>
    </xsl:template>
    
    <!-- utils : element form creation -->
	<xsl:template name="element-tabform-create">
		<xsl:param name="denom" />
		<xsl:param name="element" />
		<xsl:param name="content" />
		<xsl:param name="hiddenValues" select="true()"/>
			
     	<form onsubmit="return false;">
        	<xsl:attribute name="id">
				<xsl:call-template name="gen-tabID">
					<xsl:with-param name="denom" select="$denom" />
				</xsl:call-template>
        	</xsl:attribute>
        	
        	<xsl:if test="$hiddenValues=true()">
				<xsl:call-template name="element-form-hiddenvalues">
			    	<xsl:with-param name="element" select="$element" />
			   	</xsl:call-template>
		   	</xsl:if>
		   	
			<table class="fields"> 
				<xsl:copy-of select="$content" />
			</table>
		</form>
	</xsl:template>
	
    <!-- utils : element tab creation (for instance : details overview and static text contents) -->
	<xsl:template name="element-tab-create">
		<xsl:param name="denom" />
		<xsl:param name="content" />
			
     	<div>
        	<xsl:attribute name="id">
				<xsl:call-template name="gen-tabID">
					<xsl:with-param name="denom" select="$denom" />
				</xsl:call-template>
        	</xsl:attribute>
		   	
			<xsl:copy-of select="$content" />
		</div>
	</xsl:template>
	
	<!-- utils : tabs headers (LI items) generation  -->
	<xsl:template name="gen-tabs-headers">
		<xsl:param name="element" />
		<xsl:param name="tabsList" />
		
		<xsl:variable name="headerData" select="substring-before($tabsList, ';')" />
		
		<xsl:if test="$headerData">
			<xsl:variable name="tabDenom" select="substring-before($headerData, ',')" />
			<xsl:variable name="tabLabel" select="substring-after($headerData, ',')" />
			
			<xsl:call-template name="gen-tab-header">
				<xsl:with-param name="tabDenom" select="$tabDenom" />
				<xsl:with-param name="tabLabel" select="$tabLabel" />
			</xsl:call-template>
			
			<!-- recursive call -->
			<xsl:call-template name="gen-tabs-headers">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="tabsList" select="substring-after($tabsList, ';')" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!-- utils : tab header (LI items) creation  -->
	<xsl:template name="gen-tab-header">
		<xsl:param name="tabDenom" />
		<xsl:param name="tabLabel" />	
		<xsl:param name="cssclass" />	
			
		<li>
			<a class="{$cssclass}">
				<xsl:attribute name="href">
					<xsl:text>#</xsl:text>
					<xsl:call-template name="gen-tabID">
						<xsl:with-param name="denom" select="$tabDenom" />
					</xsl:call-template>
				</xsl:attribute>					
				<xsl:copy-of select="$tabLabel" />
			</a>
		</li>	
	</xsl:template>
	
	<!-- utils : tab ID generation  -->
	<xsl:template name="gen-tabID">
		<xsl:param name="denom" />
        <xsl:text>tab-</xsl:text>
        <xsl:value-of select="$denom" />
        <xsl:text>-</xsl:text>
        <xsl:value-of select="$panelID" />
	</xsl:template>
    
    <!-- element details : title -->
    <xsl:template name="panel-body-element-title">
    	<xsl:param name="title" />
		<xsl:copy-of select="$title" />
    </xsl:template>
	
	<!-- element details : tabs headers -->
	<xsl:template name="panel-body-element-tabs-headers">
		<xsl:param name="element" />
		<xsl:param name="tabsList" />
		
		<xsl:call-template name="gen-tabs-headers">
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="tabsList" select="$tabsList" />
		</xsl:call-template>
	</xsl:template>
	
  	<!-- element details : overview content  -->
    <xsl:template name="element-tab-overview">
    	<xsl:param name="element" />  
    	<xsl:param name="legend" select="'Overview'" />      	
        
	    <xsl:variable name="susheeFields" select="$fields[INFO/DENOMINATION='ID' or
					INFO/DENOMINATION='ACTIVITY' or
					INFO/DENOMINATION='ISLOCKED' or
					INFO/DENOMINATION='CREATORID' or
					INFO/DENOMINATION='OWNERID' or
					INFO/DENOMINATION='GROUPID' or
					INFO/DENOMINATION='MODIFIERID' or
					INFO/DENOMINATION='CREATIONDATE' or
					INFO/DENOMINATION='MODIFICATIONDATE' or
					INFO/DENOMINATION='SEARCHTEXT' or
					INFO/DENOMINATION='OWNERS' or
					INFO/DENOMINATION='GROUPS']" />
 		
 		<xsl:call-template name="form-fieldset">
 			<xsl:with-param name="legend">
 				<xsl:value-of select="$legend" />
 				<xsl:text> - Editor fields</xsl:text>
 			</xsl:with-param>
 			<xsl:with-param name="content">
		        <xsl:for-each select="$element/INFO/*[not($susheeFields/INFO/DENOMINATION=name()) and
			        	name()!='CREATOR' and name()!='MODIFIER' and name()!='OWNER']">
		            <xsl:sort select="name()" />
		       		<xsl:apply-templates select="." mode="overview-line" />
		        </xsl:for-each>
	        </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <!-- element details : overview note -->
    <xsl:template name="element-overview-note">
    	<xsl:param name="element" />  
    	
    	<xsl:variable name="noteID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="name($element)" />
				<xsl:with-param name="fieldName" select="'NOTES'" />
				<xsl:with-param name="type" select="'text'" />
			</xsl:call-template>
    	</xsl:variable>
    	<xsl:variable name="noteName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="name($element)" />
				<xsl:with-param name="fieldName" select="'NOTES'" />
				<xsl:with-param name="type" select="'text'" />
			</xsl:call-template>
    	</xsl:variable>

		<a href="#" title="Edit the note" class="edit-note-link">
			<xsl:if test="not($element/INFO/NOTES/text())">
				<xsl:attribute name="class">
					<xsl:text>edit-note-link no-note</xsl:text>
				</xsl:attribute>
				<xsl:attribute name="title">
					<xsl:text>Write a note</xsl:text>
				</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="onclick">
				$(this).hide();
				$('#<xsl:value-of select="$panelID" />.panel').find('#note').hide();
				$('#<xsl:value-of select="$panelID" />.panel').find('#write-note').show();
			</xsl:attribute>
		</a>
		<div class="clear"/>
		
		<div id="note" class="note hidden">
			<xsl:if test="$element/INFO/NOTES/text()">
				<xsl:attribute name="class">
					<xsl:text>note</xsl:text>
				</xsl:attribute>
			</xsl:if>
			<img src="{$systemImagesURL}icons/warning/warning.png" /> 
			<span id="note-content">
				<xsl:copy-of select="$element/INFO/NOTES/node()" />
			</span>
		</div>
	
		<fieldset id="write-note">
			<legend>Write a note</legend>
			<form>				
				<xsl:attribute name="onsubmit">
	                fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	                
	                fm.onSuccess(function(response){
						$('#<xsl:value-of select="$panelID" />.panel').find('#write-note').hide();
						var noteContent = fm.getData('<xsl:value-of select="$noteName"/>');
						$('#<xsl:value-of select="$panelID" />.panel').find('#noteBackup').val(noteContent);
						
						if (noteContent != '')
						{
							$('#<xsl:value-of select="$panelID" />.panel').find('#note-content').html(nl2br(noteContent));
							$('#<xsl:value-of select="$panelID" />.panel').find('#note').show();
							$('#<xsl:value-of select="$panelID" />.panel').find('.edit-note-link').removeClass('no-note').show();
						}
						else
						{
							$('#<xsl:value-of select="$panelID" />.panel').find('#note').hide();
							$('#<xsl:value-of select="$panelID" />.panel').find('.edit-note-link').addClass('no-note').show();
						}
						
						$('#<xsl:value-of select="$panelID" />.panel').find('.modification-date').val(response.now);
	                });
	
					fm.displayProcess('Updating note...');
	                fm.setScript('<xsl:apply-templates select="$element" mode="element-script-update"/>');
	                fm.parseAndSend(this);
	
	                return false;
				</xsl:attribute>
				
				<input type="hidden" name="ID" id="ID" value="{$element/@ID}" />
				
				<textarea name="noteBackup" id="noteBackup" class="hidden">
					<xsl:value-of select="$element/INFO/NOTES" />
				</textarea>
				
				<textarea id="{$noteID}" name="{$noteName}">
					<xsl:value-of select="$element/INFO/NOTES" />
				</textarea>
				
				<input type="submit" name="save-note-button" class="input-submit-save" value="Save" />	
							
				<input type="button" name="clear-note-button" class="input-submit-save" value="Clear">
					<xsl:attribute name="onclick">
						$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$noteID"/>').val('');
					</xsl:attribute>
				</input>
								
				<input type="button" onclick="" name="cancel-note-button" class="input-submit-remove" value="Cancel">
					<xsl:attribute name="onclick">						
						$(this).closest('fieldset').hide();
						var originalNote = $('#<xsl:value-of select="$panelID" />.panel').find('#noteBackup').val();
						if (originalNote != '')
						{
							$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$noteID"/>').val(originalNote);
							$('#<xsl:value-of select="$panelID" />.panel').find('#note').show();
						}
						$('#<xsl:value-of select="$panelID" />.panel').find('.edit-note-link').show();
					</xsl:attribute>
				</input>
			</form>
		</fieldset>
    </xsl:template>
	
	<!-- element details : tabs content  -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		<xsl:param name="updateRight" />
		<xsl:param name="displaySusheeTab" />
		
		<!-- INFO TAB -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'info'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-info">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="newElement" select="$newElement" />
					<xsl:with-param name="updateRight" select="$updateRight" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
				
		<!-- DESCRIPTIONS TAB -->
		<xsl:if test="$newElement=false()">
  			<xsl:call-template name="element-tabform-create">
				<xsl:with-param name="denom" select="concat('desc-',/RESPONSE/NECTIL/language)" />
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="content">
						<xsl:call-template name="element-tab-desc">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="newElement" select="$newElement" />
							<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
							<xsl:with-param name="updateRight" select="$updateRight" />
						</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- sushee -->
		<xsl:if test="$displaySusheeTab=true()">
			<xsl:call-template name="element-tabform-create">
				<xsl:with-param name="denom" select="'sushee-info'" />
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="content">
					<xsl:call-template name="element-tab-sushee">
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="newElement" select="$newElement" />
						<xsl:with-param name="updateRight" select="$updateRight" />
					</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
    
    <!-- element details : default editor info content  -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" /> 
        <xsl:param name="newElement" />
        <xsl:param name="updateRight" />
        
	    <xsl:variable name="susheeFields" select="$fields[INFO/DENOMINATION='ID' or
					INFO/DENOMINATION='ACTIVITY' or
					INFO/DENOMINATION='ISLOCKED' or
					INFO/DENOMINATION='CREATORID' or
					INFO/DENOMINATION='OWNERID' or
					INFO/DENOMINATION='GROUPID' or
					INFO/DENOMINATION='MODIFIERID' or
					INFO/DENOMINATION='CREATIONDATE' or
					INFO/DENOMINATION='MODIFICATIONDATE' or
					INFO/DENOMINATION='SEARCHTEXT' or
					INFO/DENOMINATION='OWNERS' or
					INFO/DENOMINATION='GROUPS']" />
 		
        <xsl:for-each select="$element/INFO/*[not($susheeFields/INFO/DENOMINATION=name()) and
	        	name()!='CREATOR' and name()!='MODIFIER' and name()!='OWNER']">
            <xsl:sort select="name()" />
       		<xsl:apply-templates select="." mode="form-info-line" />
        </xsl:for-each>
        
        <xsl:if test="$updateRight=true()">
	        <xsl:apply-templates select="$element" mode="form-info-line-submit">
	      		<xsl:with-param name="createAndNew" select="$newElement" />
	      		<xsl:with-param name="buttonLabel">
	      			<xsl:choose>
		      			<xsl:when test="$newElement=true()">
		      				<xsl:text>Create</xsl:text>
		      			</xsl:when>
		      			<xsl:otherwise>
		      				<xsl:text>Update</xsl:text>
		      			</xsl:otherwise>
	      			</xsl:choose>
	      		</xsl:with-param>
	      	</xsl:apply-templates>
      	</xsl:if>
    </xsl:template>
    
    <!-- element details : default sushee content -->
    <xsl:template name="element-tab-sushee">
        <xsl:param name="element" /> 
        <xsl:param name="newElement" />
        <xsl:param name="updateRight" />
        
	    <xsl:variable name="susheeFields" select="$fields[INFO/DENOMINATION='ID' or
					INFO/DENOMINATION='ACTIVITY' or
					INFO/DENOMINATION='ISLOCKED' or
					INFO/DENOMINATION='CREATORID' or
					INFO/DENOMINATION='OWNERID' or
					INFO/DENOMINATION='GROUPID' or
					INFO/DENOMINATION='MODIFIERID' or
					INFO/DENOMINATION='CREATIONDATE' or
					INFO/DENOMINATION='MODIFICATIONDATE' or
					INFO/DENOMINATION='SEARCHTEXT' or
					INFO/DENOMINATION='OWNERS' or
					INFO/DENOMINATION='GROUPS']" />
 		
        <xsl:for-each select="$element/INFO/*[$susheeFields/INFO/DENOMINATION=name() and
	        	name()!='ID' and name()!='ACTIVITY' and
	        	name()!='CREATORID' and name()!='CREATIONDATE' and  
	        	name() != 'MODIFIERID' and name() != 'MODIFICATIONDATE' and
	        	name()!='CREATOR' and name()!='MODIFIER' and name()!='OWNER']">
            <xsl:sort select="name()" />
       		<xsl:apply-templates select="." mode="form-info-line" />
        </xsl:for-each>
        
        <xsl:if test="$updateRight=true()">
	        <xsl:apply-templates select="$element" mode="form-info-line-submit">
	      		<xsl:with-param name="createAndNew" select="$newElement" />
	      		<xsl:with-param name="buttonLabel">
	      			<xsl:choose>
		      			<xsl:when test="$newElement=true()">
		      				<xsl:text>Create</xsl:text>
		      			</xsl:when>
		      			<xsl:otherwise>
		      				<xsl:text>Update</xsl:text>
		      			</xsl:otherwise>
	      			</xsl:choose>
	      		</xsl:with-param>
	      	</xsl:apply-templates>
      	</xsl:if>
    </xsl:template>
   
   <!-- element details: default description content -->
   <xsl:template name="element-tab-desc">
   		<xsl:param name="element" /> 
   		<xsl:param name="newElement" />
		<xsl:param name="languageID" />		   			
		<xsl:param name="updateRight" />
		
		<xsl:variable name="currentDesc" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID=$languageID]"/> 
				
		<xsl:choose>
			<xsl:when test="$currentDesc">
				<xsl:apply-templates select="$currentDesc/TITLE" mode="form-desc-line">			
					<xsl:with-param name="type" select="'text'" />
				</xsl:apply-templates>	
					
				<xsl:apply-templates select="$currentDesc/HEADER" mode="form-desc-line" />
				
				<xsl:apply-templates select="$currentDesc/BODY" mode="form-desc-line">
					<xsl:with-param name="label" select="'Body (styled):'"/>
					<xsl:with-param name="type" select="'styled'" />
				</xsl:apply-templates>
				
				<xsl:apply-templates select="$currentDesc/SUMMARY" mode="form-desc-line">
					<xsl:with-param name="type" select="'textarea'" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'TITLE'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="type" select="'text'" />
				</xsl:call-template>	
					
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'HEADER'" />
					<xsl:with-param name="languageID" select="$languageID" />
				</xsl:call-template>	
				
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'BODY'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="label" select="'Body (styled):'" />
					<xsl:with-param name="type" select="'styled'" />
				</xsl:call-template>	
				
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'SUMMARY'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="type" select="'textarea'" />
				</xsl:call-template>	
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:if test="$updateRight=true()">
			<xsl:apply-templates select="$element" mode="form-desc-line-submit">
	      		<xsl:with-param name="createAndNew" select="$newElement" />
	      		<xsl:with-param name="buttonLabel">
	      			<xsl:choose>
		      			<xsl:when test="$newElement=true()">
		      				<xsl:text>Create</xsl:text>
		      			</xsl:when>
		      			<xsl:otherwise>
		      				<xsl:text>Update</xsl:text>
		      			</xsl:otherwise>
	      			</xsl:choose>
	      		</xsl:with-param>
	      	</xsl:apply-templates>
      	</xsl:if>
  	</xsl:template>
    	
    <!-- element details : admin content -->
	<xsl:template name="element-tab-admin">
        <xsl:param name="element" />
        <xsl:param name="duplicateRight" />        
        <xsl:param name="deleteRight" />        

		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Element:'" />
			<xsl:with-param name="value">
            	<xsl:value-of select="name($element)"/>
                <xsl:text> (</xsl:text>
                <xsl:value-of select="$element/@ID" />
                <xsl:text>)</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
		
		<xsl:if test="$element/INFO/CREATORID">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Created by:'" />
				<xsl:with-param name="value">
	                <xsl:apply-templates select="$element/INFO/CREATOR/*" mode="element-label"/>
	                <xsl:text> (</xsl:text>
	                <xsl:apply-templates select="$element/INFO/CREATOR/*[1]/@email1" mode="display-value"/>
	                <xsl:text>, </xsl:text>
	                <xsl:value-of select="$element/INFO/CREATORID" />
	                <xsl:text>)</xsl:text>
				</xsl:with-param>
		</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$element/INFO/CREATIONDATE">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Created on:'" />
				<xsl:with-param name="value">
	                <xsl:apply-templates select="$element/INFO/CREATIONDATE" mode="datetime-long"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$element/INFO/MODIFIERID">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Modified by:'" />
				<xsl:with-param name="value">
	                <xsl:apply-templates select="$element/INFO/MODIFIER/*" mode="element-label"/>
	                <xsl:text> (</xsl:text>
	                <xsl:apply-templates select="$element/INFO/MODIFIER/*[1]/@email1" mode="display-value"/>
	                <xsl:text>, </xsl:text>
	                <xsl:value-of select="$element/INFO/MODIFIERID" />
	                <xsl:text>)</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$element/INFO/MODIFICATIONDATE">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Modified on:'" />
				<xsl:with-param name="value">
	                <xsl:apply-templates select="$element/INFO/MODIFICATIONDATE" mode="datetime-long"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$element/INFO/OWNERID">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Owner:'" />
				<xsl:with-param name="value">
	                <xsl:apply-templates select="$element/INFO/OWNER/*" mode="element-label"/>
	                <xsl:text> (</xsl:text>
	                <xsl:apply-templates select="$element/INFO/OWNER/*[1]/@email1" mode="display-value"/>
	                <xsl:text>, </xsl:text>
	                <xsl:value-of select="$element/INFO/OWNERID" />
	                <xsl:text>)</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$element/INFO/GROUPID">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Group:'" />
				<xsl:with-param name="value">
	                <select class="input-select-small">
	                	<xsl:attribute name="name">
							<xsl:apply-templates select="$element/INFO/GROUPID" mode="gen-info-input-name" />
	                	</xsl:attribute>
	                    <option value="0">
	                        <xsl:text>Public</xsl:text>
	                    </option>
	                    <xsl:for-each select="/RESPONSE/RESULTS[@name='groups']/GROUP">
	                    	<xsl:sort select="INFO/DENOMINATION" />
	                        <option value="{@ID}">
	                            <xsl:if test="$element/INFO/GROUPID = @ID">
	                                <xsl:attribute name="selected">selected</xsl:attribute>
	                            </xsl:if>
	                            <xsl:value-of select="INFO/DENOMINATION"/>
	                        </option>
	                    </xsl:for-each>
	                </select>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$element/INFO/ISLOCKED">
			<xsl:apply-templates select="$element/INFO/ISLOCKED" mode="form-info-line">
				<xsl:with-param name="label" select="'Lock:'" />
			</xsl:apply-templates>
		</xsl:if>
		
		<xsl:call-template name="form-empty-line" />
        <!--xsl:if test="$deleteRight=true()">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'XML:'" />
				<xsl:with-param name="value">
	                <a href="#" class="view" title="View object XML" onclick="$(this).hide(); $('#{$panelID}.panel').find('#objectxml-{$element/@ID}').show();" />
	                <textarea id="objectxml-{$element/@ID}" class="input-textarea" style="display:none; height:320px;">
	                    <xsl:copy-of select="$element"/>
	                </textarea>
				</xsl:with-param>
			</xsl:call-template>
        </xsl:if>
        <xsl:if test="$deleteRight=true()">
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'URL:'" />
				<xsl:with-param name="value">
	                <a href="#" class="view" title="View URL parameters" onclick="$(this).closest('tr').hide(); $('#{$panelID}.panel').find('.parms-{$element/@ID}').show();" />
				</xsl:with-param>
			</xsl:call-template>
			<xsl:for-each select="/RESPONSE/URL/*">
				<xsl:sort select="name(.)" />
				<xsl:call-template name="overview-line">
					<xsl:with-param name="label" select="concat(name(.),':')" />
					<xsl:with-param name="value">
						<xsl:value-of select="." />
					</xsl:with-param>							
					<xsl:with-param name="cssclass">
						<xsl:text>parms-</xsl:text>
						<xsl:value-of select="$element/@ID" />
						<xsl:text> hidden</xsl:text>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
        </xsl:if-->
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Application Editor:'" />
			<xsl:with-param name="value">
                <xsl:value-of select="/RESPONSE/URL/editorName"/>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Application:'" />
			<xsl:with-param name="value">
                <xsl:value-of select="/RESPONSE/URL/appName"/>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Panel:'" />
			<xsl:with-param name="value">
                <xsl:value-of select="/RESPONSE/URL/editor"/>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="/RESPONSE/URL/app"/>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="/RESPONSE/URL/panelURI"/>
                <xsl:text> (#</xsl:text>
                <xsl:value-of select="$panelID" />
                <xsl:text>)</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
		
		<xsl:if test="$duplicateRight=true()">
			<xsl:apply-templates select="$element" mode="form-duplicate-line-submit" />
		</xsl:if>
		
         <xsl:if test="$deleteRight=true()">
             <xsl:apply-templates select="$element" mode="form-delete-line-submit" />
        </xsl:if>
    </xsl:template>
    
    <!-- element details : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
            <xsl:with-param name="cssclass">first</xsl:with-param>
        </xsl:call-template>
        <xsl:for-each select="$depentities/DEPENDENCYTYPE[@from=$module and not(TYPE=preceding-sibling::DEPENDENCYTYPE/TYPE)]">
            <xsl:sort select="translate(TYPE, $xsltsl-str-lower, $xsltsl-str-upper)" />
			<xsl:call-template name="nav-links">
                <xsl:with-param name="title">
                    <xsl:apply-templates select="." mode="element-label-raw">
                    	<xsl:with-param name="element" select="$element" />
                    </xsl:apply-templates>
                </xsl:with-param>
				<xsl:with-param name="module" select="@from" />
				<xsl:with-param name="originID" select="$element/@ID" />
				<xsl:with-param name="targetModule" select="@to" />
				<xsl:with-param name="dependency" select="TYPE"/>
				<xsl:with-param name="panelURI" select="'../../system/tools/element/Link'"/>
			</xsl:call-template>
        </xsl:for-each>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
    
    <!-- raw display -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-label-raw">
		<xsl:param name="element" />
		
		<xsl:value-of select="TYPE" />
        <xsl:text> (</xsl:text>
		<xsl:value-of select="count($element/DEPENDENCIES/DEPENDENCY[@type=current()/TYPE]/*)" />
		<xsl:text>)</xsl:text>
	</xsl:template>
    
    <!-- element details : default preview (image management) -->
    <xsl:template name="panel-block-details-preview-element">
    	<xsl:param name="element" />
    	<xsl:param name="previewNode" />
    	<xsl:param name="previewFormID" />
    	
    	<xsl:if test="$previewNode/text()">    	
	        <form id="{$previewFormID}">
	            <input type="hidden" id="ID" name="ID" value="{$element/@ID}"/>
	            
	            <img src="{$systemToolsURL}preview.php?path={$previewNode}" alt="{$previewNode}" id="photo" />
	            <img src="{$systemImagesURL}loaders/ajax-loader.gif" style="display:none;" id="ajax-loader" />
	            <span id="status" />
	            <br />
	            <input id="remove" type="submit" value="Remove image" class="input-submit-remove" />
	        </form>
        </xsl:if>
    </xsl:template>
    
    <!-- element details js -->
	<xsl:template name="panel-js-element">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		<xsl:param name="panelcssclass" />
		
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:value-of select="$panelcssclass"/>');
		
		<xsl:call-template name="js-init-autoresize" />
		
		<xsl:call-template name="js-init-tabs" />

		<xsl:call-template name="js-init-datepicker">
			<xsl:with-param name="selector" select="'.input-date'"/>
		</xsl:call-template>
		
    	<xsl:call-template name="js-init-display-xml" />
	</xsl:template>
	
	<!-- element details : preview js -->
	<xsl:template name="panel-js-element-preview">
		<xsl:param name="element" />
		<xsl:param name="previewFormID" />
	
           $('#<xsl:value-of select="$previewFormID" />').submit(function() {
                fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
                
                var previewForm = $(this);

                previewForm.find('#photo').hide();
                previewForm.find('#status').hide();
                previewForm.find('#remove').hide();
                previewForm.find('#ajax-loader').show();

                fm.onSuccess(function(response){
                    previewForm.find('#ajax-loader').hide();
                });

                fm.onError(function(response){
                    var errorMsg;
                    if (response.errType == 'AJAX')
                    {
                        errorMsg = 'AJAX error ('+response.status+')!<br />';
                    }
                    else
                    {
                        errorMsg = response.message+'<br />';
                    }

                    previewForm.find('#ajax-loader').hide();
                    previewForm.find('#status').html('<span class="text-error">'+errorMsg+'</span>').show();
                    previewForm.find('#remove').show();
                });

                fm.setScript('<xsl:apply-templates select="$element" mode="element-script-ops"/>?action=remove-preview');
                fm.parseAndSend(this);

                return false;
            });
	</xsl:template>
	
	<!-- element details : default tabs js -->
	<xsl:template name="panel-js-element-tabs">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		<xsl:param name="tabsList" />
		
		<xsl:choose>
			<xsl:when test="$newElement=false()">		
				<xsl:variable name="headerData" select="substring-before($tabsList, ';')" />
				
				<xsl:if test="$headerData">
					<xsl:variable name="tabDenom" select="substring-before($headerData, ',')" />
					
					<xsl:call-template name="element-form-js">
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="newElement" select="$newElement" />
						<xsl:with-param name="tabDenom" select="$tabDenom" />
						<xsl:with-param name="addInputsValidation" select="true()" />
						<xsl:with-param name="processingMsg" select="'Updating element...'" />
						<xsl:with-param name="newPanelTitle" select="'Element (updated)'" />
					</xsl:call-template>
					
					<!-- recursive call -->
					<xsl:call-template name="panel-js-element-tabs">
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="newElement" select="$newElement" />
						<xsl:with-param name="tabsList" select="substring-after($tabsList, ';')" />
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="headerData" select="substring-before($tabsList, ';')" />
				<xsl:variable name="tabDenom" select="substring-before($headerData, ',')" />
			
				<xsl:call-template name="element-form-js">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="newElement" select="$newElement" />
					<xsl:with-param name="tabDenom" select="$tabDenom" />
					<xsl:with-param name="addInputsValidation" select="true()" />
					<xsl:with-param name="processingMsg" select="'Creating new element...'" />
					<xsl:with-param name="newPanelTitle" select="'Newly created element'" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- utils : element form js creation -->
	<xsl:template name="element-form-js">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		<xsl:param name="tabDenom" />
		<xsl:param name="addInputsValidation" select="true()" />
		<xsl:param name="processingMsg" />
		<xsl:param name="newPanelTitle" />
		
		<xsl:variable name="formID">
			<xsl:call-template name="gen-tabID">
				<xsl:with-param name="denom" select="$tabDenom" />
			</xsl:call-template>
		</xsl:variable>
		
		<!-- inputs validation -->
		var inputsValidator<xsl:value-of select="$panelID"/> = new InputsValidator(<xsl:value-of select="$panelID"/>, '#<xsl:value-of select="$formID" />');
		
		<xsl:choose>
			<xsl:when test="$newElement=true()">	
    		    $('#<xsl:value-of select="$formID" />').submit(function() {
          			fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
					fm.onSuccess(function(response){
					   var elemLabel = (response.label) 
					   		? response.label 
					   		: '<xsl:value-of select="$newPanelTitle" />';
					   		
		               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
		                   <xsl:value-of select="$panelID"/>
		                   <xsl:text>,'</xsl:text>
		                   <xsl:apply-templates select="$element" mode="element-script-detail"/>
		                   <xsl:text>',elemLabel,</xsl:text>
		                   <xsl:text>{editor:'</xsl:text>
		                   <xsl:apply-templates select="$element" mode="element-application-editor"/>
		                   <xsl:text>',app:'</xsl:text>
		                   <xsl:apply-templates select="$element" mode="element-application"/>
		                   <xsl:text>',module:response.module,ID:response.ID}</xsl:text>
		               <xsl:text>, 1);</xsl:text>
					});					
					fm.setScript('<xsl:apply-templates select="$element" mode="element-script-create"/>');
					fm.displayProcess('<xsl:value-of select="$processingMsg" />');		
					
					// makes a cleanup and moves the content from the editor to the form field
            		if (tinyMCE) tinyMCE.triggerSave();  
            
					fm.parseAndSend(this);		
					return false;
        		});
        
		        $('#<xsl:value-of select="$formID" />').find(':button#create-and-new-button').click(function() {
		          	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
		
					fm.onSuccess(function(response){
		               <xsl:text>$(AppController).panelslider('reloadPanel', </xsl:text>
		                   <xsl:value-of select="$panelID"/>
		               <xsl:text>, 1);</xsl:text>
					});						
					fm.setScript('<xsl:apply-templates select="$element" mode="element-script-create"/>');
		
					fm.displayProcess('<xsl:value-of select="$processingMsg" />');		  
					
		            // makes a cleanup and moves the content from the editor to the form field
		            if (tinyMCE) tinyMCE.triggerSave();  
		            
					fm.parseAndSend('#<xsl:value-of select="$formID" />');					
					return false;
		        });
			</xsl:when>
		<xsl:otherwise>
	        $('#<xsl:value-of select="$formID" />').submit(function() {
	          	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	          	fm.onSuccess(function(response){
	               <xsl:text>$(AppController).panelslider('refreshPanel', </xsl:text>
	                   <xsl:value-of select="$panelID"/>
                   <xsl:text>);</xsl:text>
				});					
				fm.setScript('<xsl:apply-templates select="$element" mode="element-script-update"/>');	
				fm.displayProcess('<xsl:value-of select="$processingMsg" />');	
				
				// makes a cleanup and moves the content from the editor to the form field
	            if (tinyMCE) tinyMCE.triggerSave();  
	            
				fm.parseAndSend(this);		
				return false;
	        });
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>
	
	<!-- element details : admin js -->
	<xsl:template name="panel-js-element-admin">
		<xsl:param name="element" />
		<xsl:param name="adminDenom" />
		<xsl:param name="deleteConfirm"  />
		<xsl:param name="deleteConfirmText" />
		<xsl:param name="duplicateRight" />
		<xsl:param name="deleteRight" />
		
		<xsl:variable name="adminFormID">
			<xsl:call-template name="gen-tabID">
				<xsl:with-param name="denom" select="$adminDenom" />
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:if test="$deleteRight=true()">
			<xsl:choose>
				<xsl:when test="$deleteConfirm=true()">
			        var confirmDialog<xsl:value-of select="$panelID" /> = new ModalDialog(
			            <xsl:value-of select="$panelID"/>,
			            AppController,
			            "#confirm-dialog-<xsl:value-of select="$panelID"/>",
			            {
			                bgiframe: true,
			                width: 500,
			                minHeight: 150,
			                autoOpen: false,
			            }
			        );
			        
			        confirmDialog<xsl:value-of select="$panelID" />.setCloseCallback(null);
			        confirmDialog<xsl:value-of select="$panelID" />.setCancelCallback('#cancel-button', null);
			        
			        confirmDialog<xsl:value-of select="$panelID" />.setOkCallback("#ok-button", function(){
			                fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
			
							fm.onSuccess(function(response){
			                    $(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>, 1);
							});
			
			                fm.displayProcess('Deleting element...');
			                fm.setScript('<xsl:apply-templates select="$element" mode="element-script-delete"/>');
			                fm.parse('#<xsl:value-of select="$adminFormID" />');
			                
			                this.hide();
							fm.send();
			        });
			        
			        $('#<xsl:value-of select="$adminFormID" />').submit(function() {
			        	confirmDialog<xsl:value-of select="$panelID" />.show();
			        	return false;
			        });
		        </xsl:when>
		        <xsl:otherwise>
			        $('#<xsl:value-of select="$adminFormID" />').submit(function() {
			            fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
			
						fm.onSuccess(function(response){
			            	$(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>, 1);
						});
			
			            fm.displayProcess('Deleting element...');
			            fm.setScript('<xsl:apply-templates select="$element" mode="element-script-delete"/>');
						fm.parseAndSend(this);
			
						return false;
			        });
		        </xsl:otherwise>
	        </xsl:choose>
        </xsl:if>
        
        <xsl:if test="$duplicateRight=true()">
	        $('#<xsl:value-of select="$adminFormID" />').find('#duplicate-button').click(function() {
	            fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
				fm.onSuccess(function(response){
					var elemLabel = (response.label) ? 
						response.label : 
						'<xsl:value-of select="name($element)"/> ('+response.ID+')'+' - Duplicata of <xsl:value-of select="name($element)"/> (<xsl:value-of select="$element/@ID"/>)';
						
	            	<xsl:text>$(AppController).panelslider('loadPanel', '</xsl:text>
		            	<xsl:apply-templates select="$element" mode="element-script-detail"/>
		            	<xsl:text>', {srcElem:this, parentID:</xsl:text>
		            	<xsl:value-of select="$panelID"/>
		            	<xsl:text>, title:elemLabel, app:'</xsl:text>
		            	<xsl:apply-templates select="$element" mode="element-application"/>
		            	<xsl:text>', editor:'</xsl:text>
		            	<xsl:apply-templates select="$element" mode="element-application-editor"/>
	            	<xsl:text>'}, {module:response.module, ID:response.ID});</xsl:text>
				});
	
	            fm.displayProcess('Duplicating element...');
	            fm.setScript('<xsl:apply-templates select="$element" mode="element-script-duplicate"/>');
				fm.parseAndSend($('#<xsl:value-of select="$adminFormID" />'));
	
				return false;
	        });
        </xsl:if>
	</xsl:template>
</xsl:stylesheet>