<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.navigation.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
    
	<!--  NAVIGATION PANEL -->
	<xsl:template name="panel-navigation">
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" select="''" />
		<xsl:param name="fixedBodyHeight" select="''" />
		<xsl:param name="panelcssclass" />
		
		<div class="panel-title-bar">
			<xsl:call-template name="panel-title-bar"/>
		</div>
        <div class="panel-header">
        	<xsl:if test="$fixedHeaderHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedHeaderHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
        	<xsl:call-template name="panel-header-navigation"/>
       	</div>
       	<div class="panel-body" optimal-width="{$optimalWidth}">
        	<xsl:if test="$fixedBodyHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedBodyHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
        	<xsl:call-template name="panel-body-loader"/>
			<div class="block block-nav">
				<xsl:call-template name="panel-body-navigation"/>
			</div>
        </div>
        <script type="text/javascript">
        	<xsl:call-template name="panel-js-navigation">
        		<xsl:with-param name="panelcssclass" select="$panelcssclass"/>
        	</xsl:call-template>
        	<xsl:call-template name="panel-add-js"/>
        </script>
    </xsl:template>
    
    <!-- navigation header -->
	<xsl:template name="panel-header-navigation">
	</xsl:template>
	
	<!-- navigation body -->
	<xsl:template name="panel-body-navigation">
	</xsl:template>
	
	<!-- navigation js -->
	<xsl:template name="panel-js-navigation">
		<xsl:param name="panelcssclass" />
		
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:value-of select="$panelcssclass"/>');
	</xsl:template>
</xsl:stylesheet>