<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.resultslist.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
    
	<!--  RESULTS LIST PANEL -->
	<xsl:template name="panel-results"> 
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" select="''" />
		<xsl:param name="fixedBodyHeight" select="''" />
		<xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
		<xsl:param name="module" select="/RESPONSE/URL/module" />
        <xsl:param name="addNew" select="true()" />
        <xsl:param name="addNewScript">
	        <xsl:choose>
				<xsl:when test="$list/*[1]">
					<xsl:apply-templates select="$list/*[1]" mode="element-script-new" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>../../system/tools/element/New</xsl:text>
				</xsl:otherwise>
			</xsl:choose>        	
        </xsl:param>
        <xsl:param name="pagingStyle" select="'browser'"/>
        <xsl:param name="params"  />
        <xsl:param name="panelcssclass" />

        <xsl:choose>
            <xsl:when test="/RESPONSE/URL/page">
                <xsl:call-template name="panel-body-results">
                	<xsl:with-param name="list" select="$list" />
                	<xsl:with-param name="module" select="$module" />
                	<xsl:with-param name="addNew" select="$addNew" />
                	<xsl:with-param name="addNewScript" select="$addNewScript" />
                	<xsl:with-param name="pagingStyle" select="$pagingStyle" />
               	</xsl:call-template>       
            </xsl:when>
            <xsl:otherwise>
				<div class="panel-title-bar">
					<xsl:call-template name="panel-title-bar"/>
				</div>
		        <div class="panel-header">
		        	<xsl:if test="$fixedHeaderHeight!=''">
		        		<xsl:attribute name="style">
		        			<xsl:text>height:</xsl:text>
		        			<xsl:value-of select="$fixedHeaderHeight" />
		        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
		        		</xsl:attribute>
		        	</xsl:if>
		        	<xsl:call-template name="panel-header-results"/>
		       	</div>
		       	<div class="panel-body" optimal-width="{$optimalWidth}">
		        	<xsl:if test="$fixedBodyHeight!=''">
		        		<xsl:attribute name="style">
		        			<xsl:text>height:</xsl:text>
		        			<xsl:value-of select="$fixedBodyHeight" />
		        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
		        		</xsl:attribute>
		        	</xsl:if>
		        	<xsl:call-template name="panel-body-loader"/>
					<div class="block block-nav">
		                <xsl:call-template name="panel-body-results">
		                	<xsl:with-param name="list" select="$list" />
		                	<xsl:with-param name="module" select="$module" />
		                	<xsl:with-param name="addNew" select="$addNew" />
		                	<xsl:with-param name="addNewScript" select="$addNewScript" />
		                	<xsl:with-param name="pagingStyle" select="$pagingStyle" />
		               	</xsl:call-template>
					</div>
		        </div>
                <script type="text/javascript">
					<xsl:call-template name="panel-js-results">
						<xsl:with-param name="module" select="$module" />
						<xsl:with-param name="params" select="$params" />
						<xsl:with-param name="panelcssclass" select="$panelcssclass"/>						
					</xsl:call-template>
					<xsl:call-template name="panel-add-js"/>
                </script>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- results header -->
    <xsl:template name="panel-header-results">
    </xsl:template>
    
    <!-- results body -->
	<xsl:template name="panel-body-results">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        <xsl:param name="pagingStyle" />
        
        <xsl:choose>
	        <xsl:when test="$pagingStyle='browser'">
		        <xsl:call-template name="list-browser">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
	        <xsl:when test="$pagingStyle='pager'">
		        <xsl:call-template name="list-pager">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
        </xsl:choose>
        
		<xsl:call-template name="panel-list-header-results">
	        <xsl:with-param name="list" select="$list" />
	        <xsl:with-param name="module" select="$module" />
	        <xsl:with-param name="addNew" select="$addNew" />
	        <xsl:with-param name="addNewScript" select="$addNewScript" />
		</xsl:call-template>
        
		<xsl:call-template name="panel-list-results">
			<xsl:with-param name="list" select="$list"/>
		</xsl:call-template>

        <xsl:choose>
	        <xsl:when test="$pagingStyle='browser'">
		        <xsl:call-template name="list-browser">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
	        <xsl:when test="$pagingStyle='pager'">
		        <xsl:call-template name="list-pager">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
        </xsl:choose>
	</xsl:template>
	
	<!-- results list header -->
	<xsl:template name="panel-list-header-results">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        
		<xsl:if test="boolean($addNew)=true()">
	        <xsl:call-template name="nav-new">
	            <xsl:with-param name="title">Create new...</xsl:with-param>
	            <xsl:with-param name="module" select="$module" />
	            <xsl:with-param name="panelURI" select="$addNewScript" />
	            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
	        </xsl:call-template>
        </xsl:if>
	</xsl:template>
	
	<!-- results list -->
	<xsl:template name="panel-list-results">
		<xsl:param name="list" />
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
                <xsl:for-each select="$list/*">
                    <xsl:apply-templates select="." mode="element-navitem" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:text>No hits</xsl:text>
                    <xsl:if test="/RESPONSE/MESSAGE[@msgType!='0']">
                		<br />
                		<span style="font-size:0.6em;">
                			<xsl:text>Warning: </xsl:text>
                			<xsl:value-of select="/RESPONSE/MESSAGE[@msgType!='0']" />
               			</span>
                	</xsl:if>
                </div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<!-- results js -->
	<xsl:template name="panel-js-results">
		<xsl:param name="module" />
		<xsl:param name="params" />
		<xsl:param name="panelcssclass" />
		
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:value-of select="$panelcssclass"/>');
	
        var loadPageRequest<xsl:value-of select="$panelID"/> = new AjaxRequest(
            <xsl:value-of select="$panelID"/>,
            AppController,
            '../../<xsl:value-of select="/RESPONSE/URL/editor"/>/<xsl:value-of select="/RESPONSE/URL/app"/>/<xsl:value-of select="/RESPONSE/URL/panelURI"/>.php',
            'POST',
            'html'
        );
            
        $('#<xsl:value-of select="$panelID"/>.panel').bind('loadpage', function(eventObject, page){
            $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'body']);

            loadPageRequest<xsl:value-of select="$panelID"/>.setData({
                panelID : <xsl:value-of select="$panelID"/>,
                app : '<xsl:value-of select="/RESPONSE/URL/app" />',
                editor : '<xsl:value-of select="/RESPONSE/URL/editor" />',
                module : '<xsl:value-of select="$module"/>',
                page : page
                <xsl:if test="$params">
                	<xsl:text>,</xsl:text>
                	<xsl:value-of select="$params" />
                </xsl:if>
            });

            loadPageRequest<xsl:value-of select="$panelID"/>.onSuccess(function(response){
            	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']).trigger('panel-blockcontent', ['.block-nav', response]);
            }).onError(function(response){
				$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']).trigger('panel-blockcontent', ['.block-nav', response]);
            }).send();

            return false;
        });
	</xsl:template>
</xsl:stylesheet>