  <?php
	require_once(dirname(__FILE__).'/include.php');

    /* *** */

    $response = new JSONResponse();
    $response->set('module', 'OFFICITY:REPORT');

    $REPORT_TYPE = $_POST['exportFormat'];
    if (!in_array($REPORT_TYPE, array('csv', 'pdf')))
    {
        $response->outputError('Invalid report type : "'.$REPORT_TYPE.'"');
    }
    $response->set('exportFormat', $REPORT_TYPE);
    
    $REPORT_MODEL_ID = $_POST['reportID'];
    if (empty($REPORT_MODEL_ID))
    {
        $response->outputError('No report ID!');
    }
    $response->set('reportID', $REPORT_MODEL_ID);

    $MODULE_NAME = strtoupper($_POST['module']);
    if (empty($MODULE_NAME))
    {
        $response->outputError('No module specified!');
    }
    $response->set('targetModule', $MODULE_NAME);

    $element = new Element($MODULE_NAME);

    /* *** */

    $report = new ReportElement($REPORT_MODEL_ID);
	if ($report->get() == false)
    {
        $response->outputError('Get failed: '.$report->getLastError());
    }

    $result = '';

    switch ($REPORT_TYPE)
    {
        case 'pdf':
            $report->setInfo('TITLE', $_POST['title']);
            $response->set('title', $_POST['title']);

            $date = nql_date($_POST['date']);
            $report->setInfo('DATE', $date);
            $response->set('date', $date);
            
            $report->setInfo('HEADER', $_POST['header']);
            $response->set('header', $_POST['header']);

            $report->setInfo('FOOTER', $_POST['footer']);
            $response->set('fontSize', $FONT_SIZE);

            if ($report->getInfo('FIXED') == 0)
            {
                $use_current_display = ($_POST['useCurrentDisplay'] == '1');

                $FONT_SIZE = $_POST['fontSize'];
                if (!empty($FONT_SIZE))
                {
                    $report->setInfo('FONTSIZE', $FONT_SIZE);
                    $response->set('fontSize', $FONT_SIZE);
                }

                $FORMAT = $_POST['format'];
                if (!empty($FORMAT))
                {
                    $report->setInfo('FORMAT', $FORMAT);
                    $response->set('format', $FORMAT);
                }

                $ORIENTATION = $_POST['orientation'];
                if (!empty($ORIENTATION))
                {
                    $report->setInfo('ORIENTATION', $ORIENTATION);
                    $response->set('orientation', $ORIENTATION);
                }
            }
            else
            {
                $use_current_display = false;
            }
            $response->set('useCurrentDisplay', $use_current_display);

            // handle the "single-module-element-report-case"
            $ITEM_ID = $_POST['ID'];
            $restore_report_filter = !empty($ITEM_ID);
            $response->set('single element ID', $ITEM_ID);

            $result = $element->export2PDF($report, $use_current_display, $restore_report_filter);
            break;

        case 'csv':
            $report->setInfo('TITLE', $_POST['title']);

            if ($report->getInfo('FIXED') == 0)
            {
                $use_current_display = ($_POST['useCurrentDisplay'] == '1');
            }
            else
            {
                $use_current_display = false;
            }
            $response->set('useCurrentDisplay', $use_current_display);

            $encoding = $_POST['encoding'];
            if (!in_array($encoding, array('windows', 'utf8')))
            {
                $response->outputError('Invalid encoding type : "'.$encoding.'"');
            }
            $response->set('encoding', $encoding);

            $separator = $_POST['separator'];
            if (!in_array($separator, array('semicolon', 'comma')))
            {
                $response->outputError('Invalid separator type : "'.$separator.'"');
            }
            $response->set('separator', $separator);

            $result = $element->export2CSV($report, $use_current_display, $encoding, $separator);
            break;

        default:
            break;
    }

    if ($result === false)
    {
        $response->outputError('Export failed: '.$element->getLastError());
    }
    else
    {
        $response->outputSuccess($result);
    }
?>