<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/pdf/international-labels-fo.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
	<xsl:output method="xml" indent="no" encoding="utf-8"/>
	<xsl:strip-space elements="*"/>

	<!-- setting template params -->
	<xsl:param name="formats" select="document('international-labels.xml')/postaladdresses"/>
	<xsl:param name="countries" select="/RESPONSE/RESULTS[@name='countries']/COUNTRY"/>

	<xsl:template name="international-labels-fo">
		<xsl:param name="address"/>
		<xsl:variable name="format" select="$formats/format[country = $address/INFO/COUNTRYID]"/>
		<xsl:for-each select="$format/line">
			<fo:block xsl:use-attribute-sets="address">
				<xsl:apply-templates>
					<xsl:with-param name="address" select="$address"/>
				</xsl:apply-templates>
			</fo:block>
		</xsl:for-each>
		<fo:block xsl:use-attribute-sets="address">
			<xsl:value-of select="$countries[@ID=current()/INFO/COUNTRYID]/LABEL"/>
		</fo:block>
	</xsl:template>

	<xsl:template match="string">
		<xsl:param name="address"/>
		<xsl:value-of select="text()"/>
	</xsl:template>

	<xsl:template match="street">
		<xsl:param name="address"/>
		<xsl:value-of select="@pre"/>
		<xsl:value-of select="$address/INFO/ADDRESS"/>
		<xsl:value-of select="@post"/>
	</xsl:template>

	<xsl:template match="postalcode">
		<xsl:param name="address"/>
		<xsl:value-of select="@pre"/>
		<xsl:value-of select="$address/INFO/POSTALCODE"/>
		<xsl:value-of select="@post"/>
	</xsl:template>

	<xsl:template match="city">
		<xsl:param name="address"/>
		<xsl:value-of select="@pre"/>
		<xsl:value-of select="$address/INFO/CITY"/>
		<xsl:value-of select="@post"/>
	</xsl:template>

	<xsl:template match="state">
		<xsl:param name="address"/>
		<xsl:value-of select="@pre"/>
		<xsl:value-of select="$address/INFO/STATEORPROVINCE"/>
		<xsl:value-of select="@post"/>
	</xsl:template>

</xsl:stylesheet>
