<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/search/load-search-info.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');

    $_GET += $_POST; // just in case...

    /* *** */

    $INFO_TYPE = $_GET['request'];
    if (empty($INFO_TYPE))
    {
        die('ERROR : no info type');
    }

    $xsl_file = dirname(__FILE__).'/search-info-'.$INFO_TYPE.'.xsl';
    if (!file_exists($xsl_file))
    {
         die('ERROR : XSL file for info type "'.$INFO_TYPE.'" not found');
    }

    /* *** */

    $nql = new Officity_Shell();

	$field_infos = explode('_', $_GET['fieldType'], 3);
    $field_type = $field_infos[0];
	
    switch ($field_type)
    {
        case 'list':
            $list_name = $field_infos[1];
            if (empty($list_name))
            {
                die('ERROR : no list name!');
            }

            $nql->addCommand('
                <SEARCH name="'.$list_name.'" refresh="daily">
                    <LIST name="'.$list_name.'"/>
                </SEARCH>
            ');

            $_GET['fieldType'] = $field_type;
            $_GET['listName'] = $list_name;
            break;

        case 'systemList':
            $list_name = $field_infos[1];
            if (empty($list_name))
            {
                die('ERROR : no system list name!');
            }

            switch ($list_name)
            {
                case 'Countries':                    
                    $nql->addCommand('
                        <GET name="'.$list_name.'" refresh="monthly">
                            <COUNTRIES/>
                        </GET>
                    ');
                    break;

                case 'Languages':
                    $nql->addCommand('
                        <GET name="'.$list_name.'" refresh="monthly">
                            <LANGUAGES profile="SmallList"/>
                        </GET>
                    ');
                    break;

                default:
                    break;
            }

            $_GET['fieldType'] = $field_type;
            $_GET['listName'] = $list_name;
            break;

        case 'elementsList':            
            $module = $field_infos[1];
            if (empty($module))
            {
                die('ERROR : no module specified!');
            }

            $field = strtoupper($field_infos[2]);

            $nql->addCommand('
                <SEARCH name="'.$module.'" refresh="daily">
                    <'.strtoupper($module).'/>
                    <RETURN>
                        <INFO>
                            <'.$field.' />
                        </INFO>
                    </RETURN>
                </SEARCH>
            ');

            $_GET['fieldType'] = $field_type;
            $_GET['listName'] = $module;
            $_GET['elemsListFieldDenom'] = $field;
            break;
            
        case 'date':
        	$_GET['operand1'] = nql_date($_GET['operand1']);
        	$_GET['operand2'] = nql_date($_GET['operand2']);
        	break;
        	
        case 'datetime':
        	$_GET['operand1'] = nql_datetime($_GET['operand1']);
        	$_GET['operand2'] = nql_datetime($_GET['operand2']);
        	break;
        	
        case 'dephits':
        	$_GET['fieldType'] = 'dephits';
        	$operand1 = trim($_GET['operand1']);
        	if (!empty($operand1))
        	{
        		$_GET['operand1'] = abs($operand1); // only >= 0
        	}
        	break;

        default:
            break;
    }

    // cosmetics : clear operands in case of the 'since' operator used for dates
    if (in_array($_GET['operand2'], array('days', 'months', 'years')))
    {
        unset($_GET['operand1']);
        unset($_GET['operand2']);
    }

    echo $nql->transform($xsl_file);
?>