<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/search/search-resources-distinct-cmds.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output encoding="UTF-8" method="xml" indent="no" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>

    <xsl:param name="search-config" select="/RESPONSE/RESULTS[@name='search-config']/CONFIGXML"/>
	<xsl:param name="search-filter" select="/RESPONSE/RESULTS[@name='search-filter']"/>
	<xsl:param name="filter-fields" select="$search-filter/INFO/DISPLAYXML//INFO/*"/>

	<xsl:template match="/RESPONSE">
        <!-- step 1 : distinct list commands -->
        <xsl:apply-templates select="RESULTS[@name='commands']/*"/>
        <!-- step 2 : filter fields definitions (display only) -->
		<SEARCH refresh="daily">
			<FIELD>
				<xsl:apply-templates select="$filter-fields" mode="filter-display"/>
			</FIELD>
			<RETURN>
				<INFO>
					<MODULE/>
					<DENOMINATION/>
					<TYPE/>
					<LISTNAME/>
					<TARGETMODULE/>
					<TARGETFIELD/>
					<DISPLAYLENGTH/>
				</INFO>
				<DESCRIPTION>
					<TITLE/>
					<SUMMARY/>
				</DESCRIPTION>
			</RETURN>
		</SEARCH>
    </xsl:template>

    <xsl:template match="SEARCH[not(@name=preceding-sibling::SEARCH/@name)]">
        <xsl:copy-of select="."/>
    </xsl:template>
    
    <xsl:template match="SEARCH">
    </xsl:template>

    <xsl:template match="GET[not(@name=preceding-sibling::GET/@name)]">
        <xsl:copy-of select="."/>
    </xsl:template>
    
    <xsl:template match="GET">
    </xsl:template>

	<xsl:template match="*[not(ancestor::DEPENDENCY)]" mode="filter-display">
		<INFO>
			<MODULE operator="=">
				<xsl:value-of select="$search-filter/INFO/MODULE"/>
			</MODULE>
			<DENOMINATION operator="=">
				<xsl:value-of select="name(.)"/>
			</DENOMINATION>
		</INFO>
	</xsl:template>

	<xsl:template match="*[ancestor::DEPENDENCY]" mode="filter-display">
		<INFO>
			<MODULE operator="=">
				<xsl:value-of select="$search-config//DEPENDENCY[TYPE=current()/../../@type]/MODULE"/>
			</MODULE>
			<DENOMINATION>
				<xsl:value-of select="name(.)"/>
			</DENOMINATION>
		</INFO>
	</xsl:template>
</xsl:stylesheet>