<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/xsl/v2/concatenator.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:import href="string.xsl"/>
    <xsl:output encoding="utf-8" method="xml" indent="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:param name="initial-path" />
	
	<xsl:template match="/xsl:stylesheet">
		<stylesheets>
			<!-- copy attributes and namespaces of the starting stylesheet -->
			<xsl:copy-of select="./namespace::*"/>
			<xsl:copy-of select="./attribute::*"/>
			<!-- copy the attributes and namespaces of all included stylesheets -->
			<xsl:apply-templates select="xsl:import|xsl:include" mode="flatten-attributes"/>
			<!-- copy the content of all stylesheets in one big xml -->
			<!-- 1. imports/includes -->
			<xsl:apply-templates select="xsl:import|xsl:include" mode="concat-stylesheets">
				<xsl:with-param name="absolute" select="$initial-path"/>
			</xsl:apply-templates>
			<!-- 2. copy original stylesheet -->
			<stylesheet>
				<!-- copy the content of the starting stylesheet -->
				<xsl:apply-templates select="*[name() != 'xsl:import' and name() != 'xsl:include']" mode="concat-stylesheets"/>
			</stylesheet>
		</stylesheets>
    </xsl:template>

	<xsl:template match="xsl:import|xsl:include" mode="flatten-attributes">
		<xsl:variable name="path" select="@href"/>
		<xsl:variable name="stylesheet" select="document($path)/xsl:stylesheet"/>

		<!-- copy the attributes and namespaces of the imported stylesheet -->
		<xsl:copy-of select="$stylesheet/namespace::*"/>
		<xsl:copy-of select="$stylesheet/attribute::*"/>
		
		<!-- recursively for all further imported stylesheets  -->
		<xsl:apply-templates select="$stylesheet/xsl:import|xsl:include" mode="flatten-attributes"/>
    </xsl:template>

	<!-- XSLT Stylesheet concatenation -->

	<xsl:template match="xsl:import|xsl:include" mode="concat-stylesheets">
		<xsl:param name="absolute" select="''"/>

		<xsl:variable name="path" select="@href"/>
		
		<xsl:variable name="folder-path">
			<xsl:choose>
				<xsl:when test="contains($path,'/')">
					<xsl:call-template name="substring-before-last">
						<xsl:with-param name="text" select="$path"/>
						<xsl:with-param name="chars" select="'/'"/>
					</xsl:call-template>
					<xsl:text>/</xsl:text>
				</xsl:when>
				<xsl:otherwise/>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="file">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="text" select="$path"/>
				<xsl:with-param name="chars" select="'/'"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="absolute-up-path">
			<xsl:if test="starts-with($absolute,'../')">
				<xsl:call-template name="substring-before-last">
					<xsl:with-param name="text" select="$absolute"/>
					<xsl:with-param name="chars" select="'../'"/>
				</xsl:call-template>
				<xsl:text>../</xsl:text>
			</xsl:if>
		</xsl:variable>
	
		<xsl:variable name="absolute-down-path">
			<xsl:choose>
				<xsl:when test="starts-with($absolute,'../')">
					<xsl:call-template name="substring-after-last">
						<xsl:with-param name="text" select="$absolute"/>
						<xsl:with-param name="chars" select="'../'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$absolute"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="go-up-path">
			<xsl:if test="starts-with($folder-path,'../')">
				<xsl:call-template name="substring-before-last">
					<xsl:with-param name="text" select="$folder-path"/>
					<xsl:with-param name="chars" select="'../'"/>
				</xsl:call-template>
				<xsl:text>../</xsl:text>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="go-down-path">
			<xsl:choose>
				<xsl:when test="starts-with($folder-path,'../')">
					<xsl:call-template name="substring-after-last">
						<xsl:with-param name="text" select="$folder-path"/>
						<xsl:with-param name="chars" select="'../'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$folder-path"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="new-absolute">
			<xsl:choose>
				<!-- we do not go up, easy, we simply add go down to the current absolute path -->
				<xsl:when test="$go-up-path = ''">
					<xsl:value-of select="$absolute"/>
					<xsl:value-of select="$folder-path"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- we go up -->
					<xsl:choose>
						<!-- we go up and there is already a go down path in absolute -->
						<xsl:when test="not($absolute-down-path = '')">

							<!-- we have to remove from absolute-down-path as much folder as ../ in go-up -->

							<xsl:variable name="merging">
								<xsl:call-template name="merge-paths">
									<!-- <xsl:with-param name="down-path" select="$absolute-down-path"/> -->
									<xsl:with-param name="down-path" select="substring($absolute-down-path,1,string-length($absolute-down-path)-1)"/>
									<xsl:with-param name="up-path" select="$go-up-path"/>
								</xsl:call-template>
							</xsl:variable>

							<xsl:value-of select="$absolute-up-path"/>
							<xsl:value-of select="$merging"/>
							<xsl:value-of select="$go-down-path"/>

						</xsl:when>
						<!-- we go-up and there is no absolute-down, easy, we just concat all. -->
						<xsl:otherwise>
							<xsl:value-of select="$absolute"/>
							<xsl:value-of select="$folder-path"/>
						</xsl:otherwise>
					</xsl:choose>

				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- resolve the absolute path -->
		<xsl:variable name="absolute-path" select="concat($new-absolute,$file)"/>

		<!-- create xml document -->
		<xsl:variable name="stylesheet" select="document($absolute-path)/xsl:stylesheet"/>

		<!-- concat imports/includes -->
		<xsl:apply-templates select="$stylesheet/xsl:import|xsl:include" mode="concat-stylesheets">
			<xsl:with-param name="absolute" select="$new-absolute"/>
		</xsl:apply-templates>
		
		<!-- create a stylesheet node -->
		<stylesheet>
			<!-- store the path for distinct resolution -->
			<xsl:attribute name="absolute-path">
				<xsl:value-of select="$absolute-path"/>
			</xsl:attribute>
			<xsl:attribute name="relative-path">
				<xsl:value-of select="$path"/>
			</xsl:attribute>
			<!-- copy the content -->
			<xsl:apply-templates select="$stylesheet/*[name() != 'xsl:import' and name() != 'xsl:include']" mode="concat-stylesheets"/>
		</stylesheet>
    </xsl:template>

	<xsl:template name="merge-paths">
		<xsl:param name="down-path" />
		<xsl:param name="up-path" />

		<xsl:choose>
			<xsl:when test="$up-path != '' and $down-path != ''">
				<xsl:choose>
					<xsl:when test="contains($down-path,'/')">
						<!-- not in the current stylesheet folder -->
						<!-- recursively remove as much down as there is up -->
						<xsl:call-template name="merge-paths">
							<xsl:with-param name="down-path">
								<xsl:call-template name="substring-before-last">
									<xsl:with-param name="text" select="$down-path"/>
									<xsl:with-param name="chars" select="'/'"/>
								</xsl:call-template>
							</xsl:with-param>
							<xsl:with-param name="up-path" select="substring-after($up-path,'../')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<!-- we go up to the current stylesheet folder -->
						<!-- just remove one up command, that's it -->
						<xsl:value-of select="substring-after($up-path,'../')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$up-path"/>
				<xsl:value-of select="$down-path"/>
				<xsl:if test="$down-path != ''">
					<xsl:text>/</xsl:text>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>
	
	<xsl:template match="*[name() != 'xsl:import' and name() != 'xsl:include']" mode="concat-stylesheets">
		<xsl:copy-of select="."/>
	</xsl:template>

</xsl:stylesheet>