<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/updates/20090312-stats-v4/converterWeblogs.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/

include_once(dirname(__FILE__)."/../../../common/common_functions.inc.php");
$db_conn = db_connect();
$nb_logs=$_GET['nbLogs'];
$sql='SELECT * FROM weblogs_cp ORDER BY CreationDate ASC LIMIT '.$nb_logs.';';
debug_log($sql);
$rs=$db_conn->Execute($sql);

$sql='DELETE FROM weblogs_cp ORDER BY CreationDate ASC LIMIT '.$nb_logs.';';
debug_log($sql);
$db_conn->Execute($sql);

if ($rs->RecordCount() == 0){
	include_once(dirname(__FILE__)."/../../../common/nql.class.php");
	
	$nql = new NQL();
	$nql->addCommand('
		<CREATE>
			<BATCH>
				<INFO>
					<DOMAIN>webConverterEnd</DOMAIN>
					<DENOMINATION>End of cron weblog converter</DENOMINATION>
					<TYPE>url</TYPE>
					<COMMAND>http://'.$_SERVER['HTTP_HOST'].'/Kernel/Library/updates/20090312-stats-v4/converterWeblogsEnd.php</COMMAND>
					<STATUS>pending</STATUS>
				</INFO>
			</BATCH>
		</CREATE>
	');
	$nql->execute();
}
include_once(dirname(__FILE__)."/../../../common/visit_log.class.php");
include_once(dirname(__FILE__)."/../../../common/web_log.class.php");

if(!is_dir(dirname(__FILE__)."/../../../../Files/stats")){
	mkdir(dirname(__FILE__)."/../../../../Files/stats");
}
if(!$file=fopen(dirname(__FILE__)."/../../../../Files/stats/weblogs.sql","a")){
	include_once(dirname(__FILE__)."/../../../common/nql.class.php");
	
	$nql = new NQL();
	$nql->addCommand('
		<CREATE>
			<BATCH>
				<INFO>
					<DOMAIN>converterProblem</DOMAIN>
					<DENOMINATION>converterProblem</DENOMINATION>
					<TYPE>nql</TYPE>
					<COMMAND>
					<DELETE>
						<CRON>
							<WHERE>
								<INFO>
									<DOMAIN>webstatconverter</DOMAIN>
								</INFO>
							</WHERE>
						</CRON>
					</DELETE>
					</COMMAND>
					<STATUS>pending</STATUS>
				</INFO>
			</BATCH>
		</CREATE>');
	$nql->execute();
	include_once(dirname(__FILE__)."/../../../common/nql.class.php");
	
	$nql = new NQL();
	$nql->addCommand('
		<CREATE>
			<SERVERMAIL>
				<SENDER email="jonathan@officity.com">jonathan</SENDER>
				<RECIPIENT>jonathan@officity.com</RECIPIENT>
				<RECIPIENT>francois@officity.com</RECIPIENT>
				<RECIPIENT>boris@officity.com</RECIPIENT>
				<SUBJECT>interuption de portage</SUBJECT>
				<BODY>le portage du site '.$_SERVER['HTTP_HOST'].' à été interompu ! Le fichier /Files/stats/weblogs.sql n\'as peu etre ouvert.</BODY>
			</SERVERMAIL>
		</CREATE>');
	$nql->execute();
}

$sql = "SELECT * FROM `weblogs` WHERE 1=-1;";
$pseudo_rs = $db_conn->Execute($sql);

while($row = $rs->FetchRow()){
	$insert_sql = $db_conn->GetInsertSQL($pseudo_rs,$row);
	fwrite($file, $insert_sql.";\n");
	$userAgent=$row['UserAgent'];
	$ip=$row['IP'];
	$host=$row['Host'];
	$today=$row['CreationDate'];
	$user_id=$row['userID'];
	$element_id=$row['elementID'];
	$viewing_code=$row['ViewingCode'];
	$language=$row['LanguageID'];
	$remote_host=$row['provider'];
	$path=$row['URL'];
	$referer=$row['fromURL'];
	$referrerCode=$row['referrerCode'];
	$bannerCode=$row['bannerCode'];

	if(substr($today,0,4)>2003){
		$sql="SELECT * FROM logs_web_years WHERE year=".substr($today,0,4).";";
		$table = $db_conn->getRow($sql);
		if(!$table){
			$sql="
			INSERT INTO logs_web_years (year) VALUES (".substr($today,0,4).");";
			debug_log($sql);
			$db_conn->Execute($sql);

			$sql="
			CREATE TABLE IF NOT EXISTS logs_web_".substr($today,0,4)." (
				month tinyint(1) NOT NULL DEFAULT '0',
				day tinyint(1) NOT NULL DEFAULT '0',
				hours tinyint(1) NOT NULL DEFAULT '0',
				minutes tinyint(1) NOT NULL DEFAULT '0',
				seconds tinyint(1) NOT NULL DEFAULT '0',
				VisitID bigint(20) NOT NULL DEFAULT '0',
				URL bigint(20) NOT NULL DEFAULT '0' REFERENCES referer_page(ID),
				elementID bigint(20) NOT NULL DEFAULT '0',
				ViewingCode varchar(250) NOT NULL DEFAULT '',
				LanguageID varchar(10) NOT NULL DEFAULT '',
				referrerHost bigint(20) NOT NULL DEFAULT '0' REFERENCES referer(ID),
				referrerPage bigint(20) NOT NULL DEFAULT '0' REFERENCES referer_page(ID),
				isSearch tinyint(1) NOT NULL DEFAULT '0',
				keyword text NOT NULL DEFAULT '',
				referrerCode varchar(255) NOT NULL DEFAULT '',
				bannerCode varchar(255) NOT NULL DEFAULT '',
				KEY(month, day),
				KEY(VisitID)
			) TYPE=MyISAM;";
			$db_conn->Execute($sql);
		}
		$visit=new visit_log('', $today, $host,
			$ip, $userAgent, $remote_host, $user_id, $language);
		
		$visit->save();
		if(!$visit->is_bot){
			$web_log=new web_log($today, $host, $path, $element_id, $viewing_code, $language,
				$referer, $referrerCode, $bannerCode);

			$web_log->visit_id=$visit->visit_id;
			$web_log->save();
		}
	}
}
$file=fclose($file);
echo 'OK';
?>
