<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/updates/20090312-stats-v4/converterWeblogsCreateTable.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
include_once(dirname(__FILE__)."/../../../common/common_functions.inc.php");

$db_conn = db_connect();
$sql="
CREATE TABLE IF NOT EXISTS host (
	ID bigint(20) auto_increment,
	DomainName varchar(255) NOT NULL UNIQUE DEFAULT '',
	PRIMARY KEY (ID)
) TYPE=MyISAM;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
CREATE TABLE IF NOT EXISTS referrer (
	ID bigint(20) auto_increment,
	DomainName varchar(255) NOT NULL UNIQUE DEFAULT '',
	PRIMARY KEY(ID)
) TYPE=MyISAM;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
CREATE TABLE IF NOT EXISTS referrer_page (
	ID bigint(20) auto_increment,
	referrer bigint(20) NOT NULL DEFAULT '0' REFERENCES referer(ID),
	URI TEXT NOT NULL DEFAULT '',
	isInnerURI tinyint(1) NOT NULL DEFAULT '0',
	PRIMARY KEY(ID)
) TYPE=MyISAM;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
CREATE TABLE IF NOT EXISTS logs_visit (
	VisitID bigint(20) NOT NULL auto_increment,
	VisitorID varchar(48) NOT NULL DEFAULT '',
	year smallint NOT NULL DEFAULT '0',
	month tinyint(1) NOT NULL DEFAULT '0',
	day tinyint(1) NOT NULL DEFAULT '0',
	startHours tinyint(1) NOT NULL DEFAULT '0',
	startMinutes tinyint(1) NOT NULL DEFAULT '0',
	startSeconds tinyint(1) NOT NULL DEFAULT '0',
	duration bigint(6) NOT NULL DEFAULT '0',
	NbPageVisited bigint(6) NOT NULL DEFAULT '0',
	Host bigint(20) NOT NULL DEFAULT '0' REFERENCES host(ID),
	IP varchar(15) NOT NULL DEFAULT '',
	Browser ENUM ('', 'microsoft internet explorer', 'msie', 'netscape6', 'netscape', 'galeon', 'phoenix', 'mozilla firebird',
	'firebird', 'chimera', 'camino', 'safari', 'k-meleon', 'mozilla', 'opera', 'konqueror', 'icab', 'lynx', 'links', 'ncsa mosaic',
	'amaya', 'omniweb', 'hotjava', 'browsex', 'amigavoyager', 'amiga-aweb', 'ibrowse') NOT NULL DEFAULT '',
	OS ENUM('', 'win', 'amiga', 'os2', 'iphone', 'mac', '*nix') NOT NULL DEFAULT '',
	isBot tinyint(1) NOT NULL DEFAULT '0',
	botName varchar(100) NOT NULL DEFAULT '',
	Provider varchar(100) NOT NULL DEFAULT '',
	countryID char(3) NOT NULL DEFAULT '',
	userID bigint(20) NOT NULL DEFAULT '0',
	LanguageID varchar(10) NOT NULL DEFAULT '',
	KEY(year, month, day, startHours, startMinutes, startSeconds),
	PRIMARY KEY(VisitID)
) TYPE=MyISAM;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
CREATE TABLE IF NOT EXISTS logs_web_years (
	year smallint NOT NULL DEFAULT '0',
	PRIMARY KEY(year)
) TYPE=MyISAM;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
INSERT INTO logs_web_years (year) VALUES (".date('Y').");";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
CREATE TABLE IF NOT EXISTS logs_web_".date('Y')." (
	month tinyint(1) NOT NULL DEFAULT '0',
	day tinyint(1) NOT NULL DEFAULT '0',
	hours tinyint(1) NOT NULL DEFAULT '0',
	minutes tinyint(1) NOT NULL DEFAULT '0',
	seconds tinyint(1) NOT NULL DEFAULT '0',
	VisitID bigint(20) NOT NULL DEFAULT '0',
	URL bigint(20) NOT NULL DEFAULT '0' REFERENCES referer_page(ID),
	elementID bigint(20) NOT NULL DEFAULT '0',
	ViewingCode varchar(250) NOT NULL DEFAULT '',
	LanguageID varchar(10) NOT NULL DEFAULT '',
	referrerHost bigint(20) NOT NULL DEFAULT '0' REFERENCES referer(ID),
	referrerPage bigint(20) NOT NULL DEFAULT '0' REFERENCES referer_page(ID),
	isSearch tinyint(1) NOT NULL DEFAULT '0',
	keyword text NOT NULL DEFAULT '',
	referrerCode varchar(255) NOT NULL DEFAULT '',
	bannerCode varchar(255) NOT NULL DEFAULT '',
	KEY(month, day),
	KEY(VisitID)
) TYPE=MyISAM;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

$sql="
CREATE TABLE IF NOT EXISTS weblogs_cp (
	CreationDate datetime NOT NULL default '0000-00-00 00:00:00',
	Host varchar(255) NOT NULL default '',
	URL text NOT NULL,
	IP varchar(15) NOT NULL default '',
	ViewingCode varchar(250) NOT NULL default '',
	UserAgent varchar(255) NOT NULL default '',
	elementID bigint(20) NOT NULL default '0',
	provider varchar(255) NOT NULL default '',
	fromURL text NOT NULL,
	parentID bigint(20) NOT NULL default '0',
	userID bigint(20) NOT NULL default '0',
	LanguageID varchar(10) NOT NULL default '',
	referrerCode varchar(255) NOT NULL default '',
	bannerCode varchar(255) NOT NULL default '',
	KEY CreationDate(CreationDate)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
debug_log($sql);
$db_conn->Execute($sql);
echo $db_conn->ErrorMsg();

copy(dirname(__FILE__).'/resources/common_functionsTEMP.inc.php', dirname(__FILE__).'/../../../common/common_functions.inc.php');
copy(dirname(__FILE__).'/resources/web_log.class.php', dirname(__FILE__).'/../../../common/web_log.class.php');
copy(dirname(__FILE__).'/resources/visit_log.class.php', dirname(__FILE__).'/../../../common/visit_log.class.php');
echo 'OK';
?>
