<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/xsl/contact.inc.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>

	<xsl:template match="CONTACT" mode="label">
		<xsl:choose>
			<xsl:when test="INFO/CONTACTTYPE = 'PP'">
				<xsl:call-template name="label-pp"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="label-pm"/>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>

	<xsl:template name="label-pp">
		<xsl:param name="contact" select="."/>
		<xsl:param name="info" select="$contact/INFO"/>
		<xsl:if test="$info/LASTNAME!=''"><xsl:value-of select="$info/LASTNAME"/><xsl:text> </xsl:text></xsl:if>
		<xsl:if test="$info/DENOMINATION!=''">"<xsl:value-of select="$info/DENOMINATION"/>"<xsl:text> </xsl:text></xsl:if>
		<xsl:if test="$info/FIRSTNAME!=''"><xsl:value-of select="$info/FIRSTNAME"/></xsl:if>
	</xsl:template>
	
	<xsl:template name="label-pm">
		<xsl:param name="contact" select="."/>
		<xsl:param name="info" select="$contact/INFO"/>
		<xsl:param name="titlevalue" select="$info/TITLE"/>
		<xsl:variable name="titlelabel" select="//ITEM[@value=$titlevalue]/@label"/>
		<xsl:variable name="title">
			<xsl:choose>
				<xsl:when test="$titlelabel!=''"><xsl:value-of select="$titlelabel"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$titlevalue"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$info/DENOMINATION!=''">
				<xsl:value-of select="$info/DENOMINATION"/>
				<xsl:if test="$title!=''"><xsl:text> </xsl:text><xsl:value-of select="$title"/></xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="CONTACT" mode="city">
		<xsl:if test="INFO/POSTALCODE!=''"><xsl:value-of select="INFO/POSTALCODE"/><xsl:text> - </xsl:text></xsl:if>
		<xsl:if test="INFO/CITY!=''"><xsl:value-of select="INFO/CITY"/></xsl:if>	
	</xsl:template>
	
	<xsl:template match="CONTACT" mode="country">
		<xsl:variable name="country" select="INFO/COUNTRYID"/>
		<xsl:value-of select="//COUNTRY[@ID=$country]/LABEL"/>
	</xsl:template>	
	
	<xsl:template match="CONTACT" mode="vat">
		<xsl:text>TVA: </xsl:text>
		<xsl:choose>
			<xsl:when test="INFO/VAT!=''"><xsl:value-of select="INFO/VAT"/></xsl:when>
			<xsl:otherwise><xsl:text>N/A</xsl:text></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
