<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/crypt.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");

class Crypt extends SusheeObject{
	var $algo;
	var $key;
	function Crypt($algo=false){
		$this->algo = $algo;
	}
	
	function setAlgo($algo){
		$this->algo = $algo;
	}
	
	function setKey($key){
		$this->key = $key;
	}
	
	function execute($string){
		$key = $this->key;
		switch($this->algo){
			case 'NECTIL_XOR_encryption': return $this->encrypt_XOR($string);
			case 'BLOWFISH':
				require_once(dirname(__FILE__).'/../common/Mail/blowfish.php');
				$blowfish = new Crypt_Blowfish($key);
				$encrypted_data = $blowfish->encrypt($string);
				return base64_encode($encrypted_data);
				break;
			case '':return $string;// no crypting
			default: return false;
		}
	}
	
	function encrypt_XOR($string) {
		$key = $this->key;
		$result = '';
		for($i=0; $i<strlen($string); $i++) {
			$char = substr($string, $i, 1);
			$keychar = substr($key, ($i % strlen($key))-1, 1);
			$char = chr(ord($char)+ord($keychar));
			$result.=$char;
		}
		return base64_encode($result);
	}
}

class Decrypt extends SusheeObject{
	var $algo;
	function Decrypt($algo=false){
		$this->algo = $algo;
	}
	
	function setAlgo($algo){
		$this->algo = $algo;
	}
	
	function setKey($key){
		$this->key = $key;
	}
	
	function execute($string){
		$key = $this->key;
		switch($this->algo){
			case 'NECTIL_XOR_encryption': return $this->decrypt_XOR($string);
			case 'BLOWFISH':
				require_once(dirname(__FILE__).'/../common/Mail/blowfish.php');
				$string = base64_decode($string);
				$blowfish = new Crypt_Blowfish($key);
				$decrypted_data = $blowfish->decrypt($string);
				return $decrypted_data;
				break;
			case '':return $string;// no crypting
			default: return false;
		}
	}
	
	function decrypt_XOR($string) {
		$key = $this->key;
		$result = '';
		$string = base64_decode($string);

		for($i=0; $i<strlen($string); $i++) {
			$char = substr($string, $i, 1);
			$keychar = substr($key, ($i % strlen($key))-1, 1);
			$char = chr(ord($char)-ord($keychar));
			$result.=$char;
		}
		return $result;
	}
}
?>