<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/fields.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
require_once(dirname(__FILE__)."/../common/datas_structure.class.php");

class FieldsCollection extends SusheeObject{
	
	var $fields = false;
	
	function FieldsCollection(){
		$this->fields = &new Vector();
	}
	
	function add(&$field){
		if(is_object($field))
			$this->fields->add($field->getName(),$field);
	}
	
	function reset(){
		if($this->fields)
			$this->fields->reset();
	}
	function &next(){
		return $this->fields->next();
	}
	
	function implode($separator=','){
		$this->fields->reset();
		$first = true;
		$str = '';
		while($field = $this->fields->next()){
			if(!$first){
				$str.=$separator;
			}
			$str.='`'.$field->getName().'`';
			$first = false;
		}
		return $str;
	}
}

class DBField extends SusheeObject{
	
	var $name = false;
	
	function DBField($name){
		$this->setName($name);
	}
	
	function setName($name){
		$this->name = $name;
	}
	
	function getName(){
		return $this->name;
	}
}

?>