<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/metasearch.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/datas_structure.class.php");

class Sushee_xSusheeCritMatch extends SusheeObject{
	var $xmlNode;
	var $includedIDs;
	var $excludedIDs;
	var $loaded = false;
	
	function Sushee_xSusheeCritMatch($xmlNode,$moduleID){
		$this->xmlNode = $xmlNode;
		$this->moduleID = $moduleID;
	}
	
	function emptyResult(){
		$this->includedIDs = array(-1);
		$this->excludedIDs = array();
	}
	
	
	function getElementsIncluded(){
		if(!$this->loaded)
			$this->execute();
		return $this->includedIDs;
	}
	
	function getElementsExcluded(){
		if(!$this->loaded)
			$this->execute();
		return $this->excludedIDs;
	}
	
	function getNode(){
		return $this->xmlNode;
	}
}

/*

Manage a group of criterias and manage how they will be mixed or intersected together to give the final list of element IDs

*/
class Sushee_xSusheeCritGroup extends Sushee_Object{
	var $name;
	var $vector;
	var $operator;
	
	function NQLCritGroup($name){
		$this->name = $name;
		$this->operator = 'OR';
		$this->loaded = false;
	}
	
	function getName(){
		return $this->name;
	}
	
	function setOperator($operator){
		$this->operator = $operator;
	}
	
	function add(&$nqlcrit){
		$this->vector[]=&$nqlcrit;
	}
	
	function execute(){
		$this->loaded = true;
		$includedIDs = false;
		$excludedIDs = false;
		foreach($this->vector as $nqlcrit){
			$crit_includedIDs = $nqlcrit->getElementsIncluded();
			$crit_excludedIDs = $nqlcrit->getElementsExcluded();
			//debug_log('group '.$this->getName().' adding '.implode(',',$crit_includedIDs).' matching node '.$nqlcrit->getNode()->toString());
			//debug_log('group '.$this->getName().' substracting '.implode(',',$crit_includedIDs).' matching node '.$nqlcrit->getNode()->toString());
			
			if($this->operator=='AND'){
				if($crit_includedIDs!==false){
					if($includedIDs!==false)
						$includedIDs = array_intersect($includedIDs,$crit_includedIDs);
					else
						$includedIDs = $crit_includedIDs;
				}else{ // using excludedIDs
					if($excludedIDs!==false)
						$excludedIDs = array_merge($excludedIDs,$crit_excludedIDs);
					else
						$excludedIDs = $crit_excludedIDs;
				}
			}else{
				if($crit_includedIDs!==false){
					if($includedIDs!==false)
						$includedIDs = array_merge($includedIDs,$crit_includedIDs);
					else
						$includedIDs = $crit_includedIDs;
				}else{ // using excludedIDs
					if($excludedIDs!==false)
						$excludedIDs = array_intersect($excludedIDs,$crit_excludedIDs);
					else
						$excludedIDs = $crit_excludedIDs;
				}
			}
		}
		if(sizeof($includedIDs)==0)
			$includedIDs[]=-1;
		$this->includedIDs = $includedIDs;
		$this->excludedIDs = $excludedIDs;
		
	}
	
	function getElementsIncluded(){
		if(!$this->loaded)
			$this->execute();
		return $this->includedIDs;
	}
	
	function getElementsExcluded(){
		if(!$this->loaded)
			$this->execute();
		return $this->excludedIDs;
	}
}



?>